/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.BuildEventListener;
import ch.nerdin.esbuild.BundleException;
import ch.nerdin.esbuild.Execute;
import ch.nerdin.esbuild.Watch;
import ch.nerdin.esbuild.model.BundleOptions;
import ch.nerdin.esbuild.model.BundleResult;
import ch.nerdin.esbuild.model.EsBuildConfig;
import ch.nerdin.esbuild.model.ExecuteResult;
import ch.nerdin.esbuild.resolve.ExecutableResolver;
import ch.nerdin.esbuild.util.Copy;
import ch.nerdin.esbuild.util.PackageJson;
import ch.nerdin.esbuild.util.UnZip;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bundler {
    private static final Logger logger = LoggerFactory.getLogger(Bundler.class);
    private static final String WEBJAR_PACKAGE_PREFIX = "META-INF/resources/webjars";
    private static final String MVNPM_PACKAGE_PREFIX = "META-INF/resources/_static";
    private static final String NODE_MODULES = "node_modules";
    private static final String DIST = "dist";
    private static String VERSION;

    public static String getDefaultVersion() {
        if (VERSION == null) {
            Properties properties = new Properties();
            try {
                InputStream resource = Bundler.class.getResourceAsStream("/version.properties");
                if (resource != null) {
                    properties.load(resource);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            VERSION = properties.getProperty("esbuild.version", "0.17.19");
        }
        return VERSION;
    }

    public static BundleResult bundle(BundleOptions bundleOptions) throws IOException {
        Path workDir = Bundler.installIfNeeded(bundleOptions);
        Path dist = workDir.resolve(DIST);
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, workDir, dist);
        ExecuteResult executeResult = Bundler.esBuild(esBuildConfig);
        if (!Files.isDirectory(dist, new LinkOption[0])) {
            throw new BundleException("Unexpected Error during bundling", executeResult.output());
        }
        return new BundleResult(dist, executeResult);
    }

    private static EsBuildConfig createBundle(BundleOptions bundleOptions, Path workDir, Path dist) throws IOException {
        EsBuildConfig esBuildConfig = bundleOptions.getEsBuildConfig();
        Copy.deleteRecursive(dist);
        Files.createDirectories(dist, new FileAttribute[0]);
        esBuildConfig.setOutdir(dist.toString());
        List<String> paths = bundleOptions.getEntries().stream().map(entry -> entry.process(workDir).toString()).toList();
        esBuildConfig.setEntryPoint(paths.toArray(new String[0]));
        return esBuildConfig;
    }

    public static Watch watch(BundleOptions bundleOptions, BuildEventListener eventListener) throws IOException {
        Path workDir = Bundler.installIfNeeded(bundleOptions);
        Path dist = workDir.resolve(DIST);
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, workDir, dist);
        bundleOptions.getEsBuildConfig().setWatch(true);
        Process process = Bundler.esBuild(esBuildConfig, eventListener);
        return new Watch(process, workDir);
    }

    public static Path installIfNeeded(BundleOptions bundleOptions) throws IOException {
        if (bundleOptions.getWorkDir() != null && Files.isDirectory(bundleOptions.getWorkDir().resolve(NODE_MODULES), new LinkOption[0])) {
            return bundleOptions.getWorkDir();
        }
        return Bundler.install(bundleOptions);
    }

    public static Path install(BundleOptions bundleOptions) throws IOException {
        Path workingDir = bundleOptions.getWorkDir() != null ? bundleOptions.getWorkDir() : Files.createTempDirectory("bundle", new FileAttribute[0]);
        return Bundler.extract(workingDir, bundleOptions.getDependencies(), bundleOptions.getType());
    }

    public static Path install(Path workingDir, List<Path> dependencies, BundleType type) throws IOException {
        return Bundler.extract(workingDir, dependencies, type);
    }

    public static void clearDependencies(Path workingDir) throws IOException {
        Copy.deleteRecursive(workingDir.resolve(NODE_MODULES));
    }

    protected static Path extract(Path bundleDirectory, List<Path> dependencies, BundleType type) throws IOException {
        Path nodeModules = bundleDirectory.resolve(NODE_MODULES);
        if (!Files.exists(nodeModules, new LinkOption[0])) {
            Files.createDirectories(nodeModules, new FileAttribute[0]);
        }
        Path tmp = bundleDirectory.resolve("tmp");
        for (Path path : dependencies) {
            Optional<Path> packageJson;
            String fileName = path.getFileName().toString();
            Path extractDir = tmp.resolve(fileName.substring(0, fileName.lastIndexOf(".")));
            if (Files.isDirectory(extractDir, new LinkOption[0])) continue;
            UnZip.unzip(path, extractDir);
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MVNPM: {
                    Optional<Path> optional = PackageJson.findPackageJson(extractDir.resolve(MVNPM_PACKAGE_PREFIX));
                    break;
                }
                case WEBJARS: {
                    Optional<Path> optional = packageJson = PackageJson.findPackageJson(extractDir.resolve(WEBJAR_PACKAGE_PREFIX));
                }
            }
            if (packageJson.isPresent()) {
                String packageName = PackageJson.readPackageName(packageJson.get());
                Path source = packageJson.get().getParent();
                Path target = nodeModules.resolve(packageName);
                if (!Files.isDirectory(target, new LinkOption[0])) {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                logger.info("skipping package as it already exists '{}'", (Object)target);
                continue;
            }
            logger.info("package.json not found in package '{}'", (Object)fileName);
        }
        return bundleDirectory;
    }

    protected static Process esBuild(EsBuildConfig esBuildConfig, BuildEventListener listener) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(Bundler.getDefaultVersion());
        Execute execute = new Execute(esBuildExec.toFile(), esBuildConfig);
        return execute.execute(listener);
    }

    protected static ExecuteResult esBuild(EsBuildConfig esBuildConfig) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(Bundler.getDefaultVersion());
        Execute execute = new Execute(esBuildExec.toFile(), esBuildConfig);
        return execute.executeAndWait();
    }

    public static enum BundleType {
        WEBJARS,
        MVNPM;

    }
}

