/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.modal;

import ch.nerdin.esbuild.modal.EsBuildConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EsBuildConfigBuilder {
    private final EsBuildConfig esBuildConfig = new EsBuildConfig();

    public EsBuildConfigBuilder() {
        this.initDefault();
    }

    private void initDefault() {
        this.bundle().minify().sourceMap().splitting().entryNames("[name]-[hash]").format(EsBuildConfig.Format.ESM).loader(EsBuildConfigBuilder.getDefaultLoadersMap());
    }

    public static Map<String, EsBuildConfig.Loader> getDefaultLoadersMap() {
        HashMap<String, EsBuildConfig.Loader> loaders = new HashMap<String, EsBuildConfig.Loader>();
        loaders.put(".css", EsBuildConfig.Loader.CSS);
        loaders.put(".json", EsBuildConfig.Loader.JSON);
        loaders.put(".jsx", EsBuildConfig.Loader.JSX);
        loaders.put(".tsx", EsBuildConfig.Loader.TSX);
        loaders.put(".ts", EsBuildConfig.Loader.TS);
        loaders.put(".js", EsBuildConfig.Loader.JS);
        loaders.put(".svg", EsBuildConfig.Loader.FILE);
        loaders.put(".gif", EsBuildConfig.Loader.FILE);
        loaders.put(".png", EsBuildConfig.Loader.FILE);
        loaders.put(".jpg", EsBuildConfig.Loader.FILE);
        loaders.put(".woff", EsBuildConfig.Loader.FILE);
        loaders.put(".woff2", EsBuildConfig.Loader.FILE);
        loaders.put(".ttf", EsBuildConfig.Loader.FILE);
        loaders.put(".eot", EsBuildConfig.Loader.FILE);
        return loaders;
    }

    public EsBuildConfigBuilder bundle() {
        this.esBuildConfig.setBundle(true);
        return this;
    }

    public EsBuildConfigBuilder entryPoint(String[] entryPoint) {
        this.esBuildConfig.setEntryPoint(entryPoint);
        return this;
    }

    public EsBuildConfigBuilder minify() {
        this.esBuildConfig.setMinify(true);
        return this;
    }

    public EsBuildConfigBuilder minify(boolean minify) {
        this.esBuildConfig.setMinify(minify);
        return this;
    }

    public EsBuildConfigBuilder version() {
        this.esBuildConfig.setVersion(true);
        return this;
    }

    public EsBuildConfigBuilder substitutes(Map<String, String> substitutes) {
        this.esBuildConfig.setSubstitutes(substitutes);
        return this;
    }

    public EsBuildConfigBuilder excludes(List<String> excludes) {
        this.esBuildConfig.setExcludes(excludes);
        return this;
    }

    public EsBuildConfigBuilder format(EsBuildConfig.Format format) {
        this.esBuildConfig.setFormat(format);
        return this;
    }

    public EsBuildConfigBuilder loader(Map<String, EsBuildConfig.Loader> loader) {
        this.esBuildConfig.setLoader(loader);
        return this;
    }

    public EsBuildConfigBuilder outDir(String outDir) {
        this.esBuildConfig.setOutdir(outDir);
        return this;
    }

    public EsBuildConfigBuilder packages(String packages) {
        this.esBuildConfig.setPackages(packages);
        return this;
    }

    public EsBuildConfigBuilder platform(EsBuildConfig.Platform platform) {
        this.esBuildConfig.setPlatform(platform);
        return this;
    }

    public EsBuildConfigBuilder serve() {
        this.esBuildConfig.setServe(true);
        return this;
    }

    public EsBuildConfigBuilder sourceMap() {
        this.esBuildConfig.setSourceMap(true);
        return this;
    }

    public EsBuildConfigBuilder sourceMap(boolean sourceMap) {
        this.esBuildConfig.setSourceMap(sourceMap);
        return this;
    }

    public EsBuildConfigBuilder splitting() {
        this.esBuildConfig.setSplitting(true);
        return this;
    }

    public EsBuildConfigBuilder splitting(boolean splitting) {
        this.esBuildConfig.setSplitting(splitting);
        return this;
    }

    public EsBuildConfigBuilder target(EsBuildConfig.Target target) {
        this.esBuildConfig.setTarget(target);
        return this;
    }

    public EsBuildConfigBuilder watch() {
        this.esBuildConfig.setWatch(true);
        return this;
    }

    public EsBuildConfigBuilder chunkNames(String template) {
        this.esBuildConfig.setChunkNames(template);
        return this;
    }

    public EsBuildConfigBuilder entryNames(String template) {
        this.esBuildConfig.setEntryNames(template);
        return this;
    }

    public EsBuildConfig build() {
        return this.esBuildConfig;
    }
}

