/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SingleResultNode;
import io.quarkus.qute.TemplateNode;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.jboss.logging.Logger;

class ExpressionNode
implements TemplateNode,
Function<Object, CompletionStage<ResultNode>> {
    private static final Logger LOG = Logger.getLogger("io.quarkus.qute.nodeResolve");
    final ExpressionImpl expression;
    private final Engine engine;
    private final boolean traceLevel;
    private final boolean hasEngineResultMappers;

    ExpressionNode(ExpressionImpl expression, Engine engine) {
        this.expression = expression;
        this.engine = engine;
        this.traceLevel = LOG.isTraceEnabled();
        this.hasEngineResultMappers = !engine.getResultMappers().isEmpty();
    }

    @Override
    public CompletionStage<ResultNode> resolve(ResolutionContext context) {
        if (this.traceLevel) {
            LOG.tracef("Resolve {%s} started:%s", (Object)this.expression.toOriginalString(), (Object)this.expression.getOrigin());
        }
        return context.evaluate(this.expression).thenCompose(this);
    }

    @Override
    public CompletionStage<ResultNode> apply(Object result) {
        if (this.traceLevel) {
            LOG.tracef("Resolve {%s} completed:%s", (Object)this.expression.toOriginalString(), (Object)this.expression.getOrigin());
        }
        if (result instanceof ResultNode) {
            return CompletedStage.of((ResultNode)result);
        }
        if (result instanceof CompletionStage) {
            return ((CompletionStage)result).thenCompose(this);
        }
        return CompletedStage.of(new SingleResultNode(result, this));
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.expression.getOrigin();
    }

    @Override
    public boolean isConstant() {
        return this.expression.isLiteral();
    }

    Engine getEngine() {
        return this.engine;
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.singletonList(this.expression);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExpressionNode [expression=").append(this.expression).append("]");
        return builder.toString();
    }

    boolean hasEngineResultMappers() {
        return this.hasEngineResultMappers;
    }

    String mapResult(Object result) {
        return this.engine.mapResult(result, this.expression);
    }
}

