/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.BuildEventListener;
import ch.nerdin.esbuild.Execute;
import ch.nerdin.esbuild.Watch;
import ch.nerdin.esbuild.modal.BundleOptions;
import ch.nerdin.esbuild.modal.EsBuildConfig;
import ch.nerdin.esbuild.resolve.ExecutableResolver;
import ch.nerdin.esbuild.util.Copy;
import ch.nerdin.esbuild.util.PackageJson;
import ch.nerdin.esbuild.util.UnZip;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bundler {
    private static final Logger logger = LoggerFactory.getLogger(Bundler.class);
    private static final String WEBJAR_PACKAGE_PREFIX = "META-INF/resources/webjars";
    private static final String MVNPM_PACKAGE_PREFIX = "META-INF/resources/_static";
    private static final String NODE_MODULES = "node_modules";
    private static final String DIST = "dist";
    private static String VERSION;

    public static String getDefaultVersion() {
        if (VERSION == null) {
            Properties properties = new Properties();
            try {
                InputStream resource = Bundler.class.getResourceAsStream("/version.properties");
                properties.load(resource);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            VERSION = properties.getProperty("esbuild.version", "0.17.17");
        }
        return VERSION;
    }

    public static Path bundle(BundleOptions bundleOptions) throws IOException {
        Path location = Bundler.installIfNeeded(bundleOptions);
        Path dist = location.resolve(DIST);
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, location, dist);
        Bundler.esBuild(esBuildConfig, null);
        return dist;
    }

    private static EsBuildConfig createBundle(BundleOptions bundleOptions, Path location, Path dist) throws IOException {
        EsBuildConfig esBuildConfig = bundleOptions.getEsBuildConfig();
        Copy.deleteRecursive(dist);
        Files.createDirectories(dist, new FileAttribute[0]);
        esBuildConfig.setOutdir(dist.toString());
        Path path = bundleOptions.getWorkFolder() != null ? bundleOptions.getWorkFolder() : location;
        List<String> paths = bundleOptions.getEntries().stream().map(entry -> entry.process(path).toString()).toList();
        esBuildConfig.setEntryPoint(paths.toArray(new String[0]));
        return esBuildConfig;
    }

    public static Watch watch(BundleOptions bundleOptions, BuildEventListener eventListener) throws IOException {
        Path location = Bundler.installIfNeeded(bundleOptions);
        Path dist = location.resolve(DIST);
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, location, dist);
        bundleOptions.getEsBuildConfig().setWatch(true);
        Process process = Bundler.esBuild(esBuildConfig, eventListener);
        return new Watch(process);
    }

    public static Path installIfNeeded(BundleOptions bundleOptions) throws IOException {
        if (bundleOptions.getWorkFolder() != null && Files.isDirectory(bundleOptions.getWorkFolder().resolve(NODE_MODULES), new LinkOption[0])) {
            return bundleOptions.getWorkFolder();
        }
        return Bundler.install(bundleOptions);
    }

    public static Path install(BundleOptions bundleOptions) throws IOException {
        Path workingDir = bundleOptions.getWorkFolder() != null ? bundleOptions.getWorkFolder() : Files.createTempDirectory("bundle", new FileAttribute[0]);
        return Bundler.extract(workingDir, bundleOptions.getDependencies(), bundleOptions.getType());
    }

    public static Path install(Path workingDir, List<Path> dependencies, BundleType type) throws IOException {
        return Bundler.extract(workingDir, dependencies, type);
    }

    public static void clearDependencies(Path workingDir) throws IOException {
        Copy.deleteRecursive(workingDir.resolve(NODE_MODULES));
    }

    protected static Path extract(Path bundleDirectory, List<Path> dependencies, BundleType type) throws IOException {
        Path nodeModules = bundleDirectory.resolve(NODE_MODULES);
        if (!Files.exists(nodeModules, new LinkOption[0])) {
            Files.createDirectories(nodeModules, new FileAttribute[0]);
        }
        Path tmp = bundleDirectory.resolve("tmp");
        for (Path path : dependencies) {
            Optional<Path> packageJson;
            String fileName = path.getFileName().toString();
            Path extractDir = tmp.resolve(fileName.substring(0, fileName.lastIndexOf(".")));
            if (Files.isDirectory(extractDir, new LinkOption[0])) continue;
            UnZip.unzip(path, extractDir);
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MVNPM: {
                    Optional<Path> optional = PackageJson.findPackageJson(extractDir.resolve(MVNPM_PACKAGE_PREFIX));
                    break;
                }
                case WEBJARS: {
                    Optional<Path> optional = packageJson = PackageJson.findPackageJson(extractDir.resolve(WEBJAR_PACKAGE_PREFIX));
                }
            }
            if (packageJson.isPresent()) {
                String packageName = PackageJson.readPackageName(packageJson.get());
                Path source = packageJson.get().getParent();
                Path target = nodeModules.resolve(packageName);
                if (!Files.isDirectory(target, new LinkOption[0])) {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                logger.info("skipping package as it already exists '{}'", (Object)target);
                continue;
            }
            logger.info("package.json not found in package '{}'", (Object)fileName);
        }
        return bundleDirectory;
    }

    protected static Process esBuild(EsBuildConfig esBuildConfig, BuildEventListener listener) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(Bundler.getDefaultVersion());
        Execute execute = new Execute(esBuildExec.toFile(), esBuildConfig);
        if (listener != null) {
            return execute.execute(listener);
        }
        execute.executeAndWait();
        return null;
    }

    public static enum BundleType {
        WEBJARS,
        MVNPM;

    }
}

