/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.samples;

import ch.swisscom.mid.client.MIDFlowException;
import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.config.HttpConfiguration;
import ch.swisscom.mid.client.config.TlsConfiguration;
import ch.swisscom.mid.client.config.UrlsConfiguration;
import ch.swisscom.mid.client.model.Fault;

public class Utils {
    public static ClientConfiguration buildClientConfig() {
        ClientConfiguration config = new ClientConfiguration();
        config.setProtocolToRest();
        config.setApId("<My AP ID>");
        config.setApPassword("<My AP password>");
        UrlsConfiguration urls = config.getUrls();
        urls.setAllServiceUrlsTo("https://mobileid.swisscom.com/rest/service");
        TlsConfiguration tls = config.getTls();
        tls.setKeyStoreFile("/home/localuser/mid_keystore.jks");
        tls.setKeyStorePassword("secret");
        tls.setKeyStoreKeyPassword("secret");
        tls.setKeyStoreCertificateAlias("my-cert-alias");
        tls.setTrustStoreFile("/home/localuser/truststore.jks");
        tls.setTrustStorePassword("secret");
        tls.setHostnameVerification(true);
        HttpConfiguration http = config.getHttp();
        http.setConnectionTimeoutInMs(20000);
        http.setResponseTimeoutInMs(100000);
        http.setMaxTotalConnections(20);
        http.setMaxConnectionsPerRoute(10);
        return config;
    }

    public static String prettyPrintTheException(Exception e) {
        StringBuilder builder = new StringBuilder(200);
        if (MIDFlowException.class.isAssignableFrom(e.getClass())) {
            MIDFlowException midFlowException = (MIDFlowException)e;
            Fault fault = midFlowException.getFault();
            builder.append(fault.toString());
            builder.append("\n---\n");
        }
        builder.append("Exception stack:\n");
        Throwable exceptionCursor = e;
        for (int depth = 0; depth < 20 && exceptionCursor != null; ++depth, exceptionCursor = exceptionCursor.getCause()) {
            builder.append("  ");
            builder.append(exceptionCursor.getClass().getSimpleName());
            builder.append(" = ");
            builder.append(exceptionCursor.getLocalizedMessage());
            builder.append('\n');
        }
        return builder.toString();
    }
}

