/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.soap;

import ch.swisscom.mid.client.config.ComProtocol;
import ch.swisscom.mid.client.config.RequestTrace;
import ch.swisscom.mid.client.config.ResponseTrace;
import ch.swisscom.mid.client.config.TrafficObserver;
import ch.swisscom.mid.client.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapTrafficHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger logClient = LoggerFactory.getLogger((String)"ch.swisscom.mid.client");
    private static final Logger logRequestResponse = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.requestResponse");
    private static final Logger logFullRequestResponse = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.fullRequestResponse");
    private TrafficObserver trafficObserver;

    public void setTrafficObserver(TrafficObserver trafficObserver) {
        this.trafficObserver = trafficObserver;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        boolean isRequestMessage = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        String soapMessageString = this.serializeSoapMessageToString(smc);
        if (isRequestMessage) {
            if (logRequestResponse.isInfoEnabled()) {
                logRequestResponse.info("Sending SOAP request: [{}]", (Object)soapMessageString);
            }
            if (logFullRequestResponse.isInfoEnabled()) {
                logFullRequestResponse.info("Sending SOAP request: [{}]", (Object)soapMessageString);
            }
        } else {
            if (logRequestResponse.isInfoEnabled()) {
                String strippedResponse = Utils.stripInnerLargeBase64Content((String)soapMessageString, (char)'>', (char)'<');
                logRequestResponse.info("Received SOAP response: [{}]", (Object)strippedResponse);
            }
            if (logFullRequestResponse.isInfoEnabled()) {
                logFullRequestResponse.info("Received SOAP response: [{}]", (Object)soapMessageString);
            }
        }
        if (this.trafficObserver != null) {
            if (isRequestMessage) {
                this.trafficObserver.notifyOfOutgoingRequest(new RequestTrace(soapMessageString), ComProtocol.SOAP);
            } else {
                int httpCode = (Integer)smc.get((Object)"javax.xml.ws.http.response.code");
                this.trafficObserver.notifyOfIncomingResponse(new ResponseTrace(httpCode, "-", soapMessageString), ComProtocol.SOAP);
            }
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext smc) {
        String soapMessageString = this.serializeSoapMessageToString(smc);
        logRequestResponse.info("Received SOAP fault:\n{}", (Object)soapMessageString);
        if (this.trafficObserver != null) {
            int httpCode = (Integer)smc.get((Object)"javax.xml.ws.http.response.code");
            this.trafficObserver.notifyOfIncomingResponse(new ResponseTrace(httpCode, "-", soapMessageString), ComProtocol.SOAP);
        }
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    private String serializeSoapMessageToString(SOAPMessageContext smc) {
        String result = this.convertToPrettyPrintedMessage(smc.getMessage());
        if (result == null) {
            result = this.convertToUnformattedString(smc.getMessage());
        }
        if (result == null) {
            result = "Content not available";
        }
        return result;
    }

    private String convertToUnformattedString(SOAPMessage soapMessage) {
        String string;
        ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
        try {
            soapMessage.writeTo((OutputStream)streamOut);
            string = streamOut.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    streamOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logClient.error("Failed to log unformatted SOAP message.", (Throwable)e);
                return null;
            }
        }
        streamOut.close();
        return string;
    }

    private String convertToPrettyPrintedMessage(SOAPMessage soapMessage) {
        try {
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            Source sc = soapMessage.getSOAPPart().getContent();
            ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(streamOut);
            tf.transform(sc, result);
            return streamOut.toString();
        }
        catch (Exception e) {
            logClient.error("Failed to pretty print SOAP message for logging purpose", (Throwable)e);
            return null;
        }
    }
}

