/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.model;

import ch.swisscom.mid.client.model.DocumentedEnum;

public enum ProfileMobileUserCertificateState implements DocumentedEnum
{
    ACTIVE("ACTIVE", "The certificate is active for this device and can be used"),
    INACTIVE("INACTIVE", "The certificate is inactive/disabled. It cannot be used for a new transaction"),
    REVOKED("REVOKED", "The certificate has been revoked. It cannot be used anymore"),
    EXPIRED("EXPIRED", "The certificate has expired. It cannot be used anymore"),
    FUTURE("FUTURE", "The certificate's validity period has not yet started (it will start in the future). It cannot be used for a new transaction, for now"),
    UNKNOWN("UNKNOWN", "The certificate in in an unknown state.");

    private final String value;
    private final String description;

    private ProfileMobileUserCertificateState(String value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public static ProfileMobileUserCertificateState getByStateString(String value) {
        for (ProfileMobileUserCertificateState state : ProfileMobileUserCertificateState.values()) {
            if (!state.getValue().equalsIgnoreCase(value)) continue;
            return state;
        }
        throw new IllegalArgumentException("Invalid mobile user device certificate state: " + value);
    }
}

