/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.impl;

import ch.swisscom.mid.client.SignatureValidator;
import ch.swisscom.mid.client.config.ConfigurationException;
import ch.swisscom.mid.client.config.SignatureValidationConfiguration;
import ch.swisscom.mid.client.model.SignatureValidationFailureReason;
import ch.swisscom.mid.client.model.SignatureValidationResult;
import ch.swisscom.mid.client.model.Traceable;
import ch.swisscom.mid.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidatorImpl
implements SignatureValidator {
    private static final Logger log = LoggerFactory.getLogger((String)"ch.swisscom.mid.signatureValidator");
    private final KeyStore validationTrustStore;
    private static final Pattern SERIAL_NUMBER_PATTERN = Pattern.compile(".*SERIALNUMBER=(.{16}).*");

    public SignatureValidatorImpl(SignatureValidationConfiguration config) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.validationTrustStore = this.loadValidationTruststore(config);
    }

    public SignatureValidatorImpl(KeyStore validationTrustStore) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.validationTrustStore = validationTrustStore;
    }

    @Override
    public SignatureValidationResult validateSignature(String base64SignatureContent, String requestedDtbs, Traceable trace) {
        LinkedList<X509Certificate> signerCertChain;
        SignerInformation signerInfo;
        CMSSignedData cmsSignedData;
        Utils.assertNotEmpty(base64SignatureContent, "The base64SignatureContent parameter cannot be NULL" + Utils.printTrace(trace));
        Utils.assertNotEmpty(requestedDtbs, "The requestedDtbs parameter cannot be NULL" + Utils.printTrace(trace));
        SignatureValidationResult result = new SignatureValidationResult();
        result.setSignatureValid(false);
        result.setSignerCertificateValid(false);
        result.setSignerCertificatePathValid(false);
        result.setDtbsMatching(false);
        X509Certificate signerCert = null;
        try {
            JcaX509CertificateConverter x509CertificateConverter = new JcaX509CertificateConverter();
            cmsSignedData = new CMSSignedData(Base64.getDecoder().decode(base64SignatureContent));
            SignerInformationStore signerInfoStore = cmsSignedData.getSignerInfos();
            signerInfo = (SignerInformation)signerInfoStore.getSigners().iterator().next();
            signerCertChain = new LinkedList<X509Certificate>();
            for (X509CertificateHolder currentCertHolder : cmsSignedData.getCertificates().getMatches(null)) {
                X509Certificate currentCert = x509CertificateConverter.getCertificate(currentCertHolder);
                signerCertChain.add(currentCert);
                if (!signerInfo.getSID().match((Object)currentCertHolder)) continue;
                signerCert = currentCert;
            }
            if (signerCert == null) {
                log.warn("Failed to extract the signing certificate from the Base64 CMS content{}", (Object)Utils.printTrace(trace));
                result.setValidationFailureReason(SignatureValidationFailureReason.FAILED_TO_EXTRACT_SIGNING_CERTIFICATE);
                return result;
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract the signing certificate from the Base64 CMS content{}", (Object)Utils.printTrace(trace), (Object)e);
            result.setValidationException(e);
            result.setValidationFailureReason(SignatureValidationFailureReason.FAILED_TO_EXTRACT_SIGNING_CERTIFICATE);
            return result;
        }
        result.setMobileIdSerialNumber(this.getMIDSerialNumber(signerCert));
        result.setSignedDtbs(this.getSignedDtbs(cmsSignedData));
        try {
            signerCert.checkValidity();
            result.setSignerCertificateValid(true);
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            log.warn("Failed to validate the certificate during the signature CMS content validation{}", (Object)Utils.printTrace(trace), (Object)e);
            result.setValidationException(e);
            result.setValidationFailureReason(SignatureValidationFailureReason.SIGNING_CERTIFICATE_NOT_VALID);
            return result;
        }
        try {
            PKIXParameters params = new PKIXParameters(this.validationTrustStore);
            params.setRevocationEnabled(false);
            Security.setProperty("ocsp.enable", "false");
            System.setProperty("com.sun.security.enableCRLDP", "false");
            CertPathValidator cpv = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            cpv.validate(CertificateFactory.getInstance("X.509").generateCertPath(signerCertChain), params);
            result.setSignerCertificatePathValid(true);
        }
        catch (Exception e) {
            log.warn("Failed to validate the certificate path during the signature CMS content validation{}", (Object)Utils.printTrace(trace), (Object)e);
            result.setValidationException(e);
            result.setValidationFailureReason(SignatureValidationFailureReason.SIGNING_CERTIFICATE_PATH_NOT_VALID);
            return result;
        }
        try {
            result.setSignatureValid(signerInfo.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(signerCert)));
            if (!result.isSignatureValid()) {
                result.setValidationFailureReason(SignatureValidationFailureReason.SIGNATURE_VALIDATION_FAILED);
            }
        }
        catch (CMSException | OperatorCreationException e) {
            log.warn("Failed to validate the signature against the signer info during the signature CMS content validation{}", (Object)Utils.printTrace(trace), (Object)e);
            result.setValidationException((Exception)e);
            result.setValidationFailureReason(SignatureValidationFailureReason.SIGNATURE_VALIDATION_FAILED);
            return result;
        }
        if (requestedDtbs.equals(result.getSignedDtbs())) {
            result.setDtbsMatching(true);
        } else {
            log.info("Failed to match the DTBS texts, requested=[{}] vs signed=[{}]{}", new Object[]{requestedDtbs, result.getSignedDtbs(), Utils.printTrace(trace)});
            result.setValidationFailureReason(SignatureValidationFailureReason.DATA_TO_BE_SIGNED_NOT_MATCHING);
        }
        return result;
    }

    private String getMIDSerialNumber(X509Certificate signerCert) {
        Matcher matcher = SERIAL_NUMBER_PATTERN.matcher(signerCert.getSubjectX500Principal().toString().toUpperCase());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getSignedDtbs(CMSSignedData cmsSignedData) {
        return new String((byte[])cmsSignedData.getSignedContent().getContent(), StandardCharsets.UTF_8);
    }

    private KeyStore loadValidationTruststore(SignatureValidationConfiguration config) {
        try {
            KeyStore trustStore = KeyStore.getInstance(config.getTrustStoreType());
            if (config.getTrustStoreFile() != null) {
                try (FileInputStream is = new FileInputStream(config.getTrustStoreFile());){
                    trustStore.load(is, config.getTrustStorePassword() == null ? null : config.getTrustStorePassword().toCharArray());
                }
            }
            if (config.getTrustStoreClasspathFile() != null) {
                try (InputStream is = this.getClass().getResourceAsStream(config.getTrustStoreClasspathFile());){
                    trustStore.load(is, config.getTrustStorePassword() == null ? null : config.getTrustStorePassword().toCharArray());
                }
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(config.getTrustStoreBytes());){
                trustStore.load(is, config.getTrustStorePassword() == null ? null : config.getTrustStorePassword().toCharArray());
            }
            return trustStore;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to initialize the digital signature validation truststore (Mobile ID CMS signature validator)", e);
        }
    }
}

