/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.config;

import ch.swisscom.mid.client.utils.Utils;

public class UrlsConfiguration {
    private String signatureServiceUrl;
    private String statusQueryServiceUrl;
    private String receiptServiceUrl;
    private String profileQueryServiceUrl;

    public String getSignatureServiceUrl() {
        return this.signatureServiceUrl;
    }

    public void setSignatureServiceUrl(String signatureServiceUrl) {
        this.signatureServiceUrl = signatureServiceUrl;
    }

    public String getProfileQueryServiceUrl() {
        return this.profileQueryServiceUrl;
    }

    public void setProfileQueryServiceUrl(String profileQueryServiceUrl) {
        this.profileQueryServiceUrl = profileQueryServiceUrl;
    }

    public String getStatusQueryServiceUrl() {
        return this.statusQueryServiceUrl;
    }

    public void setStatusQueryServiceUrl(String statusQueryServiceUrl) {
        this.statusQueryServiceUrl = statusQueryServiceUrl;
    }

    public String getReceiptServiceUrl() {
        return this.receiptServiceUrl;
    }

    public void setReceiptServiceUrl(String receiptServiceUrl) {
        this.receiptServiceUrl = receiptServiceUrl;
    }

    public void setAllServiceUrlsTo(String serviceUrl) {
        this.setSignatureServiceUrl(serviceUrl);
        this.setStatusQueryServiceUrl(serviceUrl);
        this.setReceiptServiceUrl(serviceUrl);
        this.setProfileQueryServiceUrl(serviceUrl);
    }

    public void setAllServiceUrlsToBase(String baseUrl) {
        String finalBaseUrl = baseUrl.trim();
        if (finalBaseUrl.endsWith("/")) {
            finalBaseUrl = finalBaseUrl.substring(0, finalBaseUrl.length() - 1);
        }
        this.setSignatureServiceUrl(finalBaseUrl + "/soap/services/MSS_SignaturePort");
        this.setStatusQueryServiceUrl(finalBaseUrl + "/soap/services/MSS_StatusQueryPort");
        this.setProfileQueryServiceUrl(finalBaseUrl + "/soap/services/MSS_ProfileQueryPort");
        this.setReceiptServiceUrl(finalBaseUrl + "/soap/services/MSS_ReceiptPort");
    }

    public void validateYourself() {
        Utils.configNotNull(this.signatureServiceUrl, "The signatureServiceUrl cannot be NULL");
        Utils.configNotNull(this.statusQueryServiceUrl, "The statusQueryServiceUrl cannot be NULL");
        Utils.configNotNull(this.receiptServiceUrl, "The receiptServiceUrl cannot be NULL");
        Utils.configNotNull(this.profileQueryServiceUrl, "The profileQueryServiceUrl cannot be NULL");
    }

    public String toString() {
        return "UrlsConfiguration{signatureServiceUrl='" + this.signatureServiceUrl + '\'' + ", statusQueryServiceUrl='" + this.statusQueryServiceUrl + '\'' + ", profileQueryServiceUrl='" + this.profileQueryServiceUrl + '\'' + '}';
    }
}

