/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.config;

import ch.swisscom.mid.client.utils.Utils;

public class ProxyConfiguration {
    private boolean enabled;
    private String host;
    private int port;
    private String username;
    private String password;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.enabled = true;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.enabled = true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.enabled = true;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void validateYourself() {
        if (this.enabled) {
            Utils.dataNotEmpty(this.host, "The proxy host type cannot be NULL or empty");
            Utils.dataGreaterThanZero(this.port, "The proxy port must be configured");
            if (this.username != null && this.username.trim().length() > 0) {
                Utils.dataNotEmpty(this.password, "If a proxy username is configured, then also the password needs to be configured");
            }
        }
    }

    public String toString() {
        return "ProxyConfiguration{enabled='" + this.enabled + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", username='" + this.username + '\'' + ", password='" + (this.password != null ? "(not-null)" : "null") + '\'' + '}';
    }
}

