/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.model;

import ch.swisscom.mid.client.config.TrafficObserver;
import ch.swisscom.mid.client.model.AdditionalService;
import ch.swisscom.mid.client.model.DataToBeSigned;
import ch.swisscom.mid.client.model.MobileUser;
import ch.swisscom.mid.client.model.SignatureProfiles;
import ch.swisscom.mid.client.model.UserLangAdditionalService;
import ch.swisscom.mid.client.model.UserLanguage;
import ch.swisscom.mid.client.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class SignatureRequest {
    private String majorVersion = "1";
    private String minorVersion = "2";
    private String overrideApId;
    private String overrideApPassword;
    private final List<AdditionalService> additionalServices = new ArrayList<AdditionalService>();
    private DataToBeSigned dataToBeSigned;
    private MobileUser mobileUser;
    private int userResponseTimeOutInSeconds = 80;
    private String signatureProfile = "http://mid.swisscom.ch/MID/v1/AuthProfile1";
    private TrafficObserver trafficObserver;

    public void setUserLanguage(UserLanguage language) {
        this.additionalServices.add(new UserLangAdditionalService(language));
    }

    public void addAdditionalService(AdditionalService service) {
        this.additionalServices.add(service);
    }

    public List<AdditionalService> getAdditionalServices() {
        return this.additionalServices;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(String majorVersion) {
        this.majorVersion = majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(String minorVersion) {
        this.minorVersion = minorVersion;
    }

    public DataToBeSigned getDataToBeSigned() {
        if (this.dataToBeSigned == null) {
            this.dataToBeSigned = new DataToBeSigned();
        }
        return this.dataToBeSigned;
    }

    public void setDataToBeSigned(DataToBeSigned dataToBeSigned) {
        this.dataToBeSigned = dataToBeSigned;
    }

    public MobileUser getMobileUser() {
        if (this.mobileUser == null) {
            this.mobileUser = new MobileUser();
        }
        return this.mobileUser;
    }

    public void setMobileUser(MobileUser mobileUser) {
        this.mobileUser = mobileUser;
    }

    public int getUserResponseTimeOutInSeconds() {
        return this.userResponseTimeOutInSeconds;
    }

    public void setUserResponseTimeOutInSeconds(int userResponseTimeOutInSeconds) {
        this.userResponseTimeOutInSeconds = userResponseTimeOutInSeconds;
    }

    public String getSignatureProfile() {
        return this.signatureProfile;
    }

    public void setSignatureProfile(String signatureProfile) {
        this.signatureProfile = signatureProfile;
    }

    public TrafficObserver getTrafficObserver() {
        return this.trafficObserver;
    }

    public void setTrafficObserver(TrafficObserver trafficObserver) {
        this.trafficObserver = trafficObserver;
    }

    public String getOverrideApId() {
        return this.overrideApId;
    }

    public void setOverrideApId(String overrideApId) {
        this.overrideApId = overrideApId;
    }

    public String getOverrideApPassword() {
        return this.overrideApPassword;
    }

    public void setOverrideApPassword(String overrideApPassword) {
        this.overrideApPassword = overrideApPassword;
    }

    public void validateYourself() {
        Utils.dataNotEmpty(this.majorVersion, "The major version cannot be null or empty (see DefaultConfiguration for default values)");
        Utils.dataNotEmpty(this.minorVersion, "The minor version cannot be null or empty (see DefaultConfiguration for default values)");
        Utils.dataNotEmpty(this.additionalServices, "Invalid signature request configuration. At least the UserLang additional service needs to be configured (call setUserLanguage).");
        Utils.dataNotNull(this.dataToBeSigned, "The data to be signed cannot be null (call setDataToBeSigned)");
        this.dataToBeSigned.validateYourself();
        Utils.dataNotNull(this.mobileUser, "The target mobile user cannot be null");
        this.mobileUser.validateYourself();
        Utils.dataNotEmpty(this.signatureProfile, "The signature profile cannot be null or empty. See " + SignatureProfiles.class.getSimpleName() + " for a list of possible profiles to choose from");
        Utils.dataTrue(this.userResponseTimeOutInSeconds >= 15, "The user response timeout cannot be lower than 15 seconds");
        Utils.dataTrue(this.userResponseTimeOutInSeconds <= 300, "The user response timeout cannot be higher than 300 seconds");
    }

    public String toString() {
        return "SignatureRequest{majorVersion='" + this.majorVersion + '\'' + ", minorVersion='" + this.minorVersion + '\'' + ", additionalServices=" + this.additionalServices + ", dataToBeSigned=" + this.dataToBeSigned + ", mobileUser=" + this.mobileUser + ", userResponseTimeOutInSeconds=" + this.userResponseTimeOutInSeconds + ", signatureProfile='" + this.signatureProfile + '\'' + ", trafficObserver=" + this.trafficObserver + '}';
    }
}

