/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.model;

import ch.swisscom.mid.client.model.DocumentedEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ReceiptMessagingMode implements DocumentedEnum
{
    SYNC("synch", "The receipt is processed synchronously (on the thread of the calling client; the client has to wait).");

    private static final Logger log;
    private final String value;
    private final String description;

    private ReceiptMessagingMode(String value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public static ReceiptMessagingMode getByValue(String value) {
        for (ReceiptMessagingMode mode : ReceiptMessagingMode.values()) {
            if (!mode.getValue().equals(value)) continue;
            return mode;
        }
        log.warn("Cannot find a valid " + ReceiptMessagingMode.class.getSimpleName() + " for value [{}]. Returning NULL", (Object)value);
        return null;
    }

    static {
        log = LoggerFactory.getLogger((String)"ch.swisscom.mid.client");
    }
}

