/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.model;

import ch.swisscom.mid.client.model.DocumentedEnum;

public enum ProfileDeviceState implements DocumentedEnum
{
    REGISTERED("REGISTERED", "The device is registered in the system but it is not activated yet"),
    ACTIVE("ACTIVE", "The device is active and ready to be used"),
    INACTIVE("INACTIVE", "The device is registered in the system, was activated but at the moment it cannot be used (certificate invalid, PIN blocked, etc)");

    private final String value;
    private final String description;

    private ProfileDeviceState(String value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public static ProfileDeviceState getByStateString(String value) {
        for (ProfileDeviceState state : ProfileDeviceState.values()) {
            if (!state.getValue().equalsIgnoreCase(value)) continue;
            return state;
        }
        throw new IllegalArgumentException("Invalid profile device state: " + value);
    }
}

