/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.impl;

import ch.swisscom.mid.client.MIDClient;
import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.config.ConfigurationException;
import ch.swisscom.mid.client.impl.ComProtocolHandler;
import ch.swisscom.mid.client.model.ProfileRequest;
import ch.swisscom.mid.client.model.ProfileResponse;
import ch.swisscom.mid.client.model.ReceiptRequest;
import ch.swisscom.mid.client.model.ReceiptResponse;
import ch.swisscom.mid.client.model.SignatureRequest;
import ch.swisscom.mid.client.model.SignatureResponse;
import ch.swisscom.mid.client.model.SignatureTracking;
import ch.swisscom.mid.client.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MIDClientImpl
implements MIDClient {
    private static final Logger logClient = LoggerFactory.getLogger((String)"ch.swisscom.mid.client");
    private static final Logger logConfig = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.config");
    private final List<ComProtocolHandler> comProtocolHandlers;
    private final ComProtocolHandler selectedProtocolHandler;

    public MIDClientImpl(ClientConfiguration config) throws ConfigurationException {
        logClient.debug("Creating new instance of MIDClient");
        logConfig.debug("MIDClient configuration: {}", (Object)config);
        this.comProtocolHandlers = this.loadComProtocolHandlers();
        this.validateClientConfiguration(config);
        logConfig.debug("MID Client configuration successfully validated.");
        this.selectedProtocolHandler = this.selectProtocolHandler(config);
        logConfig.debug("MID Client selected the following protocol implementation: {}", (Object)this.selectedProtocolHandler.getImplementedComProtocol());
        this.selectedProtocolHandler.initialize(config);
    }

    @Override
    public SignatureResponse requestSyncSignature(SignatureRequest request) {
        Utils.dataNotNull(request, "The given signature request is NULL");
        request.validateYourself();
        return this.selectedProtocolHandler.requestSyncSignature(request);
    }

    @Override
    public SignatureResponse requestAsyncSignature(SignatureRequest request) {
        Utils.dataNotNull(request, "The given signature request is NULL");
        request.validateYourself();
        return this.selectedProtocolHandler.requestAsyncSignature(request);
    }

    @Override
    public SignatureResponse pollForSignatureStatus(SignatureTracking signatureTracking) {
        Utils.dataNotNull(signatureTracking, "The given signature tracking object is NULL");
        signatureTracking.validateYourself();
        return this.selectedProtocolHandler.pollForSignatureStatus(signatureTracking);
    }

    @Override
    public ReceiptResponse requestSyncReceipt(SignatureTracking signatureTracking, ReceiptRequest request) {
        Utils.dataNotNull(request, "The given receipt request object is NULL");
        signatureTracking.validateYourself();
        request.validateYourself();
        return this.selectedProtocolHandler.requestSyncReceipt(signatureTracking, request);
    }

    @Override
    public ProfileResponse requestProfile(ProfileRequest request) {
        Utils.dataNotNull(request, "The given profile request object is NULL");
        request.validateYourself();
        return this.selectedProtocolHandler.requestProfile(request);
    }

    @Override
    public void close() {
        if (this.selectedProtocolHandler != null) {
            try {
                this.selectedProtocolHandler.close();
            }
            catch (Exception e) {
                logClient.debug("ComProtocolHandler failed to close: {}: {}, cause: {}: {}", new Object[]{e.getClass().getSimpleName(), e.getLocalizedMessage(), e.getCause().getClass(), e.getCause().getLocalizedMessage()});
            }
        }
    }

    private List<ComProtocolHandler> loadComProtocolHandlers() {
        ServiceLoader<ComProtocolHandler> loader = ServiceLoader.load(ComProtocolHandler.class);
        ArrayList<ComProtocolHandler> resultList = new ArrayList<ComProtocolHandler>();
        loader.iterator().forEachRemaining(element -> {
            resultList.add((ComProtocolHandler)element);
            logClient.debug("Found MID client protocol implementation for: {}", (Object)element.getImplementedComProtocol());
        });
        if (resultList.size() == 0) {
            logClient.warn("Found 0 client protocol implementations for MID Client. This is most likely an error. Please check your library dependencies, and make sure at least one of mobileid-client-rest and mobileid-client-soap is in the classpath.");
        }
        return resultList;
    }

    private void validateClientConfiguration(ClientConfiguration config) throws ConfigurationException {
        Utils.configNotNull(config, "The configuration object cannot be NULL");
        config.validateYourself();
        int handlersFoundForChosenProtocol = 0;
        for (ComProtocolHandler handler : this.comProtocolHandlers) {
            if (handler.getImplementedComProtocol() != config.getProtocol()) continue;
            ++handlersFoundForChosenProtocol;
        }
        Utils.configTrue(handlersFoundForChosenProtocol > 0, "No HTTP protocol implementation found for chosen protocol: " + (Object)((Object)config.getProtocol()) + ". Are you missing a library dependency to one of mobileid-client-rest or mobileid-client-soap?");
        Utils.configTrue(handlersFoundForChosenProtocol < 2, "More than one HTTP protocol implementation found for chosen protocol: " + (Object)((Object)config.getProtocol()) + ". Please check your library dependencies.");
    }

    private ComProtocolHandler selectProtocolHandler(ClientConfiguration config) {
        for (ComProtocolHandler handler : this.comProtocolHandlers) {
            if (handler.getImplementedComProtocol() != config.getProtocol()) continue;
            return handler;
        }
        throw new ConfigurationException("The selected communication protocol: " + (Object)((Object)config.getProtocol()) + " is not supported by any existing implementation. Are you missing a library dependency?");
    }
}

