/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.config;

import ch.swisscom.mid.client.config.ComProtocol;
import ch.swisscom.mid.client.config.HttpConfiguration;
import ch.swisscom.mid.client.config.ProxyConfiguration;
import ch.swisscom.mid.client.config.TlsConfiguration;
import ch.swisscom.mid.client.config.UrlsConfiguration;
import ch.swisscom.mid.client.utils.Utils;

public class ClientConfiguration {
    private TlsConfiguration tls;
    private HttpConfiguration http;
    private ComProtocol protocol;
    private UrlsConfiguration urls;
    private ProxyConfiguration proxy;
    private String apId;
    private String apPassword;
    private String msspId = "http://mid.swisscom.ch/";

    public void setProtocolToRest() {
        this.protocol = ComProtocol.REST;
    }

    public void setProtocolToSoap() {
        this.protocol = ComProtocol.SOAP;
    }

    public String getApId() {
        return this.apId;
    }

    public void setApId(String apId) {
        this.apId = apId;
    }

    public String getApPassword() {
        return this.apPassword;
    }

    public void setApPassword(String apPassword) {
        this.apPassword = apPassword;
    }

    public ComProtocol getProtocol() {
        return this.protocol;
    }

    public String getMsspId() {
        return this.msspId;
    }

    public void setMsspId(String msspId) {
        this.msspId = msspId;
    }

    public void setProtocol(ComProtocol protocol) {
        this.protocol = protocol;
    }

    public TlsConfiguration getTls() {
        if (this.tls == null) {
            this.tls = new TlsConfiguration();
        }
        return this.tls;
    }

    public void setTls(TlsConfiguration tls) {
        this.tls = tls;
    }

    public HttpConfiguration getHttp() {
        if (this.http == null) {
            this.http = new HttpConfiguration();
        }
        return this.http;
    }

    public void setHttp(HttpConfiguration http) {
        this.http = http;
    }

    public UrlsConfiguration getUrls() {
        if (this.urls == null) {
            this.urls = new UrlsConfiguration();
        }
        return this.urls;
    }

    public ProxyConfiguration getProxy() {
        if (this.proxy == null) {
            this.proxy = new ProxyConfiguration();
        }
        return this.proxy;
    }

    public void setProxy(ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    public String toString() {
        return "ClientConfiguration{tls=" + this.tls + ", http=" + this.http + ", protocol=" + (Object)((Object)this.protocol) + ", apId='" + this.apId + '\'' + ", msspId='" + this.msspId + '\'' + ", urls='" + this.urls + '\'' + ", proxy='" + this.proxy + '\'' + '}';
    }

    public void validateYourself() {
        Utils.configNotNull((Object)this.protocol, "The configured client protocol cannot be NULL.");
        Utils.configNotNull(this.apId, "The configured AP_ID (apId) cannot be NULL.");
        Utils.configNotNull(this.apPassword, "The configured AP_PWD (apPassword) cannot be NULL.");
        Utils.configNotNull(this.msspId, "The configured MSSP_ID (msspId) cannot be NULL. Usually the best value is to leave it as it is already: http://mid.swisscom.ch/");
        Utils.configNotNull(this.tls, "The TLS configuration cannot be NULL");
        this.tls.validateYourself();
        Utils.configNotNull(this.http, "The HTTP configuration cannot be NULL");
        this.http.validateYourself();
        Utils.configNotNull(this.urls, "The URLs configuration cannot be NULL");
        this.urls.validateYourself();
        if (this.proxy != null) {
            this.proxy.validateYourself();
        }
    }
}

