/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;

public final class ZipStripper
implements Stripper {
    private static final long DEFAULT_ZIP_TIMESTAMP = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
    private static final Comparator<String> MANIFEST_FILE_SORT_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if ("META-INF/MANIFEST.MF".equals(o1)) {
                return -1;
            }
            if ("META-INF/MANIFEST.MF".equals(o2)) {
                return 1;
            }
            if ("META-INF/".equals(o1)) {
                return -1;
            }
            if ("META-INF/".equals(o2)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };
    private final Map<String, Stripper> subFilters = new HashMap<String, Stripper>();
    private final long zipTimestamp;
    private final boolean fixZipExternalFileAttributes;

    public ZipStripper() {
        this.zipTimestamp = DEFAULT_ZIP_TIMESTAMP;
        this.fixZipExternalFileAttributes = false;
    }

    public ZipStripper(LocalDateTime zipDateTime, boolean fixZipExternalFileAttributes) {
        this.zipTimestamp = zipDateTime.atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
        this.fixZipExternalFileAttributes = fixZipExternalFileAttributes;
    }

    public ZipStripper addFileStripper(String filename, Stripper stripper) {
        this.subFilters.put(filename, stripper);
        return this;
    }

    @Override
    public void strip(File in, File out) throws IOException {
        try (ZipFile zip = new ZipFile(in);
             ZipArchiveOutputStream zout = new ZipArchiveOutputStream(out);){
            List<String> sortedNames = this.sortEntriesByName(zip.getEntries());
            for (String name : sortedNames) {
                ZipArchiveEntry entry = zip.getEntry(name);
                ZipArchiveEntry strippedEntry = this.filterZipEntry(entry);
                if (in.getName().endsWith(".jar") || in.getName().endsWith(".war")) {
                    this.fixAttributes(strippedEntry);
                } else if (in.getName().endsWith(".zip")) {
                    this.fixStickyAttributes(strippedEntry);
                }
                Stripper stripper = this.getSubFilter(name);
                if (stripper != null) {
                    String suffix = name.substring(name.lastIndexOf(46));
                    File tmp = File.createTempFile("tmp", suffix);
                    tmp.deleteOnExit();
                    Files.copy(zip.getInputStream(entry), tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    File tmp2 = File.createTempFile("tmp", suffix);
                    tmp2.deleteOnExit();
                    stripper.strip(tmp, tmp2);
                    byte[] fileContent = Files.readAllBytes(tmp2.toPath());
                    strippedEntry.setSize((long)fileContent.length);
                    zout.putArchiveEntry((ArchiveEntry)strippedEntry);
                    zout.write(fileContent);
                    zout.closeArchiveEntry();
                    continue;
                }
                zout.addRawArchiveEntry(strippedEntry, zip.getRawInputStream(entry));
            }
        }
    }

    private void fixAttributes(ZipArchiveEntry entry) {
        if (this.fixZipExternalFileAttributes) {
            if (entry.isDirectory()) {
                entry.setUnixMode(16877);
            } else {
                entry.setUnixMode(33188);
            }
        }
    }

    private void fixStickyAttributes(ZipArchiveEntry entry) {
        if (this.fixZipExternalFileAttributes) {
            BitSet bits = BitSet.valueOf(new long[]{entry.getUnixMode()});
            bits.set(9, 11, false);
            entry.setUnixMode((int)bits.toLongArray()[0]);
        }
    }

    private Stripper getSubFilter(String name) {
        for (Map.Entry<String, Stripper> filter : this.subFilters.entrySet()) {
            if (!name.matches(filter.getKey())) continue;
            return filter.getValue();
        }
        return null;
    }

    private List<String> sortEntriesByName(Enumeration<ZipArchiveEntry> entries) {
        return Collections.list(entries).stream().map(e -> e.getName()).sorted(MANIFEST_FILE_SORT_COMPARATOR).collect(Collectors.toList());
    }

    private ZipArchiveEntry filterZipEntry(ZipArchiveEntry entry) {
        entry.setCreationTime(FileTime.fromMillis(this.zipTimestamp));
        entry.setLastAccessTime(FileTime.fromMillis(this.zipTimestamp));
        entry.setLastModifiedTime(FileTime.fromMillis(this.zipTimestamp));
        entry.setTime(this.zipTimestamp);
        for (ZipExtraField field : entry.getExtraFields()) {
            if (!(field instanceof X5455_ExtendedTimestamp)) continue;
            entry.removeExtraField(field.getHeaderId());
        }
        return entry;
    }
}

