/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public final class PatternFileNameFilter
implements FilenameFilter {
    private final Log log;
    private final List<Pattern> includes;
    private final List<Pattern> excludes;
    private final List<String> extensions;

    private PatternFileNameFilter(Log inLog, List<Pattern> inIncludes, List<Pattern> inExcludes, List<String> inExtensions) {
        this.log = Objects.requireNonNull(inLog, "log");
        this.includes = Objects.requireNonNull(inIncludes, "includes");
        this.excludes = Objects.requireNonNull(inExcludes, "excludes");
        this.extensions = Objects.requireNonNull(inExtensions, "extensions");
    }

    public static PatternFileNameFilter of(Log log, List<String> includes, List<String> excludes, List<String> extensions) {
        String trimmed;
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>(includes.size());
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>(includes.size());
        for (String include : includes) {
            if (include == null || (trimmed = include.trim()).isEmpty()) continue;
            includePatterns.add(Pattern.compile(trimmed));
        }
        for (String exclude : excludes) {
            if (exclude == null || (trimmed = exclude.trim()).isEmpty()) continue;
            excludePatterns.add(Pattern.compile(trimmed));
        }
        return new PatternFileNameFilter(log, includePatterns, excludePatterns, extensions);
    }

    @Override
    public boolean accept(File dir, String name) {
        this.log.debug((CharSequence)("Checking if " + name + " should be processed..."));
        if (!this.fileIncludedByExtensions(name)) {
            this.log.debug((CharSequence)("File " + name + " will not be processed: Inappropriate file name extension"));
            return false;
        }
        if (!this.fileIncludedByInclusionPatterns(name)) {
            this.log.debug((CharSequence)("File " + name + " will not be processed: No inclusion patterns match"));
            return false;
        }
        if (this.fileExcluded(name)) {
            this.log.debug((CharSequence)("File " + name + " will not be processed: An exclusion pattern matches"));
            return false;
        }
        this.log.debug((CharSequence)("File " + name + " will be processed"));
        return true;
    }

    private boolean fileExcluded(String name) {
        boolean excluded = false;
        for (Pattern exclusion : this.excludes) {
            Matcher matcher = exclusion.matcher(name);
            if (matcher.matches()) {
                this.log.debug((CharSequence)("Exclusion: match: " + name + " -> " + exclusion));
                excluded = true;
                break;
            }
            this.log.debug((CharSequence)("Exclusion: no-match: " + name + " -> " + exclusion));
        }
        return excluded;
    }

    private boolean fileIncludedByExtensions(String name) {
        String lowercase = name.toLowerCase();
        for (String extension : this.extensions) {
            if (!lowercase.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private boolean fileIncludedByInclusionPatterns(String name) {
        boolean included = false;
        for (Pattern inclusion : this.includes) {
            Matcher matcher = inclusion.matcher(name);
            if (matcher.matches()) {
                this.log.debug((CharSequence)("Inclusion: match: " + name + " -> " + inclusion));
                included = true;
                break;
            }
            this.log.debug((CharSequence)("Inclusion: no match: " + name + " -> " + inclusion));
        }
        return included;
    }
}

