/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.LineEndingsStripper;
import io.github.zlika.reproducible.ManifestStripper;
import io.github.zlika.reproducible.MavenPluginToolsStripper;
import io.github.zlika.reproducible.PropertiesFileStripper;
import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.ZipStripper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;

final class DefaultZipStripper
implements Stripper {
    private final boolean overwrite;
    private final ZipStripper stripper;
    private final List<String> manifestAttributes;

    public DefaultZipStripper(ZipStripper stripper, boolean overwrite, List<String> manifestAttributes) {
        this.overwrite = overwrite;
        this.manifestAttributes = Collections.unmodifiableList(manifestAttributes);
        this.stripper = this.configure(stripper);
    }

    @Override
    public void strip(File zip, File stripped) throws IOException {
        this.stripper.strip(zip, stripped);
        if (this.overwrite) {
            Files.move(stripped.toPath(), zip.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private ZipStripper configure(ZipStripper zip) {
        zip.addFileStripper("META-INF/MANIFEST.MF", new ManifestStripper(this.manifestAttributes)).addFileStripper("META-INF/maven/\\S*/pom.properties", new PropertiesFileStripper(new String[0])).addFileStripper("META-INF/maven/plugin.xml", new MavenPluginToolsStripper()).addFileStripper("META-INF/maven/\\S*/plugin-help.xml", new MavenPluginToolsStripper()).addFileStripper("META-INF/sisu/javax.inject.Named", LineEndingsStripper.INSTANCE).addFileStripper("META-INF/build-info.properties", new PropertiesFileStripper("build.time")).addFileStripper("BOOT-INF/classes/git.properties", new PropertiesFileStripper("git.build.host", "git.build.time", "git.build.user.email", "git.build.user.name")).addFileStripper("META-INF/spring.factories", new PropertiesFileStripper(new String[0]));
        return zip;
    }
}

