/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

final class CompoundStripper
implements Stripper {
    private final Stripper[] strippers;

    public CompoundStripper(Stripper ... strippers) {
        this.strippers = strippers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void strip(File in, File out) throws IOException {
        ArrayList<File> tmpFiles = new ArrayList<File>();
        File currentIn = in;
        try {
            for (Stripper stripper : this.strippers) {
                File tmp = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
                tmp.deleteOnExit();
                tmpFiles.add(tmp);
                stripper.strip(currentIn, tmp);
                currentIn = tmp;
            }
            Files.copy(currentIn.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            for (File file : tmpFiles) {
                Files.delete(file.toPath());
            }
        }
    }
}

