/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.impl;

import ch.cmbntr.modulizer.bootstrap.BootstrapContext;
import ch.cmbntr.modulizer.bootstrap.Operation;
import ch.cmbntr.modulizer.bootstrap.Operations;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import ch.cmbntr.modulizer.bootstrap.util.Preloading;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

public abstract class AbstractOperation
implements Operation {
    protected void preload(boolean requiresGUI, String preloadSpec) {
        ClassLoader loader = this.getClass().getClassLoader();
        Preloading.preload(requiresGUI, loader, preloadSpec);
    }

    protected static List<String> findMatchingContextKeys(Pattern check) {
        LinkedList<String> matches = new LinkedList<String>();
        BootstrapContext ctx = BootstrapContext.CURRENT.get();
        if (ctx != null) {
            for (String k : ctx.keySet()) {
                if (!check.matcher(k).matches()) continue;
                matches.add(k);
            }
        }
        return matches;
    }

    protected static String lookupContext(String key) {
        BootstrapContext ctx = BootstrapContext.CURRENT.get();
        return ctx == null ? null : (String)ctx.get(key);
    }

    protected static String lookupContextInterpolated(String key) {
        BootstrapContext ctx = BootstrapContext.CURRENT.get();
        return ctx == null ? null : ctx.getInterpolated(key);
    }

    protected static String putContext(String key, String value) {
        BootstrapContext ctx = BootstrapContext.CURRENT.get();
        if (ctx == null) {
            throw new IllegalStateException("context was null");
        }
        return ctx.put(key, value);
    }

    protected static String lookupContextWithFallback(String primary, String alternate) {
        String firstChoice = AbstractOperation.lookupContext(primary);
        return firstChoice == null ? AbstractOperation.lookupContext(alternate) : firstChoice;
    }

    protected static Future<ClassLoader> pluginLoaderViaSpecKey(Resources.Pool pool, String pluginSpecKey) {
        File pluginDir = new File(AbstractOperation.lookupContext("modulizer.bootstrap.app.dir"), "bootstrap_plugins");
        return Resources.submit(pool, Operations.PluginLoader.create(pluginDir, AbstractOperation.lookupContext(pluginSpecKey)));
    }

    protected static <S extends Operation> void invokePluginOperations(boolean restoreSystemProps, Class<S> operationType, Future<ClassLoader> pluginLoader) {
        Operations.invokeOperations(restoreSystemProps, operationType, pluginLoader);
    }

    protected static void log(String msg, Object ... args) {
        ModulizerLog.log(msg, args);
    }

    protected static void warn(String msg, Object ... args) {
        ModulizerLog.warn(msg, args);
    }
}

