/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.MessageHandler;
import ch.awae.netcode.NetcodeClient;
import ch.awae.netcode.NetcodeClientImpl;
import ch.awae.netcode.NetcodeHandshakeRequest;
import ch.awae.netcode.SecurityMode;
import ch.awae.netcode.SocketMode;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class NetcodeClientFactory {
    private List<Consumer<Socket>> afterBind = new ArrayList<Consumer<Socket>>();
    private SocketMode socketMode = SocketMode.TLS;
    private SecurityMode securityMode = SecurityMode.ANONYMOUS;
    private MessageHandler messageHandler;
    private final String appId;
    private final String host;
    private final int port;

    public NetcodeClientFactory(String host, int port, String appId) {
        this.host = host;
        this.port = port;
        this.appId = appId;
    }

    public void runAfterBind(Consumer<Socket> runner) {
        this.afterBind.add(runner);
    }

    public void setMode(SocketMode socketMode, SecurityMode securityMode) {
        if (socketMode == SocketMode.PLAIN && securityMode != SecurityMode.ANY) {
            throw new IllegalArgumentException("incompatible securityMode");
        }
        this.socketMode = socketMode;
        this.securityMode = securityMode;
    }

    public NetcodeClient createChannel(String userId, ChannelConfiguration configuration) throws IOException, ConnectionException {
        NetcodeClientImpl client = this.initSocket();
        client.open(new NetcodeHandshakeRequest(this.appId, null, userId, true, configuration));
        return client;
    }

    public NetcodeClient joinChannel(String userId, String channelId) throws IOException, ConnectionException {
        NetcodeClientImpl client = this.initSocket();
        client.open(new NetcodeHandshakeRequest(this.appId, channelId, userId, false, null));
        return client;
    }

    private NetcodeClientImpl initSocket() throws IOException {
        SocketFactory sf = this.socketMode == SocketMode.PLAIN ? SocketFactory.getDefault() : SSLSocketFactory.getDefault();
        Socket s = sf.createSocket(this.host, this.port);
        s.setKeepAlive(true);
        if (this.socketMode != SocketMode.PLAIN) {
            SSLSocket ssls = (SSLSocket)s;
            this.applySecuritySettings(ssls);
            ssls.startHandshake();
        }
        for (Consumer<Socket> f : this.afterBind) {
            f.accept(s);
        }
        return new NetcodeClientImpl(s, this.messageHandler);
    }

    private void applySecuritySettings(SSLSocket socket) {
        ArrayList<String> ciphers = new ArrayList<String>();
        for (String c : socket.getSupportedCipherSuites()) {
            if (this.socketMode == SocketMode.SSL && !c.startsWith("SSL") || this.socketMode == SocketMode.TLS && !c.startsWith("TLS") || this.securityMode == SecurityMode.CERTIFICATE && c.contains("_anon_") || this.securityMode == SecurityMode.ANONYMOUS && !c.contains("_anon_")) continue;
            ciphers.add(c);
        }
        socket.setEnabledCipherSuites(ciphers.toArray(new String[0]));
    }

    public SocketMode getSocketMode() {
        return this.socketMode;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }
}

