/*
 * Decompiled with CFR 0.152.
 */
package ca.solostudios.guava.kotlin.collect;

import ca.solostudios.guava.kotlin.annotations.ExperimentalGuavaCollectionsApi;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.ParametricNullness;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u001d\n\u0002\b\u001c\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006H\u0086\b\u00a2\u0006\u0002\u0010\t\u001a'\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u001a2\u0010\u000e\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0014\b\b\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000\u001a2\u0010\u0011\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0014\b\b\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000\u001a\u0019\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u001aD\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u001e\u0010\u0015\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00020\b\"\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u00a2\u0006\u0002\u0010\u0016\u001a-\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\f\u001a;\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u001aI\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u001aF\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001b2\u001e\u0010\u0015\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00060\u001b0\b\"\b\u0012\u0004\u0012\u0002H\u00060\u001bH\u0087\b\u00a2\u0006\u0004\b\u001c\u0010\u0016\u001a2\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001bH\u0087\f\u00a2\u0006\u0002\b\u001c\u001a@\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001bH\u0087\b\u00a2\u0006\u0002\b\u001c\u001aN\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001bH\u0087\b\u00a2\u0006\u0002\b\u001c\u001a\u001f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001bH\u0086\b\u001a\u001f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u001a$\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001bH\u0087\b\u00a2\u0006\u0002\b\u001e\u001a'\u0010\u001f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u001a\u001f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0006\b\u0000\u0010\u0006\u0018\u0001*\u0006\u0012\u0002\b\u00030\u0002H\u0086\b\u001a8\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0014\b\b\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000\u001aC\u0010#\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\n\b\u0002\u0010$\u001a\u0004\u0018\u0001H\u00062\u0014\b\b\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%\u001a%\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00020\u0002H\u0086\b\u001a*\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u001b0\u0002H\u0087\b\u00a2\u0006\u0002\b'\u001a&\u0010(\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0006\u0010)\u001a\u0002H\u0006H\u0086\b\u00a2\u0006\u0002\u0010*\u001a&\u0010+\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0006\u0010,\u001a\u00020\u0001H\u0086\n\u00a2\u0006\u0002\u0010-\u001a2\u0010+\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0006\u0010,\u001a\u00020\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u0001H\u0006H\u0086\b\u00a2\u0006\u0002\u0010.\u001a&\u0010/\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0006\u0010$\u001a\u0002H\u0006H\u0086\b\u00a2\u0006\u0002\u00100\u001a*\u00101\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\n\b\u0002\u0010$\u001a\u0004\u0018\u0001H\u0006H\u0086\b\u00a2\u0006\u0002\u00100\u001a2\u00102\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0014\b\b\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000\u001a\u0019\u00103\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u001a'\u00104\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0006\u00105\u001a\u00020\u0001H\u0086\b\u001aT\u00106\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006\"\u000e\b\u0001\u00107*\b\u0012\u0004\u0012\u0002H708*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00020\u00022\u001a\b\u0004\u00109\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H7080\u0010H\u0086\b\u00f8\u0001\u0000\u001a=\u00106\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00020\u00022\u0016\u0010:\u001a\u0012\u0012\u0004\u0012\u0002H\u00060;j\b\u0012\u0004\u0012\u0002H\u0006`<H\u0087\b\u001a/\u0010=\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00060>0\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0006\u0010\u0000\u001a\u00020\u0001H\u0086\b\u001a-\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060>0\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0006\u0010\u0000\u001a\u00020\u0001H\u0086\b\u001a'\u0010@\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001b2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H\u00060BH\u0086\b\u001a2\u0010C\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001b2\u0014\b\b\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000\u001a'\u0010D\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001b2\f\u0010E\u001a\b\u0012\u0004\u0012\u0002H\u00060BH\u0086\b\u001a'\u0010F\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0006\u0010G\u001a\u00020\u0001H\u0086\b\u001a,\u0010F\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001b2\u0006\u0010G\u001a\u00020\u0001H\u0087\b\u00a2\u0006\u0002\bH\u001a(\u0010I\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0006\b\u0000\u0010\u0006\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00060\u0002H\u0086\b\u00a2\u0006\u0002\u0010J\u001a>\u0010K\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010L\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002HL0\u00022\u0014\b\b\u0010M\u001a\u000e\u0012\u0004\u0012\u0002HL\u0012\u0004\u0012\u0002H\u00060\u0010H\u0086\b\u00f8\u0001\u0000\u001aC\u0010K\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001b\"\u0004\b\u0000\u0010L\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002HL0\u001b2\u0014\b\b\u0010M\u001a\u000e\u0012\u0004\u0012\u0002HL\u0012\u0004\u0012\u0002H\u00060\u0010H\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\bN\u001a8\u0010O\u001a\b\u0012\u0004\u0012\u0002H\u00060P\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00022\u0014\b\b\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\b\u00f8\u0001\u0000\u001a\u001f\u0010Q\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0002\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u001bH\u0086\b\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006R"}, d2={"size", "", "", "getSize", "(Ljava/lang/Iterable;)I", "cycleIterable", "T", "elements", "", "([Ljava/lang/Object;)Ljava/lang/Iterable;", "addAll", "", "", "elementsToAdd", "all", "predicate", "Lkotlin/Function1;", "any", "asString", "", "concat", "iterables", "(Ljava/lang/Iterable;[Ljava/lang/Iterable;)Ljava/lang/Iterable;", "other", "a", "b", "c", "", "concatMutable", "consumingIterable", "cycleIterableMutable", "elementsEqual", "filterIsInstanceView", "filterView", "retainIfTrue", "find", "defaultValue", "(Ljava/lang/Iterable;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "flatConcat", "flatConcatMutable", "frequency", "element", "(Ljava/lang/Iterable;Ljava/lang/Object;)I", "get", "position", "(Ljava/lang/Iterable;I)Ljava/lang/Object;", "(Ljava/lang/Iterable;ILjava/lang/Object;)Ljava/lang/Object;", "getFirst", "(Ljava/lang/Iterable;Ljava/lang/Object;)Ljava/lang/Object;", "getLast", "indexOf", "isEmpty", "limit", "limitSize", "mergeSorted", "R", "", "selector", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "paddedPartition", "", "partition", "removeAll", "elementsToRemove", "", "removeIf", "retainAll", "elementsToRetain", "skip", "numberToSkip", "skipMutable", "toTypedArray", "(Ljava/lang/Iterable;)[Ljava/lang/Object;", "transform", "F", "function", "transformMutable", "tryFind", "Lcom/google/common/base/Optional;", "unmodifiableIterable", "guava-kotlin"})
public final class IterablesKt {
    @NotNull
    public static final <T> Iterable<T> unmodifiableIterable(@NotNull Iterable<? extends T> $this$unmodifiableIterable) {
        Intrinsics.checkNotNullParameter($this$unmodifiableIterable, (String)"<this>");
        boolean $i$f$unmodifiableIterable = false;
        Iterable iterable = Iterables.unmodifiableIterable($this$unmodifiableIterable);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"unmodifiableIterable(this)");
        return iterable;
    }

    public static final int getSize(@NotNull Iterable<?> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return Iterables.size($this$size);
    }

    public static final <T> boolean removeAll(@NotNull Iterable<? extends T> $this$removeAll, @NotNull Collection<? extends T> elementsToRemove) {
        Intrinsics.checkNotNullParameter($this$removeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(elementsToRemove, (String)"elementsToRemove");
        boolean $i$f$removeAll = false;
        return Iterables.removeAll($this$removeAll, elementsToRemove);
    }

    public static final <T> boolean retainAll(@NotNull Iterable<? extends T> $this$retainAll, @NotNull Collection<? extends T> elementsToRetain) {
        Intrinsics.checkNotNullParameter($this$retainAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(elementsToRetain, (String)"elementsToRetain");
        boolean $i$f$retainAll = false;
        return Iterables.retainAll($this$retainAll, elementsToRetain);
    }

    public static final <T> boolean removeIf(@NotNull Iterable<? extends T> $this$removeIf, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$removeIf, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$removeIf = false;
        return Iterables.removeIf($this$removeIf, (Predicate)new Predicate(predicate){
            private final /* synthetic */ Function1 function;
            {
                this.function = function;
            }

            public final /* synthetic */ boolean apply(@ParametricNullness Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
    }

    public static final <T> boolean elementsEqual(@NotNull Iterable<? extends T> $this$elementsEqual, @NotNull Iterable<? extends T> other) {
        Intrinsics.checkNotNullParameter($this$elementsEqual, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean $i$f$elementsEqual = false;
        return Iterables.elementsEqual($this$elementsEqual, other);
    }

    @NotNull
    public static final <T> String asString(@NotNull Iterable<? extends T> $this$asString) {
        Intrinsics.checkNotNullParameter($this$asString, (String)"<this>");
        boolean $i$f$asString = false;
        String string = Iterables.toString($this$asString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return string;
    }

    public static final /* synthetic */ <T> T[] toTypedArray(Iterable<? extends T> $this$toTypedArray) {
        Intrinsics.checkNotNullParameter($this$toTypedArray, (String)"<this>");
        boolean $i$f$toTypedArray = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object[] objectArray = Iterables.toArray($this$toTypedArray, Object.class);
        Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<out T of ca.solostudios.guava.kotlin.collect.IterablesKt.toTypedArray>");
        return objectArray;
    }

    public static final <T> boolean addAll(@NotNull Collection<T> $this$addAll, @NotNull Iterable<? extends T> elementsToAdd) {
        Intrinsics.checkNotNullParameter($this$addAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(elementsToAdd, (String)"elementsToAdd");
        boolean $i$f$addAll = false;
        return Iterables.addAll($this$addAll, elementsToAdd);
    }

    public static final <T> int frequency(@NotNull Iterable<? extends T> $this$frequency, T element) {
        Intrinsics.checkNotNullParameter($this$frequency, (String)"<this>");
        boolean $i$f$frequency = false;
        return Iterables.frequency($this$frequency, element);
    }

    @NotNull
    public static final <T> Iterable<T> cycleIterable(@NotNull Iterable<? extends T> $this$cycleIterable) {
        Intrinsics.checkNotNullParameter($this$cycleIterable, (String)"<this>");
        boolean $i$f$cycleIterable = false;
        Iterable iterable = Iterables.cycle($this$cycleIterable);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"cycle(this)");
        return iterable;
    }

    @JvmName(name="cycleIterableMutable")
    @NotNull
    public static final <T> Iterable<T> cycleIterableMutable(@NotNull Iterable<? extends T> $this$cycleIterable) {
        Intrinsics.checkNotNullParameter($this$cycleIterable, (String)"<this>");
        boolean $i$f$cycleIterableMutable = false;
        Iterable iterable = Iterables.cycle($this$cycleIterable);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"cycle(this)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> cycleIterable(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$cycleIterable = false;
        Iterable iterable = Iterables.cycle((Iterable)Lists.newArrayList((Object[])Arrays.copyOf(elements, elements.length)));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"cycle(Lists.newArrayList(*elements))");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> concat(@NotNull Iterable<? extends T> $this$concat, @NotNull Iterable<? extends T> other) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean $i$f$concat = false;
        Iterable iterable = Iterables.concat($this$concat, other);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this, other)");
        return iterable;
    }

    @JvmName(name="concatMutable")
    @NotNull
    public static final <T> Iterable<T> concatMutable(@NotNull Iterable<? extends T> $this$concat, @NotNull Iterable<? extends T> other) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        boolean $i$f$concatMutable = false;
        Iterable iterable = Iterables.concat($this$concat, other);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this, other)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> concat(@NotNull Iterable<? extends T> $this$concat, @NotNull Iterable<? extends T> a, @NotNull Iterable<? extends T> b) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        boolean $i$f$concat = false;
        Iterable iterable = Iterables.concat($this$concat, a, b);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this, a, b)");
        return iterable;
    }

    @JvmName(name="concatMutable")
    @NotNull
    public static final <T> Iterable<T> concatMutable(@NotNull Iterable<? extends T> $this$concat, @NotNull Iterable<? extends T> a, @NotNull Iterable<? extends T> b) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        boolean $i$f$concatMutable = false;
        Iterable iterable = Iterables.concat($this$concat, a, b);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this, a, b)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> concat(@NotNull Iterable<? extends T> $this$concat, @NotNull Iterable<? extends T> a, @NotNull Iterable<? extends T> b, @NotNull Iterable<? extends T> c) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        boolean $i$f$concat = false;
        Iterable iterable = Iterables.concat($this$concat, a, b, c);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this, a, b, c)");
        return iterable;
    }

    @JvmName(name="concatMutable")
    @NotNull
    public static final <T> Iterable<T> concatMutable(@NotNull Iterable<? extends T> $this$concat, @NotNull Iterable<? extends T> a, @NotNull Iterable<? extends T> b, @NotNull Iterable<? extends T> c) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        boolean $i$f$concatMutable = false;
        Iterable iterable = Iterables.concat($this$concat, a, b, c);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this, a, b, c)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> concat(@NotNull Iterable<? extends T> $this$concat, Iterable<? extends T> ... iterables) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(iterables, (String)"iterables");
        boolean $i$f$concat = false;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add($this$concat);
        spreadBuilder.addSpread(iterables);
        Iterable iterable = Iterables.concat((Iterable[])((Iterable[])spreadBuilder.toArray((Object[])new Iterable[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this, *iterables)");
        return iterable;
    }

    @JvmName(name="concatMutable")
    @NotNull
    public static final <T> Iterable<T> concatMutable(@NotNull Iterable<? extends T> $this$concat, Iterable<? extends T> ... iterables) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(iterables, (String)"iterables");
        boolean $i$f$concatMutable = false;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add($this$concat);
        spreadBuilder.addSpread(iterables);
        Iterable iterable = Iterables.concat((Iterable[])((Iterable[])spreadBuilder.toArray((Object[])new Iterable[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this, *iterables)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> flatConcat(@NotNull Iterable<? extends Iterable<? extends T>> $this$flatConcat) {
        Intrinsics.checkNotNullParameter($this$flatConcat, (String)"<this>");
        boolean $i$f$flatConcat = false;
        Iterable iterable = Iterables.concat($this$flatConcat);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this)");
        return iterable;
    }

    @JvmName(name="flatConcatMutable")
    @NotNull
    public static final <T> Iterable<T> flatConcatMutable(@NotNull Iterable<? extends Iterable<? extends T>> $this$flatConcat) {
        Intrinsics.checkNotNullParameter($this$flatConcat, (String)"<this>");
        boolean $i$f$flatConcatMutable = false;
        Iterable iterable = Iterables.concat($this$flatConcat);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"concat(this)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<List<T>> partition(@NotNull Iterable<? extends T> $this$partition, int size) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter($this$partition, (String)"<this>");
        boolean $i$f$partition = false;
        Iterable iterable = Iterables.partition($this$partition, (int)size);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"partition(this, size)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<List<T>> paddedPartition(@NotNull Iterable<? extends T> $this$paddedPartition, int size) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter($this$paddedPartition, (String)"<this>");
        boolean $i$f$paddedPartition = false;
        Iterable iterable = Iterables.paddedPartition($this$paddedPartition, (int)size);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"paddedPartition(this, size)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> filterView(@NotNull Iterable<? extends T> $this$filterView, @NotNull Function1<? super T, Boolean> retainIfTrue) {
        Intrinsics.checkNotNullParameter($this$filterView, (String)"<this>");
        Intrinsics.checkNotNullParameter(retainIfTrue, (String)"retainIfTrue");
        boolean $i$f$filterView = false;
        Iterable iterable = Iterables.filter($this$filterView, (Predicate)new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"filter(this, retainIfTrue)");
        return iterable;
    }

    public static final /* synthetic */ <T> Iterable<T> filterIsInstanceView(Iterable<?> $this$filterIsInstanceView) {
        Intrinsics.checkNotNullParameter($this$filterIsInstanceView, (String)"<this>");
        boolean $i$f$filterIsInstanceView = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Iterable iterable = Iterables.filter($this$filterIsInstanceView, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"filter(this, T::class.java)");
        return iterable;
    }

    public static final <T> boolean any(@NotNull Iterable<? extends T> $this$any, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$any, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$any = false;
        return Iterables.any($this$any, (Predicate)new /* invalid duplicate definition of identical inner class */);
    }

    public static final <T> boolean all(@NotNull Iterable<? extends T> $this$all, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$all, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$all = false;
        return Iterables.all($this$all, (Predicate)new /* invalid duplicate definition of identical inner class */);
    }

    public static final <T> T find(@NotNull Iterable<? extends T> $this$find, @Nullable T defaultValue, @NotNull Function1<? super T, Boolean> predicate) throws NoSuchElementException {
        Object object;
        Intrinsics.checkNotNullParameter($this$find, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$find = false;
        if (defaultValue == null) {
            object = Iterables.find($this$find, (Predicate)new /* invalid duplicate definition of identical inner class */);
        } else {
            Object object2 = Iterables.find($this$find, (Predicate)new /* invalid duplicate definition of identical inner class */, defaultValue);
            object = object2;
            Intrinsics.checkNotNull((Object)object2);
        }
        return (T)object;
    }

    public static /* synthetic */ Object find$default(Iterable $this$find_u24default, Object defaultValue, Function1 predicate, int n, Object object) throws NoSuchElementException {
        Object object2;
        if ((n & 1) != 0) {
            defaultValue = null;
        }
        Intrinsics.checkNotNullParameter((Object)$this$find_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        boolean $i$f$find = false;
        if (defaultValue == null) {
            object2 = Iterables.find((Iterable)$this$find_u24default, (Predicate)new /* invalid duplicate definition of identical inner class */);
        } else {
            Object object3 = Iterables.find((Iterable)$this$find_u24default, (Predicate)new /* invalid duplicate definition of identical inner class */, (Object)defaultValue);
            object2 = object3;
            Intrinsics.checkNotNull((Object)object3);
        }
        return object2;
    }

    @NotNull
    public static final <T> Optional<T> tryFind(@NotNull Iterable<? extends T> $this$tryFind, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$tryFind, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$tryFind = false;
        Optional optional = Iterables.tryFind($this$tryFind, (Predicate)new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"tryFind(this, predicate)");
        return optional;
    }

    public static final <T> int indexOf(@NotNull Iterable<? extends T> $this$indexOf, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$indexOf = false;
        return Iterables.indexOf($this$indexOf, (Predicate)new /* invalid duplicate definition of identical inner class */);
    }

    @NotNull
    public static final <F, T> Iterable<T> transform(@NotNull Iterable<? extends F> $this$transform, @NotNull Function1<? super F, ? extends T> function) {
        Intrinsics.checkNotNullParameter($this$transform, (String)"<this>");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        boolean $i$f$transform = false;
        Iterable iterable = Iterables.transform($this$transform, (Function)new Function(function){
            private final /* synthetic */ Function1 function;
            {
                this.function = function;
            }

            public final /* synthetic */ Object apply(@ParametricNullness Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"transform(this, function)");
        return iterable;
    }

    @JvmName(name="transformMutable")
    @NotNull
    public static final <F, T> Iterable<T> transformMutable(@NotNull Iterable<? extends F> $this$transform, @NotNull Function1<? super F, ? extends T> function) {
        Intrinsics.checkNotNullParameter($this$transform, (String)"<this>");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        boolean $i$f$transformMutable = false;
        Iterable iterable = Iterables.transform($this$transform, (Function)new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"transform(this, function)");
        return iterable;
    }

    public static final <T> T get(@NotNull Iterable<? extends T> $this$get, int position) throws IndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        boolean $i$f$get = false;
        return (T)Iterables.get($this$get, (int)position);
    }

    public static final <T> T get(@NotNull Iterable<? extends T> $this$get, int position, @Nullable T defaultValue) throws IndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        boolean $i$f$get = false;
        return (T)(defaultValue == null ? Iterables.get($this$get, (int)position) : Iterables.get($this$get, (int)position, defaultValue));
    }

    public static /* synthetic */ Object get$default(Iterable $this$get_u24default, int position, Object defaultValue, int n, Object object) throws IndexOutOfBoundsException {
        if ((n & 2) != 0) {
            defaultValue = null;
        }
        Intrinsics.checkNotNullParameter((Object)$this$get_u24default, (String)"<this>");
        boolean $i$f$get = false;
        return defaultValue == null ? Iterables.get((Iterable)$this$get_u24default, (int)position) : Iterables.get((Iterable)$this$get_u24default, (int)position, (Object)defaultValue);
    }

    public static final <T> T getFirst(@NotNull Iterable<? extends T> $this$getFirst, T defaultValue) {
        Intrinsics.checkNotNullParameter($this$getFirst, (String)"<this>");
        boolean $i$f$getFirst = false;
        return (T)Iterables.getFirst($this$getFirst, defaultValue);
    }

    public static final <T> T getLast(@NotNull Iterable<? extends T> $this$getLast, @Nullable T defaultValue) throws NoSuchElementException {
        Intrinsics.checkNotNullParameter($this$getLast, (String)"<this>");
        boolean $i$f$getLast = false;
        T t = defaultValue;
        return (T)(t == null ? Iterables.getLast($this$getLast) : Iterables.getLast($this$getLast, t));
    }

    public static /* synthetic */ Object getLast$default(Iterable $this$getLast_u24default, Object defaultValue, int n, Object object) throws NoSuchElementException {
        if ((n & 1) != 0) {
            defaultValue = null;
        }
        Intrinsics.checkNotNullParameter((Object)$this$getLast_u24default, (String)"<this>");
        boolean $i$f$getLast = false;
        Object object2 = defaultValue;
        return object2 == null ? Iterables.getLast((Iterable)$this$getLast_u24default) : Iterables.getLast((Iterable)$this$getLast_u24default, (Object)object2);
    }

    @NotNull
    public static final <T> Iterable<T> skip(@NotNull Iterable<? extends T> $this$skip, int numberToSkip) {
        Intrinsics.checkNotNullParameter($this$skip, (String)"<this>");
        boolean $i$f$skip = false;
        Iterable iterable = Iterables.skip($this$skip, (int)numberToSkip);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"skip(this, numberToSkip)");
        return iterable;
    }

    @JvmName(name="skipMutable")
    @NotNull
    public static final <T> Iterable<T> skipMutable(@NotNull Iterable<? extends T> $this$skip, int numberToSkip) {
        Intrinsics.checkNotNullParameter($this$skip, (String)"<this>");
        boolean $i$f$skipMutable = false;
        Iterable iterable = Iterables.skip($this$skip, (int)numberToSkip);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"skip(this, numberToSkip)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> limit(@NotNull Iterable<? extends T> $this$limit, int limitSize) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter($this$limit, (String)"<this>");
        boolean $i$f$limit = false;
        Iterable iterable = Iterables.limit($this$limit, (int)limitSize);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"limit(this, limitSize)");
        return iterable;
    }

    @NotNull
    public static final <T> Iterable<T> consumingIterable(@NotNull Iterable<? extends T> $this$consumingIterable) {
        Intrinsics.checkNotNullParameter($this$consumingIterable, (String)"<this>");
        boolean $i$f$consumingIterable = false;
        Iterable iterable = Iterables.consumingIterable($this$consumingIterable);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"consumingIterable(this)");
        return iterable;
    }

    public static final <T> boolean isEmpty(@NotNull Iterable<? extends T> $this$isEmpty) {
        Intrinsics.checkNotNullParameter($this$isEmpty, (String)"<this>");
        boolean $i$f$isEmpty = false;
        return Iterables.isEmpty($this$isEmpty);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R extends Comparable<? super R>> Iterable<T> mergeSorted(@NotNull Iterable<? extends Iterable<? extends T>> $this$mergeSorted, @NotNull Function1<? super T, ? extends Comparable<? super R>> selector) {
        void comparator$iv;
        void $this$mergeSorted$iv;
        Intrinsics.checkNotNullParameter($this$mergeSorted, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        boolean $i$f$mergeSorted = false;
        Iterable<? extends Iterable<? extends T>> iterable = $this$mergeSorted;
        Comparator comparator = new Comparator(selector){
            final /* synthetic */ Function1 $selector;
            {
                this.$selector = $selector;
            }

            public final int compare(T a, T b) {
                Function1 function1 = this.$selector;
                return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
            }
        };
        boolean $i$f$mergeSorted2 = false;
        Iterable iterable2 = Iterables.mergeSorted((Iterable)$this$mergeSorted$iv, (Comparator)comparator$iv);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"mergeSorted(this, comparator)");
        return iterable2;
    }

    @ExperimentalGuavaCollectionsApi
    @NotNull
    public static final <T> Iterable<T> mergeSorted(@NotNull Iterable<? extends Iterable<? extends T>> $this$mergeSorted, @NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter($this$mergeSorted, (String)"<this>");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        boolean $i$f$mergeSorted = false;
        Iterable iterable = Iterables.mergeSorted($this$mergeSorted, comparator);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"mergeSorted(this, comparator)");
        return iterable;
    }
}

