/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.lambdas.tracing;

import ca.nexapp.lambdas.contexts.env.LambdaEnvLoader;
import ca.nexapp.tracing.Settings;
import ca.nexapp.tracing.Tracer;
import ca.nexapp.tracing.TracerFactory;
import com.amazonaws.xray.proxies.apache.http.HttpClientBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lca/nexapp/lambdas/tracing/LambdaTracingFactory;", "", "envLoader", "Lca/nexapp/lambdas/contexts/env/LambdaEnvLoader;", "tracerFactory", "Lca/nexapp/tracing/TracerFactory;", "<init>", "(Lca/nexapp/lambdas/contexts/env/LambdaEnvLoader;Lca/nexapp/tracing/TracerFactory;)V", "createTracer", "Lca/nexapp/tracing/Tracer;", "createHttpClientBuilder", "Lorg/apache/http/impl/client/HttpClientBuilder;", "isXRayTracingEnabled", "", "nexapp-aws-lambda"})
public final class LambdaTracingFactory {
    @NotNull
    private final LambdaEnvLoader envLoader;
    @NotNull
    private final TracerFactory tracerFactory;

    public LambdaTracingFactory(@NotNull LambdaEnvLoader envLoader, @NotNull TracerFactory tracerFactory) {
        Intrinsics.checkNotNullParameter((Object)envLoader, (String)"envLoader");
        Intrinsics.checkNotNullParameter((Object)tracerFactory, (String)"tracerFactory");
        this.envLoader = envLoader;
        this.tracerFactory = tracerFactory;
    }

    @NotNull
    public final Tracer createTracer() {
        Settings tracerSettings = new Settings(this.isXRayTracingEnabled(), true, true);
        return this.tracerFactory.create(tracerSettings);
    }

    @NotNull
    public final org.apache.http.impl.client.HttpClientBuilder createHttpClientBuilder() {
        if (this.isXRayTracingEnabled()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            Intrinsics.checkNotNullExpressionValue((Object)httpClientBuilder, (String)"create(...)");
            return (org.apache.http.impl.client.HttpClientBuilder)httpClientBuilder;
        }
        org.apache.http.impl.client.HttpClientBuilder httpClientBuilder = org.apache.http.impl.client.HttpClientBuilder.create();
        Intrinsics.checkNotNullExpressionValue((Object)httpClientBuilder, (String)"create(...)");
        return httpClientBuilder;
    }

    private final boolean isXRayTracingEnabled() {
        String string = this.envLoader.tryLoad("XRAY_TRACING_ENABLED");
        if (string == null) {
            string = "false";
        }
        String enabled = string;
        return Boolean.parseBoolean(enabled);
    }
}

