/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.lambdas.contexts.env;

import ca.nexapp.lambdas.contexts.env.CouldNotLoadEnvException;
import ca.nexapp.lambdas.contexts.env.LambdaEnvLoader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.SsmException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lca/nexapp/lambdas/contexts/env/SsmEnvLoader;", "Lca/nexapp/lambdas/contexts/env/LambdaEnvLoader;", "ssmPath", "", "ssm", "Lsoftware/amazon/awssdk/services/ssm/SsmClient;", "<init>", "(Ljava/lang/String;Lsoftware/amazon/awssdk/services/ssm/SsmClient;)V", "load", "env", "request", "Lsoftware/amazon/awssdk/services/ssm/model/GetParameterRequest;", "nexapp-aws-lambda"})
@SourceDebugExtension(value={"SMAP\nSsmEnvLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SsmEnvLoader.kt\nca/nexapp/lambdas/contexts/env/SsmEnvLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class SsmEnvLoader
implements LambdaEnvLoader {
    @NotNull
    private final String ssmPath;
    @NotNull
    private final SsmClient ssm;

    public SsmEnvLoader(@NotNull String ssmPath, @NotNull SsmClient ssm) {
        Intrinsics.checkNotNullParameter((Object)ssmPath, (String)"ssmPath");
        Intrinsics.checkNotNullParameter((Object)ssm, (String)"ssm");
        this.ssmPath = ssmPath;
        this.ssm = ssm;
    }

    @Override
    @NotNull
    public String load(@NotNull String env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        GetParameterRequest it = (GetParameterRequest)GetParameterRequest.builder().name(this.ssmPath + "/" + env).withDecryption(Boolean.valueOf(true)).build();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.load(env, it);
    }

    private final String load(String env, GetParameterRequest request) {
        String string;
        try {
            string = this.ssm.getParameter(request).parameter().value();
        }
        catch (SsmException error) {
            throw new CouldNotLoadEnvException(env, error);
        }
        return string;
    }

    @Override
    @Nullable
    public String tryLoad(@NotNull String env) {
        return LambdaEnvLoader.DefaultImpls.tryLoad(this, env);
    }
}

