/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.lambdas.contexts;

import ca.nexapp.lambdas.contexts.env.LambdaEnvLoader;
import ca.nexapp.lambdas.contexts.env.LambdaEnvLoaderFactory;
import ca.nexapp.lambdas.logging.LambdaLogger;
import ca.nexapp.lambdas.logging.LambdaLoggingFactory;
import ca.nexapp.lambdas.tracing.LambdaTracingFactory;
import ca.nexapp.tracing.Tracer;
import ca.nexapp.tracing.TracerFactory;
import java.time.Clock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\r\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lca/nexapp/lambdas/contexts/LambdaContext;", "", "clock", "Ljava/time/Clock;", "envLoader", "Lca/nexapp/lambdas/contexts/env/LambdaEnvLoader;", "<init>", "(Ljava/time/Clock;Lca/nexapp/lambdas/contexts/env/LambdaEnvLoader;)V", "logger", "Lca/nexapp/lambdas/logging/LambdaLogger;", "getLogger", "()Lca/nexapp/lambdas/logging/LambdaLogger;", "logger$delegate", "Lkotlin/Lazy;", "tracer", "Lca/nexapp/tracing/Tracer;", "getTracer", "()Lca/nexapp/tracing/Tracer;", "tracer$delegate", "tracingFactory", "Lca/nexapp/lambdas/tracing/LambdaTracingFactory;", "getTracingFactory", "()Lca/nexapp/lambdas/tracing/LambdaTracingFactory;", "tracingFactory$delegate", "loggingFactory", "Lca/nexapp/lambdas/logging/LambdaLoggingFactory;", "getLoggingFactory", "()Lca/nexapp/lambdas/logging/LambdaLoggingFactory;", "loggingFactory$delegate", "nexapp-aws-lambda"})
public class LambdaContext {
    @NotNull
    private final Clock clock;
    @NotNull
    private final LambdaEnvLoader envLoader;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final Lazy tracer$delegate;
    @NotNull
    private final Lazy tracingFactory$delegate;
    @NotNull
    private final Lazy loggingFactory$delegate;

    public LambdaContext(@NotNull Clock clock, @NotNull LambdaEnvLoader envLoader) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)envLoader, (String)"envLoader");
        this.clock = clock;
        this.envLoader = envLoader;
        this.logger$delegate = LazyKt.lazy(() -> LambdaContext.logger_delegate$lambda$0(this));
        this.tracer$delegate = LazyKt.lazy(() -> LambdaContext.tracer_delegate$lambda$1(this));
        this.tracingFactory$delegate = LazyKt.lazy(() -> LambdaContext.tracingFactory_delegate$lambda$2(this));
        this.loggingFactory$delegate = LazyKt.lazy(() -> LambdaContext.loggingFactory_delegate$lambda$3(this));
    }

    public /* synthetic */ LambdaContext(Clock clock, LambdaEnvLoader lambdaEnvLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock = Clock.systemUTC();
        }
        if ((n & 2) != 0) {
            lambdaEnvLoader = new LambdaEnvLoaderFactory(null, null, 3, null).create();
        }
        this(clock, lambdaEnvLoader);
    }

    @NotNull
    public final LambdaLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (LambdaLogger)lazy.getValue();
    }

    @NotNull
    public final Tracer getTracer() {
        Lazy lazy = this.tracer$delegate;
        return (Tracer)lazy.getValue();
    }

    @NotNull
    public LambdaTracingFactory getTracingFactory() {
        Lazy lazy = this.tracingFactory$delegate;
        return (LambdaTracingFactory)lazy.getValue();
    }

    @NotNull
    public LambdaLoggingFactory getLoggingFactory() {
        Lazy lazy = this.loggingFactory$delegate;
        return (LambdaLoggingFactory)lazy.getValue();
    }

    private static final LambdaLogger logger_delegate$lambda$0(LambdaContext this$0) {
        return this$0.getLoggingFactory().create();
    }

    private static final Tracer tracer_delegate$lambda$1(LambdaContext this$0) {
        return this$0.getTracingFactory().createTracer();
    }

    private static final LambdaTracingFactory tracingFactory_delegate$lambda$2(LambdaContext this$0) {
        return new LambdaTracingFactory(this$0.envLoader, new TracerFactory(this$0.clock));
    }

    private static final LambdaLoggingFactory loggingFactory_delegate$lambda$3(LambdaContext this$0) {
        return new LambdaLoggingFactory(this$0.envLoader);
    }

    public LambdaContext() {
        this(null, null, 3, null);
    }
}

