/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.lambdas;

import ca.nexapp.lambdas.contexts.LambdaContext;
import ca.nexapp.lambdas.logging.LambdaLogger;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lca/nexapp/lambdas/LambdaHandler;", "I", "O", "Lcom/amazonaws/services/lambda/runtime/RequestHandler;", "lambdaContext", "Lca/nexapp/lambdas/contexts/LambdaContext;", "<init>", "(Lca/nexapp/lambdas/contexts/LambdaContext;)V", "handleRequest", "input", "awsRuntimeContext", "Lcom/amazonaws/services/lambda/runtime/Context;", "(Ljava/lang/Object;Lcom/amazonaws/services/lambda/runtime/Context;)Ljava/lang/Object;", "handle", "context", "nexapp-aws-lambda"})
public abstract class LambdaHandler<I, O>
implements RequestHandler<I, O> {
    @NotNull
    private final LambdaContext lambdaContext;

    public LambdaHandler(@NotNull LambdaContext lambdaContext) {
        Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
        this.lambdaContext = lambdaContext;
    }

    public O handleRequest(I input, @NotNull Context awsRuntimeContext) {
        Intrinsics.checkNotNullParameter((Object)awsRuntimeContext, (String)"awsRuntimeContext");
        LambdaLogger logger = this.lambdaContext.getLogger();
        try {
            O response;
            I i = input;
            Intrinsics.checkNotNull(i);
            logger.recordRequest(i, awsRuntimeContext);
            O o = response = this.handle(input, awsRuntimeContext);
            Intrinsics.checkNotNull(o);
            logger.recordResponse(o, awsRuntimeContext);
            return response;
        }
        catch (Exception expected) {
            logger.recordHandlerError(expected, awsRuntimeContext);
            throw expected;
        }
    }

    protected abstract O handle(I var1, @NotNull Context var2);
}

