/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.lambdas.contexts.env;

import ca.nexapp.lambdas.contexts.env.CouldNotLoadEnvException;
import ca.nexapp.lambdas.contexts.env.LambdaEnvLoader;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.AWSSimpleSystemsManagementException;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lca/nexapp/lambdas/contexts/env/SsmEnvLoader;", "Lca/nexapp/lambdas/contexts/env/LambdaEnvLoader;", "ssmPath", "", "ssm", "Lcom/amazonaws/services/simplesystemsmanagement/AWSSimpleSystemsManagement;", "(Ljava/lang/String;Lcom/amazonaws/services/simplesystemsmanagement/AWSSimpleSystemsManagement;)V", "load", "env", "request", "Lcom/amazonaws/services/simplesystemsmanagement/model/GetParameterRequest;", "nexapp-aws-lambda"})
public final class SsmEnvLoader
implements LambdaEnvLoader {
    @NotNull
    private final String ssmPath;
    @NotNull
    private final AWSSimpleSystemsManagement ssm;

    public SsmEnvLoader(@NotNull String ssmPath, @NotNull AWSSimpleSystemsManagement ssm) {
        Intrinsics.checkNotNullParameter((Object)ssmPath, (String)"ssmPath");
        Intrinsics.checkNotNullParameter((Object)ssm, (String)"ssm");
        this.ssmPath = ssmPath;
        this.ssm = ssm;
    }

    @Override
    @NotNull
    public String load(@NotNull String env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        GetParameterRequest $this$load_u24lambda_u2d0 = new GetParameterRequest();
        boolean bl = false;
        $this$load_u24lambda_u2d0.setName(this.ssmPath + '/' + env);
        $this$load_u24lambda_u2d0.setWithDecryption(Boolean.valueOf(true));
        return this.load(env, $this$load_u24lambda_u2d0);
    }

    private final String load(String env, GetParameterRequest request) {
        String string;
        try {
            String string2 = this.ssm.getParameter(request).getParameter().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            ssm.getPar\u2026parameter.value\n        }");
            string = string2;
        }
        catch (AWSSimpleSystemsManagementException error) {
            throw new CouldNotLoadEnvException(env, error);
        }
        return string;
    }

    @Override
    @Nullable
    public String tryLoad(@NotNull String env) {
        return LambdaEnvLoader.DefaultImpls.tryLoad(this, env);
    }
}

