/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.lambdas.contexts.env;

import ca.nexapp.lambdas.contexts.env.CouldNotLoadEnvException;
import ca.nexapp.lambdas.contexts.env.LambdaEnvLoader;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.AWSSimpleSystemsManagementException;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterResult;
import com.amazonaws.services.simplesystemsmanagement.model.Parameter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lca/nexapp/lambdas/contexts/env/SsmEnvLoader;", "Lca/nexapp/lambdas/contexts/env/LambdaEnvLoader;", "ssmPath", "", "ssm", "Lcom/amazonaws/services/simplesystemsmanagement/AWSSimpleSystemsManagement;", "(Ljava/lang/String;Lcom/amazonaws/services/simplesystemsmanagement/AWSSimpleSystemsManagement;)V", "load", "env", "request", "Lcom/amazonaws/services/simplesystemsmanagement/model/GetParameterRequest;", "nexapp-aws-lambda"})
public final class SsmEnvLoader
implements LambdaEnvLoader {
    private final String ssmPath;
    private final AWSSimpleSystemsManagement ssm;

    @Override
    @NotNull
    public String load(@NotNull String env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        GetParameterRequest getParameterRequest = new GetParameterRequest();
        boolean bl = false;
        boolean bl2 = false;
        GetParameterRequest $this$with = getParameterRequest;
        boolean bl3 = false;
        $this$with.setName(this.ssmPath + '/' + env);
        $this$with.setWithDecryption(Boolean.valueOf(true));
        return this.load(env, $this$with);
    }

    private final String load(String env, GetParameterRequest request) {
        String string;
        try {
            GetParameterResult getParameterResult = this.ssm.getParameter(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)getParameterResult, (String)"ssm.getParameter(request)");
            Parameter parameter = getParameterResult.getParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"ssm.getParameter(request).parameter");
            String string2 = parameter.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ssm.getParameter(request).parameter.value");
            string = string2;
        }
        catch (AWSSimpleSystemsManagementException error) {
            throw (Throwable)new CouldNotLoadEnvException(env, error);
        }
        return string;
    }

    public SsmEnvLoader(@NotNull String ssmPath, @NotNull AWSSimpleSystemsManagement ssm) {
        Intrinsics.checkParameterIsNotNull((Object)ssmPath, (String)"ssmPath");
        Intrinsics.checkParameterIsNotNull((Object)ssm, (String)"ssm");
        this.ssmPath = ssmPath;
        this.ssm = ssm;
    }

    @Override
    @Nullable
    public String tryLoad(@NotNull String env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        return LambdaEnvLoader.DefaultImpls.tryLoad(this, env);
    }
}

