/*
 * Decompiled with CFR 0.152.
 */
package ca.gosyer.appdirs.impl;

import ca.gosyer.appdirs.AppDirsException;
import ca.gosyer.appdirs.impl.WindowsAppDirs;
import ca.gosyer.appdirs.impl.WindowsFolderResolver;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.Win32Exception;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002\u00a8\u0006\u000b"}, d2={"Lca/gosyer/appdirs/impl/ShellFolderResolver;", "Lca/gosyer/appdirs/impl/WindowsFolderResolver;", "()V", "convertFolderIdToCsidl", "", "folderId", "Lca/gosyer/appdirs/impl/WindowsAppDirs$FolderId;", "convertFolderIdToGuid", "Lcom/sun/jna/platform/win32/Guid$GUID;", "get", "", "Kotlin-Multiplatform-AppDirs"})
public final class ShellFolderResolver
implements WindowsFolderResolver {
    @Override
    @NotNull
    public String get(@NotNull WindowsAppDirs.FolderId folderId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)folderId), (String)"folderId");
        try {
            string = Shell32Util.getKnownFolderPath((Guid.GUID)this.convertFolderIdToGuid(folderId));
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Win32Exception e) {
            throw new AppDirsException("SHGetKnownFolderPath returns an error: " + e.getErrorCode());
        }
        catch (UnsatisfiedLinkError e) {
            String string2;
            try {
                int folder = this.convertFolderIdToCsidl(folderId);
                string2 = Shell32Util.getFolderPath((int)folder);
            }
            catch (Win32Exception e2) {
                throw new AppDirsException("SHGetFolderPath returns an error: " + e2.getErrorCode());
            }
            String string3 = string2;
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    private final Guid.GUID convertFolderIdToGuid(WindowsAppDirs.FolderId folderId) {
        Guid.GUID gUID;
        switch (WhenMappings.$EnumSwitchMapping$0[folderId.ordinal()]) {
            case 1: {
                Guid.GUID gUID2 = KnownFolders.FOLDERID_RoamingAppData;
                gUID = gUID2;
                Intrinsics.checkNotNullExpressionValue((Object)gUID2, (String)"FOLDERID_RoamingAppData");
                break;
            }
            case 2: {
                Guid.GUID gUID3 = KnownFolders.FOLDERID_LocalAppData;
                gUID = gUID3;
                Intrinsics.checkNotNullExpressionValue((Object)gUID3, (String)"FOLDERID_LocalAppData");
                break;
            }
            case 3: {
                Guid.GUID gUID4 = KnownFolders.FOLDERID_ProgramData;
                gUID = gUID4;
                Intrinsics.checkNotNullExpressionValue((Object)gUID4, (String)"FOLDERID_ProgramData");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return gUID;
    }

    private final int convertFolderIdToCsidl(WindowsAppDirs.FolderId folderId) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[folderId.ordinal()]) {
            case 1: {
                n = 26;
                break;
            }
            case 2: {
                n = 28;
                break;
            }
            case 3: {
                n = 35;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WindowsAppDirs.FolderId.values().length];
            try {
                nArray[WindowsAppDirs.FolderId.APPDATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsAppDirs.FolderId.LOCAL_APPDATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsAppDirs.FolderId.COMMON_APPDATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

