/*
 * Decompiled with CFR 0.152.
 */
package com.vanpra.composematerialdialogs.datetime.util;

import androidx.compose.ui.geometry.OffsetKt;
import com.vanpra.composematerialdialogs.datetime.util.JvmExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u001a\f\u0010\u0016\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0000\u001a\u0014\u0010\u001c\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\rH\u0000\u001a\u0014\u0010\u001e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001f\u001a\u00020\rH\u0000\u001a\u0014\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010!\u001a\u00020\rH\u0000\u001a\u0014\u0010\"\u001a\u00020\u0001*\u00020\u00012\u0006\u0010#\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\u00020\u0001*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u0018\u0010\t\u001a\u00020\n*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"maxTime", "Lkotlinx/datetime/LocalTime;", "minTime", "Max", "Lkotlinx/datetime/LocalTime$Companion;", "getMax", "(Lkotlinx/datetime/LocalTime$Companion;)Lkotlinx/datetime/LocalTime;", "Min", "getMin", "isAM", "", "(Lkotlinx/datetime/LocalTime;)Z", "simpleHour", "", "getSimpleHour", "(Lkotlinx/datetime/LocalTime;)I", "getOffset", "Landroidx/compose/ui/geometry/Offset;", "", "angle", "", "(FD)J", "noSeconds", "toAM", "toPM", "withDayOfMonth", "Lkotlinx/datetime/LocalDate;", "dayOfMonth", "withHour", "hour", "withMinute", "minute", "withNanosecond", "nanosecond", "withSecond", "second", "compose-material-dialogs-datetime"})
public final class ExtensionsKt {
    @NotNull
    private static final LocalTime minTime = new LocalTime(0, 0, 0, 0);
    @NotNull
    private static final LocalTime maxTime = new LocalTime(23, 59, 59, 999999999);

    public static final long getOffset(float $this$getOffset, double angle) {
        return OffsetKt.Offset((float)((float)((double)$this$getOffset * Math.cos(angle))), (float)((float)((double)$this$getOffset * Math.sin(angle))));
    }

    public static final boolean isAM(@NotNull LocalTime $this$isAM) {
        Intrinsics.checkNotNullParameter((Object)$this$isAM, (String)"<this>");
        int n = $this$isAM.getHour();
        return 0 <= n ? n < 12 : false;
    }

    public static final int getSimpleHour(@NotNull LocalTime $this$simpleHour) {
        Intrinsics.checkNotNullParameter((Object)$this$simpleHour, (String)"<this>");
        int tempHour = $this$simpleHour.getHour() % 12;
        return tempHour == 0 ? 12 : tempHour;
    }

    @NotNull
    public static final LocalTime toAM(@NotNull LocalTime $this$toAM) {
        Intrinsics.checkNotNullParameter((Object)$this$toAM, (String)"<this>");
        return ExtensionsKt.isAM($this$toAM) ? $this$toAM : JvmExtensionsKt.minusHours($this$toAM, 12L);
    }

    @NotNull
    public static final LocalTime toPM(@NotNull LocalTime $this$toPM) {
        Intrinsics.checkNotNullParameter((Object)$this$toPM, (String)"<this>");
        return !ExtensionsKt.isAM($this$toPM) ? $this$toPM : JvmExtensionsKt.plusHours($this$toPM, 12L);
    }

    @NotNull
    public static final LocalTime noSeconds(@NotNull LocalTime $this$noSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$noSeconds, (String)"<this>");
        return new LocalTime($this$noSeconds.getHour(), $this$noSeconds.getMinute(), 0, 0);
    }

    @NotNull
    public static final LocalTime withHour(@NotNull LocalTime $this$withHour, int hour) {
        Intrinsics.checkNotNullParameter((Object)$this$withHour, (String)"<this>");
        return new LocalTime(hour, $this$withHour.getMinute(), $this$withHour.getSecond(), $this$withHour.getNanosecond());
    }

    @NotNull
    public static final LocalTime withMinute(@NotNull LocalTime $this$withMinute, int minute) {
        Intrinsics.checkNotNullParameter((Object)$this$withMinute, (String)"<this>");
        return new LocalTime($this$withMinute.getHour(), minute, $this$withMinute.getSecond(), $this$withMinute.getNanosecond());
    }

    @NotNull
    public static final LocalTime withSecond(@NotNull LocalTime $this$withSecond, int second) {
        Intrinsics.checkNotNullParameter((Object)$this$withSecond, (String)"<this>");
        return new LocalTime($this$withSecond.getHour(), $this$withSecond.getMinute(), second, $this$withSecond.getNanosecond());
    }

    @NotNull
    public static final LocalTime withNanosecond(@NotNull LocalTime $this$withNanosecond, int nanosecond) {
        Intrinsics.checkNotNullParameter((Object)$this$withNanosecond, (String)"<this>");
        return new LocalTime($this$withNanosecond.getHour(), $this$withNanosecond.getMinute(), $this$withNanosecond.getSecond(), nanosecond);
    }

    @NotNull
    public static final LocalDate withDayOfMonth(@NotNull LocalDate $this$withDayOfMonth, int dayOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$withDayOfMonth, (String)"<this>");
        return new LocalDate($this$withDayOfMonth.getYear(), $this$withDayOfMonth.getMonth(), dayOfMonth);
    }

    @NotNull
    public static final LocalTime getMin(@NotNull LocalTime.Companion $this$Min) {
        Intrinsics.checkNotNullParameter((Object)$this$Min, (String)"<this>");
        return minTime;
    }

    @NotNull
    public static final LocalTime getMax(@NotNull LocalTime.Companion $this$Max) {
        Intrinsics.checkNotNullParameter((Object)$this$Max, (String)"<this>");
        return maxTime;
    }
}

