/*
 * Decompiled with CFR 0.152.
 */
package com.vanpra.composematerialdialogs.datetime.util;

import androidx.compose.ui.geometry.OffsetKt;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\u001c\u0010\u0019\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e*\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\f\u0010\u001b\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u001c\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u001d\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0018\u0010\b\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"isAM", "", "Ljava/time/LocalTime;", "(Ljava/time/LocalTime;)Z", "simpleHour", "", "getSimpleHour", "(Ljava/time/LocalTime;)I", "yearMonth", "Ljava/time/YearMonth;", "Ljava/time/LocalDate;", "getYearMonth", "(Ljava/time/LocalDate;)Ljava/time/YearMonth;", "getFullLocalName", "", "kotlin.jvm.PlatformType", "Ljava/time/Month;", "locale", "Ljava/util/Locale;", "getOffset", "Landroidx/compose/ui/geometry/Offset;", "", "angle", "", "(FD)J", "getShortLocalName", "Ljava/time/DayOfWeek;", "noSeconds", "toAM", "toPM", "datetime"})
public final class ExtensionsKt {
    public static final long getOffset(float $this$getOffset, double angle) {
        return OffsetKt.Offset((float)((float)((double)$this$getOffset * Math.cos(angle))), (float)((float)((double)$this$getOffset * Math.sin(angle))));
    }

    @NotNull
    public static final YearMonth getYearMonth(@NotNull LocalDate $this$yearMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$yearMonth, (String)"<this>");
        YearMonth yearMonth = YearMonth.of($this$yearMonth.getYear(), $this$yearMonth.getMonth());
        Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"of(this.year, this.month)");
        return yearMonth;
    }

    public static final boolean isAM(@NotNull LocalTime $this$isAM) {
        Intrinsics.checkNotNullParameter((Object)$this$isAM, (String)"<this>");
        int n = $this$isAM.getHour();
        return 0 <= n ? n < 12 : false;
    }

    public static final int getSimpleHour(@NotNull LocalTime $this$simpleHour) {
        Intrinsics.checkNotNullParameter((Object)$this$simpleHour, (String)"<this>");
        int tempHour = $this$simpleHour.getHour() % 12;
        return tempHour == 0 ? 12 : tempHour;
    }

    @NotNull
    public static final String getShortLocalName(@NotNull Month $this$getShortLocalName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$getShortLocalName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = $this$getShortLocalName.getDisplayName(TextStyle.SHORT, locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.getDisplayName(java\u2026.TextStyle.SHORT, locale)");
        return string;
    }

    public static final String getFullLocalName(@NotNull Month $this$getFullLocalName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullLocalName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return $this$getFullLocalName.getDisplayName(TextStyle.FULL, locale);
    }

    public static final String getShortLocalName(@NotNull DayOfWeek $this$getShortLocalName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$getShortLocalName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return $this$getShortLocalName.getDisplayName(TextStyle.SHORT, locale);
    }

    @NotNull
    public static final LocalTime toAM(@NotNull LocalTime $this$toAM) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)$this$toAM, (String)"<this>");
        if (ExtensionsKt.isAM($this$toAM)) {
            localTime = $this$toAM;
        } else {
            LocalTime localTime2 = $this$toAM.minusHours(12L);
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"this.minusHours(12)");
            localTime = localTime2;
        }
        return localTime;
    }

    @NotNull
    public static final LocalTime toPM(@NotNull LocalTime $this$toPM) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)$this$toPM, (String)"<this>");
        if (!ExtensionsKt.isAM($this$toPM)) {
            localTime = $this$toPM;
        } else {
            LocalTime localTime2 = $this$toPM.plusHours(12L);
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"this.plusHours(12)");
            localTime = localTime2;
        }
        return localTime;
    }

    @NotNull
    public static final LocalTime noSeconds(@NotNull LocalTime $this$noSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$noSeconds, (String)"<this>");
        LocalTime localTime = LocalTime.of($this$noSeconds.getHour(), $this$noSeconds.getMinute());
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"of(this.hour, this.minute)");
        return localTime;
    }
}

