/*
 * Decompiled with CFR 0.152.
 */
package org.drinkless.tdlib.example;

import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drinkless.tdlib.Client;
import org.drinkless.tdlib.TdApi;

public final class Example {
    private static Client client = null;
    private static TdApi.AuthorizationState authorizationState = null;
    private static volatile boolean haveAuthorization = false;
    private static volatile boolean needQuit = false;
    private static volatile boolean canQuit = false;
    private static final Client.ResultHandler defaultHandler = new DefaultHandler();
    private static final Lock authorizationLock = new ReentrantLock();
    private static final Condition gotAuthorization = authorizationLock.newCondition();
    private static final ConcurrentMap<Long, TdApi.User> users = new ConcurrentHashMap<Long, TdApi.User>();
    private static final ConcurrentMap<Long, TdApi.BasicGroup> basicGroups = new ConcurrentHashMap<Long, TdApi.BasicGroup>();
    private static final ConcurrentMap<Long, TdApi.Supergroup> supergroups = new ConcurrentHashMap<Long, TdApi.Supergroup>();
    private static final ConcurrentMap<Integer, TdApi.SecretChat> secretChats = new ConcurrentHashMap<Integer, TdApi.SecretChat>();
    private static final ConcurrentMap<Long, TdApi.Chat> chats = new ConcurrentHashMap<Long, TdApi.Chat>();
    private static final NavigableSet<OrderedChat> mainChatList = new TreeSet<OrderedChat>();
    private static boolean haveFullMainChatList = false;
    private static final ConcurrentMap<Long, TdApi.UserFullInfo> usersFullInfo = new ConcurrentHashMap<Long, TdApi.UserFullInfo>();
    private static final ConcurrentMap<Long, TdApi.BasicGroupFullInfo> basicGroupsFullInfo = new ConcurrentHashMap<Long, TdApi.BasicGroupFullInfo>();
    private static final ConcurrentMap<Long, TdApi.SupergroupFullInfo> supergroupsFullInfo = new ConcurrentHashMap<Long, TdApi.SupergroupFullInfo>();
    private static final String newLine = System.getProperty("line.separator");
    private static final String commandsLine = "Enter command (gcs - GetChats, gc <chatId> - GetChat, me - GetMe, sm <chatId> <message> - SendMessage, lo - LogOut, q - Quit): ";
    private static volatile String currentPrompt = null;

    private static void print(String str) {
        if (currentPrompt != null) {
            System.out.println("");
        }
        System.out.println(str);
        if (currentPrompt != null) {
            System.out.print(currentPrompt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setChatPositions(TdApi.Chat chat, TdApi.ChatPosition[] positions) {
        NavigableSet<OrderedChat> navigableSet = mainChatList;
        synchronized (navigableSet) {
            TdApi.Chat chat2 = chat;
            synchronized (chat2) {
                for (TdApi.ChatPosition position : chat.positions) {
                    if (position.list.getConstructor() != -400991316) continue;
                    boolean isRemoved = mainChatList.remove(new OrderedChat(chat.id, position));
                    assert (isRemoved);
                }
                for (TdApi.ChatPosition position : chat.positions = positions) {
                    if (position.list.getConstructor() != -400991316) continue;
                    boolean isAdded = mainChatList.add(new OrderedChat(chat.id, position));
                    assert (isAdded);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onAuthorizationStateUpdated(TdApi.AuthorizationState authorizationState) {
        if (authorizationState != null) {
            Example.authorizationState = authorizationState;
        }
        switch (Example.authorizationState.getConstructor()) {
            case 904720988: {
                TdApi.TdlibParameters parameters = new TdApi.TdlibParameters();
                parameters.databaseDirectory = "tdlib";
                parameters.useMessageDatabase = true;
                parameters.useSecretChats = true;
                parameters.apiId = 94575;
                parameters.apiHash = "a3406de8d171bb422bb6ddf3bbd800e2";
                parameters.systemLanguageCode = "en";
                parameters.deviceModel = "Desktop";
                parameters.applicationVersion = "1.0";
                parameters.enableStorageOptimizer = true;
                client.send(new TdApi.SetTdlibParameters(parameters), new AuthorizationRequestHandler());
                break;
            }
            case 612103496: {
                client.send(new TdApi.CheckDatabaseEncryptionKey(), new AuthorizationRequestHandler());
                break;
            }
            case 306402531: {
                String phoneNumber = Example.promptString("Please enter phone number: ");
                client.send(new TdApi.SetAuthenticationPhoneNumber(phoneNumber, null), new AuthorizationRequestHandler());
                break;
            }
            case 860166378: {
                String link = ((TdApi.AuthorizationStateWaitOtherDeviceConfirmation)Example.authorizationState).link;
                System.out.println("Please confirm this login link on another device: " + link);
                break;
            }
            case 52643073: {
                String code = Example.promptString("Please enter authentication code: ");
                client.send(new TdApi.CheckAuthenticationCode(code), new AuthorizationRequestHandler());
                break;
            }
            case 550350511: {
                String firstName = Example.promptString("Please enter your first name: ");
                String lastName = Example.promptString("Please enter your last name: ");
                client.send(new TdApi.RegisterUser(firstName, lastName), new AuthorizationRequestHandler());
                break;
            }
            case 187548796: {
                String password = Example.promptString("Please enter password: ");
                client.send(new TdApi.CheckAuthenticationPassword(password), new AuthorizationRequestHandler());
                break;
            }
            case -1834871737: {
                haveAuthorization = true;
                authorizationLock.lock();
                try {
                    gotAuthorization.signal();
                    break;
                }
                finally {
                    authorizationLock.unlock();
                }
            }
            case 154449270: {
                haveAuthorization = false;
                Example.print("Logging out");
                break;
            }
            case 445855311: {
                haveAuthorization = false;
                Example.print("Closing");
                break;
            }
            case 1526047584: {
                Example.print("Closed");
                if (!needQuit) {
                    client = Client.create(new UpdateHandler(), null, null);
                    break;
                }
                canQuit = true;
                break;
            }
            default: {
                System.err.println("Unsupported authorization state:" + newLine + Example.authorizationState);
            }
        }
    }

    private static int toInt(String arg) {
        int result = 0;
        try {
            result = Integer.parseInt(arg);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private static long getChatId(String arg) {
        long chatId = 0L;
        try {
            chatId = Long.parseLong(arg);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return chatId;
    }

    private static String promptString(String prompt) {
        System.out.print(prompt);
        currentPrompt = prompt;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String str = "";
        try {
            str = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        currentPrompt = null;
        return str;
    }

    private static void getCommand() {
        String command = Example.promptString(commandsLine);
        String[] commands = command.split(" ", 2);
        try {
            switch (commands[0]) {
                case "gcs": {
                    int limit = 20;
                    if (commands.length > 1) {
                        limit = Example.toInt(commands[1]);
                    }
                    Example.getMainChatList(limit);
                    break;
                }
                case "gc": {
                    client.send(new TdApi.GetChat(Example.getChatId(commands[1])), defaultHandler);
                    break;
                }
                case "me": {
                    client.send(new TdApi.GetMe(), defaultHandler);
                    break;
                }
                case "sm": {
                    String[] args = commands[1].split(" ", 2);
                    Example.sendMessage(Example.getChatId(args[0]), args[1]);
                    break;
                }
                case "lo": {
                    haveAuthorization = false;
                    client.send(new TdApi.LogOut(), defaultHandler);
                    break;
                }
                case "q": {
                    needQuit = true;
                    haveAuthorization = false;
                    client.send(new TdApi.Close(), defaultHandler);
                    break;
                }
                default: {
                    System.err.println("Unsupported command: " + command);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Example.print("Not enough arguments");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getMainChatList(final int limit) {
        NavigableSet<OrderedChat> navigableSet = mainChatList;
        synchronized (navigableSet) {
            if (!haveFullMainChatList && limit > mainChatList.size()) {
                client.send(new TdApi.LoadChats(new TdApi.ChatListMain(), limit - mainChatList.size()), new Client.ResultHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResult(TdApi.Object object) {
                        switch (object.getConstructor()) {
                            case -1679978726: {
                                if (((TdApi.Error)object).code == 404) {
                                    NavigableSet navigableSet = mainChatList;
                                    synchronized (navigableSet) {
                                        haveFullMainChatList = true;
                                        break;
                                    }
                                }
                                System.err.println("Receive an error for LoadChats:" + newLine + object);
                                break;
                            }
                            case -722616727: {
                                Example.getMainChatList(limit);
                                break;
                            }
                            default: {
                                System.err.println("Receive wrong response from TDLib:" + newLine + object);
                            }
                        }
                    }
                });
                return;
            }
            Iterator<OrderedChat> iter = mainChatList.iterator();
            System.out.println();
            System.out.println("First " + limit + " chat(s) out of " + mainChatList.size() + " known chat(s):");
            for (int i = 0; i < limit && i < mainChatList.size(); ++i) {
                TdApi.Chat chat;
                long chatId = iter.next().chatId;
                TdApi.Chat chat2 = chat = (TdApi.Chat)chats.get(chatId);
                synchronized (chat2) {
                    System.out.println(chatId + ": " + chat.title);
                    continue;
                }
            }
            Example.print("");
        }
    }

    private static void sendMessage(long chatId, String message) {
        TdApi.InlineKeyboardButton[] row = new TdApi.InlineKeyboardButton[]{new TdApi.InlineKeyboardButton("https://telegram.org?1", new TdApi.InlineKeyboardButtonTypeUrl()), new TdApi.InlineKeyboardButton("https://telegram.org?2", new TdApi.InlineKeyboardButtonTypeUrl()), new TdApi.InlineKeyboardButton("https://telegram.org?3", new TdApi.InlineKeyboardButtonTypeUrl())};
        TdApi.ReplyMarkupInlineKeyboard replyMarkup = new TdApi.ReplyMarkupInlineKeyboard(new TdApi.InlineKeyboardButton[][]{row, row, row});
        TdApi.InputMessageText content = new TdApi.InputMessageText(new TdApi.FormattedText(message, null), false, true);
        client.send(new TdApi.SendMessage(chatId, 0L, 0L, null, replyMarkup, content), defaultHandler);
    }

    public static void main(String[] args) throws InterruptedException {
        Client.execute(new TdApi.SetLogVerbosityLevel(0));
        if (Client.execute(new TdApi.SetLogStream(new TdApi.LogStreamFile("tdlib.log", 0x8000000L, false))) instanceof TdApi.Error) {
            throw new IOError(new IOException("Write access to the current directory is required"));
        }
        client = Client.create(new UpdateHandler(), null, null);
        defaultHandler.onResult(Client.execute(new TdApi.GetTextEntities("@telegram /test_command https://telegram.org telegram.me @gif @test")));
        while (!needQuit) {
            authorizationLock.lock();
            try {
                while (!haveAuthorization) {
                    gotAuthorization.await();
                }
            }
            finally {
                authorizationLock.unlock();
            }
            while (haveAuthorization) {
                Example.getCommand();
            }
        }
        while (!canQuit) {
            Thread.sleep(1L);
        }
    }

    static {
        try {
            System.loadLibrary("tdjni");
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
    }

    private static class AuthorizationRequestHandler
    implements Client.ResultHandler {
        private AuthorizationRequestHandler() {
        }

        @Override
        public void onResult(TdApi.Object object) {
            switch (object.getConstructor()) {
                case -1679978726: {
                    System.err.println("Receive an error:" + newLine + object);
                    Example.onAuthorizationStateUpdated(null);
                    break;
                }
                case -722616727: {
                    break;
                }
                default: {
                    System.err.println("Receive wrong response from TDLib:" + newLine + object);
                }
            }
        }
    }

    private static class UpdateHandler
    implements Client.ResultHandler {
        private UpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(TdApi.Object object) {
            switch (object.getConstructor()) {
                case 1622347490: {
                    Example.onAuthorizationStateUpdated(((TdApi.UpdateAuthorizationState)object).authorizationState);
                    break;
                }
                case 1183394041: {
                    TdApi.UpdateUser updateUser = (TdApi.UpdateUser)object;
                    users.put(updateUser.user.id, updateUser.user);
                    break;
                }
                case 958468625: {
                    TdApi.User user;
                    TdApi.UpdateUserStatus updateUserStatus = (TdApi.UpdateUserStatus)object;
                    TdApi.User user2 = user = (TdApi.User)users.get(updateUserStatus.userId);
                    synchronized (user2) {
                        user.status = updateUserStatus.status;
                        break;
                    }
                }
                case -1003239581: {
                    TdApi.UpdateBasicGroup updateBasicGroup = (TdApi.UpdateBasicGroup)object;
                    basicGroups.put(updateBasicGroup.basicGroup.id, updateBasicGroup.basicGroup);
                    break;
                }
                case -76782300: {
                    TdApi.UpdateSupergroup updateSupergroup = (TdApi.UpdateSupergroup)object;
                    supergroups.put(updateSupergroup.supergroup.id, updateSupergroup.supergroup);
                    break;
                }
                case -1666903253: {
                    TdApi.UpdateSecretChat updateSecretChat = (TdApi.UpdateSecretChat)object;
                    secretChats.put(updateSecretChat.secretChat.id, updateSecretChat.secretChat);
                    break;
                }
                case 2075757773: {
                    TdApi.Chat chat;
                    TdApi.UpdateNewChat updateNewChat = (TdApi.UpdateNewChat)object;
                    TdApi.Chat chat2 = chat = updateNewChat.chat;
                    synchronized (chat2) {
                        chats.put(chat.id, chat);
                        TdApi.ChatPosition[] positions = chat.positions;
                        chat.positions = new TdApi.ChatPosition[0];
                        Example.setChatPositions(chat, positions);
                        break;
                    }
                }
                case -175405660: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatTitle updateChat = (TdApi.UpdateChatTitle)object;
                    TdApi.Chat chat3 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat3) {
                        chat.title = updateChat.title;
                        break;
                    }
                }
                case -324713921: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatPhoto updateChat = (TdApi.UpdateChatPhoto)object;
                    TdApi.Chat chat4 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat4) {
                        chat.photo = updateChat.photo;
                        break;
                    }
                }
                case -923244537: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatLastMessage updateChat = (TdApi.UpdateChatLastMessage)object;
                    TdApi.Chat chat5 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat5) {
                        chat.lastMessage = updateChat.lastMessage;
                        Example.setChatPositions(chat, updateChat.positions);
                        break;
                    }
                }
                case -8979849: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatPosition updateChat = (TdApi.UpdateChatPosition)object;
                    if (updateChat.position.list.getConstructor() != -400991316) break;
                    TdApi.Chat chat6 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat6) {
                        int i;
                        for (i = 0; i < chat.positions.length && chat.positions[i].list.getConstructor() != -400991316; ++i) {
                        }
                        TdApi.ChatPosition[] new_positions = new TdApi.ChatPosition[chat.positions.length + (updateChat.position.order == 0L ? 0 : 1) - (i < chat.positions.length ? 1 : 0)];
                        int pos = 0;
                        if (updateChat.position.order != 0L) {
                            new_positions[pos++] = updateChat.position;
                        }
                        for (int j = 0; j < chat.positions.length; ++j) {
                            if (j == i) continue;
                            new_positions[pos++] = chat.positions[j];
                        }
                        assert (pos == new_positions.length);
                        Example.setChatPositions(chat, new_positions);
                        break;
                    }
                }
                case -797952281: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatReadInbox updateChat = (TdApi.UpdateChatReadInbox)object;
                    TdApi.Chat chat7 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat7) {
                        chat.lastReadInboxMessageId = updateChat.lastReadInboxMessageId;
                        chat.unreadCount = updateChat.unreadCount;
                        break;
                    }
                }
                case 708334213: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatReadOutbox updateChat = (TdApi.UpdateChatReadOutbox)object;
                    TdApi.Chat chat8 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat8) {
                        chat.lastReadOutboxMessageId = updateChat.lastReadOutboxMessageId;
                        break;
                    }
                }
                case -2131461348: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatUnreadMentionCount updateChat = (TdApi.UpdateChatUnreadMentionCount)object;
                    TdApi.Chat chat9 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat9) {
                        chat.unreadMentionCount = updateChat.unreadMentionCount;
                        break;
                    }
                }
                case -252228282: {
                    TdApi.Chat chat;
                    TdApi.UpdateMessageMentionRead updateChat = (TdApi.UpdateMessageMentionRead)object;
                    TdApi.Chat chat10 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat10) {
                        chat.unreadMentionCount = updateChat.unreadMentionCount;
                        break;
                    }
                }
                case 1309386144: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatReplyMarkup updateChat = (TdApi.UpdateChatReplyMarkup)object;
                    TdApi.Chat chat11 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat11) {
                        chat.replyMarkupMessageId = updateChat.replyMarkupMessageId;
                        break;
                    }
                }
                case 1455190380: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatDraftMessage updateChat = (TdApi.UpdateChatDraftMessage)object;
                    TdApi.Chat chat12 = chat = (TdApi.Chat)chats.get(updateChat.chatId);
                    synchronized (chat12) {
                        chat.draftMessage = updateChat.draftMessage;
                        Example.setChatPositions(chat, updateChat.positions);
                        break;
                    }
                }
                case -1622010003: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatPermissions update = (TdApi.UpdateChatPermissions)object;
                    TdApi.Chat chat13 = chat = (TdApi.Chat)chats.get(update.chatId);
                    synchronized (chat13) {
                        chat.permissions = update.permissions;
                        break;
                    }
                }
                case -803163050: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatNotificationSettings update = (TdApi.UpdateChatNotificationSettings)object;
                    TdApi.Chat chat14 = chat = (TdApi.Chat)chats.get(update.chatId);
                    synchronized (chat14) {
                        chat.notificationSettings = update.notificationSettings;
                        break;
                    }
                }
                case 464087707: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatDefaultDisableNotification update = (TdApi.UpdateChatDefaultDisableNotification)object;
                    TdApi.Chat chat15 = chat = (TdApi.Chat)chats.get(update.chatId);
                    synchronized (chat15) {
                        chat.defaultDisableNotification = update.defaultDisableNotification;
                        break;
                    }
                }
                case 1468347188: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatIsMarkedAsUnread update = (TdApi.UpdateChatIsMarkedAsUnread)object;
                    TdApi.Chat chat16 = chat = (TdApi.Chat)chats.get(update.chatId);
                    synchronized (chat16) {
                        chat.isMarkedAsUnread = update.isMarkedAsUnread;
                        break;
                    }
                }
                case -1998946752: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatIsBlocked update = (TdApi.UpdateChatIsBlocked)object;
                    TdApi.Chat chat17 = chat = (TdApi.Chat)chats.get(update.chatId);
                    synchronized (chat17) {
                        chat.isBlocked = update.isBlocked;
                        break;
                    }
                }
                case 2064958167: {
                    TdApi.Chat chat;
                    TdApi.UpdateChatHasScheduledMessages update = (TdApi.UpdateChatHasScheduledMessages)object;
                    TdApi.Chat chat18 = chat = (TdApi.Chat)chats.get(update.chatId);
                    synchronized (chat18) {
                        chat.hasScheduledMessages = update.hasScheduledMessages;
                        break;
                    }
                }
                case -51197161: {
                    TdApi.UpdateUserFullInfo updateUserFullInfo = (TdApi.UpdateUserFullInfo)object;
                    usersFullInfo.put(updateUserFullInfo.userId, updateUserFullInfo.userFullInfo);
                    break;
                }
                case 1391881151: {
                    TdApi.UpdateBasicGroupFullInfo updateBasicGroupFullInfo = (TdApi.UpdateBasicGroupFullInfo)object;
                    basicGroupsFullInfo.put(updateBasicGroupFullInfo.basicGroupId, updateBasicGroupFullInfo.basicGroupFullInfo);
                    break;
                }
                case 435539214: {
                    TdApi.UpdateSupergroupFullInfo updateSupergroupFullInfo = (TdApi.UpdateSupergroupFullInfo)object;
                    supergroupsFullInfo.put(updateSupergroupFullInfo.supergroupId, updateSupergroupFullInfo.supergroupFullInfo);
                    break;
                }
            }
        }
    }

    private static class DefaultHandler
    implements Client.ResultHandler {
        private DefaultHandler() {
        }

        @Override
        public void onResult(TdApi.Object object) {
            Example.print(object.toString());
        }
    }

    private static class OrderedChat
    implements Comparable<OrderedChat> {
        final long chatId;
        final TdApi.ChatPosition position;

        OrderedChat(long chatId, TdApi.ChatPosition position) {
            this.chatId = chatId;
            this.position = position;
        }

        @Override
        public int compareTo(OrderedChat o) {
            if (this.position.order != o.position.order) {
                return o.position.order < this.position.order ? -1 : 1;
            }
            if (this.chatId != o.chatId) {
                return o.chatId < this.chatId ? -1 : 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            OrderedChat o = (OrderedChat)obj;
            return this.chatId == o.chatId && this.position.order == o.position.order;
        }
    }
}

