/*
 * Decompiled with CFR 0.152.
 */
package org.drinkless.tdlib;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.drinkless.tdlib.TdApi;

public final class Client {
    private final int nativeClientId;
    private static final ConcurrentHashMap<Integer, ExceptionHandler> defaultExceptionHandlers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, Handler> updateHandlers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, Handler> handlers = new ConcurrentHashMap();
    private static final AtomicLong currentQueryId = new AtomicLong();
    private static final AtomicLong clientCount = new AtomicLong();
    private static final ResponseReceiver responseReceiver = new ResponseReceiver();

    public void send(TdApi.Function query, ResultHandler resultHandler, ExceptionHandler exceptionHandler) {
        long queryId = currentQueryId.incrementAndGet();
        if (resultHandler != null) {
            handlers.put(queryId, new Handler(resultHandler, exceptionHandler));
        }
        Client.nativeClientSend(this.nativeClientId, queryId, query);
    }

    public void send(TdApi.Function query, ResultHandler resultHandler) {
        this.send(query, resultHandler, null);
    }

    public static TdApi.Object execute(TdApi.Function query) {
        return Client.nativeClientExecute(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Client create(ResultHandler updateHandler, ExceptionHandler updateExceptionHandler, ExceptionHandler defaultExceptionHandler) {
        Client client = new Client(updateHandler, updateExceptionHandler, defaultExceptionHandler);
        ResponseReceiver responseReceiver = Client.responseReceiver;
        synchronized (responseReceiver) {
            if (!Client.responseReceiver.isRun) {
                Client.responseReceiver.isRun = true;
                Thread receiverThread = new Thread((Runnable)Client.responseReceiver, "TDLib thread");
                receiverThread.setDaemon(true);
                receiverThread.start();
            }
        }
        return client;
    }

    private Client(ResultHandler updateHandler, ExceptionHandler updateExceptionHandler, ExceptionHandler defaultExceptionHandler) {
        clientCount.incrementAndGet();
        this.nativeClientId = Client.createNativeClient();
        if (updateHandler != null) {
            updateHandlers.put(this.nativeClientId, new Handler(updateHandler, updateExceptionHandler));
        }
        if (defaultExceptionHandler != null) {
            defaultExceptionHandlers.put(this.nativeClientId, defaultExceptionHandler);
        }
        this.send(new TdApi.GetOption("version"), null, null);
    }

    protected void finalize() throws Throwable {
        this.send(new TdApi.Close(), null, null);
    }

    private static native int createNativeClient();

    private static native void nativeClientSend(int var0, long var1, TdApi.Function var3);

    private static native int nativeClientReceive(int[] var0, long[] var1, TdApi.Object[] var2, double var3);

    private static native TdApi.Object nativeClientExecute(TdApi.Function var0);

    private static class Handler {
        final ResultHandler resultHandler;
        final ExceptionHandler exceptionHandler;

        Handler(ResultHandler resultHandler, ExceptionHandler exceptionHandler) {
            this.resultHandler = resultHandler;
            this.exceptionHandler = exceptionHandler;
        }
    }

    private static class ResponseReceiver
    implements Runnable {
        public boolean isRun = false;
        private static final int MAX_EVENTS = 1000;
        private final int[] clientIds = new int[1000];
        private final long[] eventIds = new long[1000];
        private final TdApi.Object[] events = new TdApi.Object[1000];

        private ResponseReceiver() {
        }

        @Override
        public void run() {
            block0: while (true) {
                int resultN = Client.nativeClientReceive(this.clientIds, this.eventIds, this.events, 100000.0);
                int i = 0;
                while (true) {
                    if (i >= resultN) continue block0;
                    this.processResult(this.clientIds[i], this.eventIds[i], this.events[i]);
                    this.events[i] = null;
                    ++i;
                }
                break;
            }
        }

        private void processResult(int clientId, long id, TdApi.Object object) {
            boolean isClosed;
            block8: {
                Handler handler;
                TdApi.AuthorizationState authorizationState;
                isClosed = false;
                if (id == 0L && object instanceof TdApi.UpdateAuthorizationState && (authorizationState = ((TdApi.UpdateAuthorizationState)object).authorizationState) instanceof TdApi.AuthorizationStateClosed) {
                    isClosed = true;
                }
                Handler handler2 = handler = id == 0L ? (Handler)updateHandlers.get(clientId) : (Handler)handlers.remove(id);
                if (handler != null) {
                    try {
                        handler.resultHandler.onResult(object);
                    }
                    catch (Throwable cause) {
                        ExceptionHandler exceptionHandler = handler.exceptionHandler;
                        if (exceptionHandler == null) {
                            exceptionHandler = (ExceptionHandler)defaultExceptionHandlers.get(clientId);
                        }
                        if (exceptionHandler == null) break block8;
                        try {
                            exceptionHandler.onException(cause);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            if (isClosed) {
                updateHandlers.remove(clientId);
                defaultExceptionHandlers.remove(clientId);
                clientCount.decrementAndGet();
            }
        }
    }

    public static interface ExceptionHandler {
        public void onException(Throwable var1);
    }

    public static interface ResultHandler {
        public void onResult(TdApi.Object var1);
    }
}

