/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.linea.blob;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.consensys.linea.blob.Adapter;
import net.consensys.linea.blob.BlobDecompressor;
import net.consensys.linea.blob.DecompressionException;
import net.consensys.linea.blob.GoNativeBlobDecompressorJnaBinding;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/consensys/linea/blob/Adapter;", "Lnet/consensys/linea/blob/BlobDecompressor;", "delegate", "Lnet/consensys/linea/blob/GoNativeBlobDecompressorJnaBinding;", "maxExpectedCompressionRatio", "", "dictionaries", "", "Ljava/nio/file/Path;", "(Lnet/consensys/linea/blob/GoNativeBlobDecompressorJnaBinding;ILjava/util/List;)V", "decompress", "", "blob", "blob-decompressor"})
public final class Adapter
implements BlobDecompressor {
    @NotNull
    private final GoNativeBlobDecompressorJnaBinding delegate;
    private final int maxExpectedCompressionRatio;

    public Adapter(@NotNull GoNativeBlobDecompressorJnaBinding delegate, int maxExpectedCompressionRatio, @NotNull List<? extends Path> dictionaries) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(dictionaries, (String)"dictionaries");
        this.delegate = delegate;
        this.maxExpectedCompressionRatio = maxExpectedCompressionRatio;
        this.delegate.Init();
        String paths2 = CollectionsKt.joinToString$default((Iterable)dictionaries, (CharSequence)":", null, null, (int)0, null, (Function1)paths.1.INSTANCE, (int)30, null);
        if (this.delegate.LoadDictionaries(paths2) != dictionaries.size()) {
            throw new DecompressionException("Failed to load dictionaries '" + paths2 + "', error='" + this.delegate.Error() + "'");
        }
    }

    public /* synthetic */ Adapter(GoNativeBlobDecompressorJnaBinding goNativeBlobDecompressorJnaBinding, int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        this(goNativeBlobDecompressorJnaBinding, n, list);
    }

    @Override
    @NotNull
    public byte[] decompress(@NotNull byte[] blob) {
        Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
        byte[] decompressionBuffer = new byte[blob.length * this.maxExpectedCompressionRatio];
        int decompressedSize = this.delegate.Decompress(blob, blob.length, decompressionBuffer, decompressionBuffer.length);
        if (decompressedSize < 0) {
            throw new DecompressionException("Decompression failed, error='" + this.delegate.Error() + "'");
        }
        byte[] byArray = Arrays.copyOf(decompressionBuffer, decompressedSize);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }
}

