/*
 * Decompiled with CFR 0.152.
 */
package linea.blob;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import linea.blob.BlobCompressionException;
import linea.blob.BlobCompressor;
import linea.kotlin.ByteArrayExtensionsKt;
import net.consensys.linea.blob.BlobCompressorVersion;
import net.consensys.linea.blob.GoNativeBlobCompressor;
import net.consensys.linea.blob.GoNativeBlobCompressorFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llinea/blob/GoBackedBlobCompressor;", "Llinea/blob/BlobCompressor;", "goNativeBlobCompressor", "Lnet/consensys/linea/blob/GoNativeBlobCompressor;", "(Lnet/consensys/linea/blob/GoNativeBlobCompressor;)V", "getGoNativeBlobCompressor$blob_compressor", "()Lnet/consensys/linea/blob/GoNativeBlobCompressor;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "appendBlock", "Llinea/blob/BlobCompressor$AppendResult;", "blockRLPEncoded", "", "canAppendBlock", "", "getCompressedData", "inflightBlobSize", "", "reset", "", "startNewBatch", "Companion", "blob-compressor"})
public final class GoBackedBlobCompressor
implements BlobCompressor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoNativeBlobCompressor goNativeBlobCompressor;
    private final Logger log;
    @Nullable
    private static volatile GoBackedBlobCompressor instance;

    private GoBackedBlobCompressor(GoNativeBlobCompressor goNativeBlobCompressor) {
        this.goNativeBlobCompressor = goNativeBlobCompressor;
        this.log = LogManager.getLogger(GoBackedBlobCompressor.class);
    }

    @NotNull
    public final GoNativeBlobCompressor getGoNativeBlobCompressor$blob_compressor() {
        return this.goNativeBlobCompressor;
    }

    @Override
    public boolean canAppendBlock(@NotNull byte[] blockRLPEncoded) {
        Intrinsics.checkNotNullParameter((Object)blockRLPEncoded, (String)"blockRLPEncoded");
        return this.goNativeBlobCompressor.CanWrite(blockRLPEncoded, blockRLPEncoded.length);
    }

    public final int inflightBlobSize() {
        return this.goNativeBlobCompressor.Len();
    }

    @Override
    @NotNull
    public BlobCompressor.AppendResult appendBlock(@NotNull byte[] blockRLPEncoded) {
        Intrinsics.checkNotNullParameter((Object)blockRLPEncoded, (String)"blockRLPEncoded");
        int compressionSizeBefore = this.goNativeBlobCompressor.Len();
        boolean appended = this.goNativeBlobCompressor.Write(blockRLPEncoded, blockRLPEncoded.length);
        int compressedSizeAfter = this.goNativeBlobCompressor.Len();
        this.log.trace("block compressed: blockRlpSize={} compressionDataBefore={} compressionDataAfter={} compressionRatio={}", (Object)blockRLPEncoded.length, (Object)compressionSizeBefore, (Object)compressedSizeAfter, (Object)(1.0 - (double)(compressedSizeAfter - compressionSizeBefore) / (double)blockRLPEncoded.length));
        String error = this.goNativeBlobCompressor.Error();
        if (error != null) {
            this.log.error("Failure while writing the following RLP encoded block: {}", (Object)ByteArrayExtensionsKt.encodeHex$default((byte[])blockRLPEncoded, (boolean)false, (int)1, null));
            throw new BlobCompressionException(error);
        }
        return new BlobCompressor.AppendResult(appended, compressionSizeBefore, compressedSizeAfter);
    }

    @Override
    public void startNewBatch() {
        this.goNativeBlobCompressor.StartNewBatch();
    }

    @Override
    @NotNull
    public byte[] getCompressedData() {
        byte[] compressedData = new byte[this.goNativeBlobCompressor.Len()];
        this.goNativeBlobCompressor.Bytes(compressedData);
        return compressedData;
    }

    @Override
    public void reset() {
        this.goNativeBlobCompressor.Reset();
    }

    @Override
    @NotNull
    public byte[] getCompressedDataAndReset() {
        return BlobCompressor.DefaultImpls.getCompressedDataAndReset(this);
    }

    public /* synthetic */ GoBackedBlobCompressor(GoNativeBlobCompressor goNativeBlobCompressor, DefaultConstructorMarker $constructor_marker) {
        this(goNativeBlobCompressor);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\f"}, d2={"Llinea/blob/GoBackedBlobCompressor$Companion;", "", "()V", "instance", "Llinea/blob/GoBackedBlobCompressor;", "getInstance", "compressorVersion", "Lnet/consensys/linea/blob/BlobCompressorVersion;", "dataLimit", "Lkotlin/UInt;", "getInstance-Qn1smSk", "(Lnet/consensys/linea/blob/BlobCompressorVersion;I)Llinea/blob/GoBackedBlobCompressor;", "blob-compressor"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final GoBackedBlobCompressor getInstance-Qn1smSk(@NotNull BlobCompressorVersion compressorVersion, int dataLimit) {
            Intrinsics.checkNotNullParameter((Object)((Object)compressorVersion), (String)"compressorVersion");
            if (instance == null) {
                Companion companion = this;
                synchronized (companion) {
                    GoNativeBlobCompressor goNativeBlobCompressor;
                    boolean bl = false;
                    if (instance == null) {
                        goNativeBlobCompressor = GoNativeBlobCompressorFactory.Companion.getInstance(compressorVersion);
                        boolean initialized = goNativeBlobCompressor.Init(dataLimit, ((Object)GoNativeBlobCompressorFactory.Companion.getDictionaryPath()).toString());
                        if (!initialized) {
                            throw new InstantiationException(goNativeBlobCompressor.Error());
                        }
                    } else {
                        throw new IllegalStateException("Compressor singleton instance already created");
                    }
                    instance = new GoBackedBlobCompressor(goNativeBlobCompressor, null);
                    Unit unit = Unit.INSTANCE;
                }
            } else {
                throw new IllegalStateException("Compressor singleton instance already created");
            }
            GoBackedBlobCompressor goBackedBlobCompressor = instance;
            Intrinsics.checkNotNull((Object)goBackedBlobCompressor);
            return goBackedBlobCompressor;
        }

        public static /* synthetic */ GoBackedBlobCompressor getInstance-Qn1smSk$default(Companion companion, BlobCompressorVersion blobCompressorVersion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                blobCompressorVersion = BlobCompressorVersion.V0_1_0;
            }
            return companion.getInstance-Qn1smSk(blobCompressorVersion, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

