/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.linea.nativecompressor;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import linea.kotlin.ByteArrayExtensionsKt;
import linea.kotlin.StringExtensionsKt;
import linea.rlp.RLP;
import net.consensys.linea.testing.filesystem.FilesKt;
import org.hyperledger.besu.ethereum.core.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u0006\u0010\f\u001a\u00020\u0001\u00a8\u0006\r"}, d2={"generateEncodeBlocksToBinaryFromProverRequests", "", "proverExecutionRequestsFolder", "Ljava/nio/file/Path;", "outputFilePath", "loadBlocksFromProverRequests", "", "Lkotlin/Pair;", "Lorg/hyperledger/besu/ethereum/core/Block;", "", "loadBlocksRlpEncoded", "binFile", "main", "blob-compressor_testFixtures"})
@SourceDebugExtension(value={"SMAP\nTestDataGeneratorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestDataGeneratorHelper.kt\nnet/consensys/linea/nativecompressor/TestDataGeneratorHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,2:73\n1549#2:75\n1620#2,3:76\n1622#2:79\n1045#2:80\n1855#2,2:81\n1549#2:83\n1620#2,3:84\n1549#2:87\n1620#2,3:88\n1855#2,2:91\n*S KotlinDebug\n*F\n+ 1 TestDataGeneratorHelper.kt\nnet/consensys/linea/nativecompressor/TestDataGeneratorHelperKt\n*L\n18#1:72\n18#1:73,2\n21#1:75\n21#1:76,3\n18#1:79\n31#1:80\n33#1:81,2\n44#1:83\n44#1:84,3\n66#1:87\n66#1:88,3\n67#1:91,2\n*E\n"})
public final class TestDataGeneratorHelperKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Block, byte[]>> loadBlocksFromProverRequests(@NotNull Path proverExecutionRequestsFolder) {
        List list;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proverExecutionRequestsFolder, (String)"proverExecutionRequestsFolder");
        List<Path> list2 = Files.list(proverExecutionRequestsFolder).toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void file;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsonArray jsonArray = new JsonObject(Files.readString((Path)file)).getJsonArray("blocksData");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getJsonArray(...)");
            Iterable iterable2 = (Iterable)jsonArray;
            boolean $i$f$map2 = false;
            void var13_14 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void block;
                Object item$iv$iv2;
                Object t = item$iv$iv2 = iterator.next();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type io.vertx.core.json.JsonObject");
                JsonObject cfr_ignored_0 = (JsonObject)block;
                String string = ((JsonObject)block).getString("rlp");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                byte[] rlp = StringExtensionsKt.decodeHex((String)string);
                collection2.add(TuplesKt.to((Object)RLP.INSTANCE.decodeBlockWithMainnetFunctions(rlp), (Object)rlp));
            }
            collection.add((List)destination$iv$iv2);
        }
        List blocks = CollectionsKt.flatten((Iterable)CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
        Iterable $this$sortedBy$iv = blocks;
        boolean $i$f$sortedBy = false;
        List it = list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(((Block)it.getFirst()).getHeader().getNumber());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((Block)it.getFirst()).getHeader().getNumber()));
            }
        });
        boolean bl = false;
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it2 = (Pair)element$iv;
            boolean bl3 = false;
            System.out.println((Object)("block=" + ((Block)it2.getFirst()).getHeader() + " rlp=" + ByteArrayExtensionsKt.encodeHex$default((byte[])((byte[])it2.getSecond()), (boolean)false, (int)1, null)));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateEncodeBlocksToBinaryFromProverRequests(@NotNull Path proverExecutionRequestsFolder, @NotNull Path outputFilePath) {
        Collection<byte[]> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)proverExecutionRequestsFolder, (String)"proverExecutionRequestsFolder");
        Intrinsics.checkNotNullParameter((Object)outputFilePath, (String)"outputFilePath");
        List<Pair<Block, byte[]>> blocks = TestDataGeneratorHelperKt.loadBlocksFromProverRequests(proverExecutionRequestsFolder);
        Iterable iterable = blocks;
        RLP rLP = RLP.INSTANCE;
        Path path = outputFilePath;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte[])it.getSecond());
        }
        collection = (List)destination$iv$iv;
        Files.write(path, rLP.encodeList((List)collection), new OpenOption[0]);
    }

    @NotNull
    public static final List<byte[]> loadBlocksRlpEncoded(@NotNull Path binFile) {
        Intrinsics.checkNotNullParameter((Object)binFile, (String)"binFile");
        byte[] byArray = Files.readAllBytes(binFile);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return RLP.INSTANCE.decodeList(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static final void main() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path proverExecutionRequestsDir = FilesKt.getPathTo$default((String)"tmp/local/prover/v3/execution/requests-done/", null, (boolean)false, (int)6, null);
        Path destFile = FilesKt.getPathTo$default((String)"jvm-libs/linea/blob-compressor/src/testFixtures/resources", null, (boolean)false, (int)6, null).resolve("blocks_rlp.bin");
        Intrinsics.checkNotNull((Object)destFile);
        TestDataGeneratorHelperKt.generateEncodeBlocksToBinaryFromProverRequests(proverExecutionRequestsDir, destFile);
        System.out.println((Object)"\n\n");
        Iterable iterable = TestDataGeneratorHelperKt.loadBlocksRlpEncoded(destFile);
        RLP rLP = RLP.INSTANCE;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(rLP.decodeBlockWithMainnetFunctions((byte[])p0));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl = false;
            System.out.println((Object)("block=" + it));
        }
    }

    public static /* synthetic */ void main(String[] args) {
        TestDataGeneratorHelperKt.main();
    }
}

