/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.linea.nativecompressor;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0007R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lnet/consensys/linea/nativecompressor/CompressorTestData;", "", "()V", "blocksRlpEncoded", "", "", "getBlocksRlpEncoded", "()[[B", "[[B", "loadTestData", "blob-compressor_testFixtures"})
public final class CompressorTestData {
    @NotNull
    public static final CompressorTestData INSTANCE = new CompressorTestData();
    @NotNull
    private static final byte[][] blocksRlpEncoded = INSTANCE.loadTestData();

    private CompressorTestData() {
    }

    @NotNull
    public final byte[][] getBlocksRlpEncoded() {
        return blocksRlpEncoded;
    }

    private final byte[][] loadTestData() {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("rlp_blocks.bin");
        Intrinsics.checkNotNull((Object)inputStream);
        byte[] data = inputStream.readAllBytes();
        int numBlocks = ByteBuffer.wrap(data, 0, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        int n = 0;
        int n2 = numBlocks * 2;
        byte[][] byArrayArray = new byte[n2][];
        while (n < n2) {
            int n3 = n++;
            byArrayArray[n3] = new byte[0];
        }
        byte[][] blocks = byArrayArray;
        for (int j = 0; j < 2; ++j) {
            int offset = 4;
            for (int i = 0; i < numBlocks; ++i) {
                int blockLen = ByteBuffer.wrap(data, offset, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                blocks[i + j * numBlocks] = new byte[blockLen];
                System.arraycopy(data, offset + 4, blocks[i + j * numBlocks], 0, blockLen);
                offset += 4 + blockLen;
            }
        }
        return blocks;
    }
}

