/*
 * Decompiled with CFR 0.152.
 */
package com.buildless.telemetry;

import com.buildless.telemetry.EventDetail;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.re2j.Pattern;
import io.envoyproxy.pgv.BytesValidation;
import io.envoyproxy.pgv.EnumValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;

public class EventDetailValidator
implements ValidatorImpl<EventDetail> {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(EventDetail.class)) {
            return new EventDetailValidator();
        }
        if (clazz.equals(EventDetail.TenantDetail.class)) {
            return new EventDetail_TenantDetailValidator();
        }
        if (clazz.equals(EventDetail.UserDetail.class)) {
            return new EventDetail_UserDetailValidator();
        }
        if (clazz.equals(EventDetail.RepositoryDetail.class)) {
            return new EventDetail_RepositoryDetailValidator();
        }
        if (clazz.equals(EventDetail.ClientDetail.class)) {
            return new EventDetail_ClientDetailValidator();
        }
        return null;
    }

    public void assertValid(EventDetail proto, ValidatorIndex index) throws ValidationException {
        if (proto.hasTenant()) {
            index.validatorFor((Object)proto.getTenant()).assertValid((Object)proto.getTenant());
        }
        if (proto.hasUser()) {
            index.validatorFor((Object)proto.getUser()).assertValid((Object)proto.getUser());
        }
        if (proto.hasRepository()) {
            index.validatorFor((Object)proto.getRepository()).assertValid((Object)proto.getRepository());
        }
        if (proto.hasClient()) {
            index.validatorFor((Object)proto.getClient()).assertValid((Object)proto.getClient());
        }
    }

    public static class EventDetail_TenantDetailValidator
    implements ValidatorImpl<EventDetail.TenantDetail> {
        Pattern NAME__PATTERN = Pattern.compile((String)"^[a-zA-Z]{1}[a-zA-Z0-9_-]{2,32}");

        public void assertValid(EventDetail.TenantDetail proto, ValidatorIndex index) throws ValidationException {
            StringValidation.maxLength((String)".buildless.telemetry.EventDetail.TenantDetail.name", (String)proto.getName(), (int)32);
            StringValidation.pattern((String)".buildless.telemetry.EventDetail.TenantDetail.name", (String)proto.getName(), (Pattern)this.NAME__PATTERN);
        }
    }

    public static class EventDetail_UserDetailValidator
    implements ValidatorImpl<EventDetail.UserDetail> {
        public void assertValid(EventDetail.UserDetail proto, ValidatorIndex index) throws ValidationException {
            StringValidation.maxLength((String)".buildless.telemetry.EventDetail.UserDetail.uid", (String)proto.getUid(), (int)128);
            BytesValidation.length((String)".buildless.telemetry.EventDetail.UserDetail.email", (ByteString)proto.getEmail(), (int)32);
            StringValidation.maxLength((String)".buildless.telemetry.EventDetail.UserDetail.username", (String)proto.getUsername(), (int)32);
        }
    }

    public static class EventDetail_RepositoryDetailValidator
    implements ValidatorImpl<EventDetail.RepositoryDetail> {
        public void assertValid(EventDetail.RepositoryDetail proto, ValidatorIndex index) throws ValidationException {
            EnumValidation.definedOnly((String)".buildless.telemetry.EventDetail.RepositoryDetail.provider", (ProtocolMessageEnum)proto.getProvider());
            StringValidation.uri((String)".buildless.telemetry.EventDetail.RepositoryDetail.link", (String)proto.getLink());
            StringValidation.maxLength((String)".buildless.telemetry.EventDetail.RepositoryDetail.name", (String)proto.getName(), (int)32);
        }
    }

    public static class EventDetail_ClientDetailValidator
    implements ValidatorImpl<EventDetail.ClientDetail> {
        public void assertValid(EventDetail.ClientDetail proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getToolList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasOs()) {
                index.validatorFor((Object)proto.getOs()).assertValid((Object)proto.getOs());
            }
            if (proto.hasAgent()) {
                index.validatorFor((Object)proto.getAgent()).assertValid((Object)proto.getAgent());
            }
        }
    }
}

