/*
 * Decompiled with CFR 0.152.
 */
package com.buildless;

import com.buildless.User;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;

public class UserValidator
implements ValidatorImpl<User> {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(User.class)) {
            return new UserValidator();
        }
        if (clazz.equals(User.UserKey.class)) {
            return new User_UserKeyValidator();
        }
        if (clazz.equals(User.EmailAddress.class)) {
            return new User_EmailAddressValidator();
        }
        if (clazz.equals(User.Name.class)) {
            return new User_NameValidator();
        }
        return null;
    }

    public void assertValid(User proto, ValidatorIndex index) throws ValidationException {
        if (proto.hasKey()) {
            index.validatorFor((Object)proto.getKey()).assertValid((Object)proto.getKey());
        }
        if (proto.hasName()) {
            index.validatorFor((Object)proto.getName()).assertValid((Object)proto.getName());
        }
        RepeatedValidation.forEach(proto.getEmailList(), item -> index.validatorFor(item).assertValid(item));
        if (proto.hasPlan()) {
            index.validatorFor((Object)proto.getPlan()).assertValid((Object)proto.getPlan());
        }
        if (proto.hasUpdatedAt()) {
            index.validatorFor((Object)proto.getUpdatedAt()).assertValid((Object)proto.getUpdatedAt());
        }
        if (proto.hasCreatedAt()) {
            index.validatorFor((Object)proto.getCreatedAt()).assertValid((Object)proto.getCreatedAt());
        }
    }

    public static class User_UserKeyValidator
    implements ValidatorImpl<User.UserKey> {
        public void assertValid(User.UserKey proto, ValidatorIndex index) throws ValidationException {
            StringValidation.maxLength((String)".buildless.User.UserKey.uid", (String)proto.getUid(), (int)128);
        }
    }

    public static class User_EmailAddressValidator
    implements ValidatorImpl<User.EmailAddress> {
        public void assertValid(User.EmailAddress proto, ValidatorIndex index) throws ValidationException {
            StringValidation.email((String)".buildless.User.EmailAddress.address", (String)proto.getAddress());
        }
    }

    public static class User_NameValidator
    implements ValidatorImpl<User.Name> {
        public void assertValid(User.Name proto, ValidatorIndex index) throws ValidationException {
        }
    }
}

