/*
 * Decompiled with CFR 0.152.
 */
package com.buildless;

import com.buildless.Tenant;
import com.google.re2j.Pattern;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;

public class TenantValidator
implements ValidatorImpl<Tenant> {
    Pattern NAME__PATTERN = Pattern.compile((String)"^[a-zA-Z]{1}[a-zA-Z0-9_-]{2,31}$");
    Pattern DISPLAY_NAME__PATTERN = Pattern.compile((String)"^[a-zA-Z0-9 _:#]{2,32}$");
    Pattern REPO_PROVIDER_ORG__PATTERN = Pattern.compile((String)"^[a-zA-Z0-9 _-]{2,31}$");

    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Tenant.class)) {
            return new TenantValidator();
        }
        if (clazz.equals(Tenant.TenantKey.class)) {
            return new Tenant_TenantKeyValidator();
        }
        if (clazz.equals(Tenant.TenantBranding.class)) {
            return new Tenant_TenantBrandingValidator();
        }
        if (clazz.equals(Tenant.TenantDomain.class)) {
            return new Tenant_TenantDomainValidator();
        }
        if (clazz.equals(Tenant.TenantBranding.TenantColors.class)) {
            return new Tenant_TenantBranding_TenantColorsValidator();
        }
        return null;
    }

    public void assertValid(Tenant proto, ValidatorIndex index) throws ValidationException {
        if (proto.hasKey()) {
            index.validatorFor((Object)proto.getKey()).assertValid((Object)proto.getKey());
        }
        StringValidation.maxLength((String)".buildless.Tenant.name", (String)proto.getName(), (int)32);
        StringValidation.pattern((String)".buildless.Tenant.name", (String)proto.getName(), (Pattern)this.NAME__PATTERN);
        StringValidation.maxLength((String)".buildless.Tenant.display_name", (String)proto.getDisplayName(), (int)32);
        StringValidation.pattern((String)".buildless.Tenant.display_name", (String)proto.getDisplayName(), (Pattern)this.DISPLAY_NAME__PATTERN);
        if (proto.hasBranding()) {
            index.validatorFor((Object)proto.getBranding()).assertValid((Object)proto.getBranding());
        }
        RepeatedValidation.forEach(proto.getDomainList(), item -> index.validatorFor(item).assertValid(item));
        if (proto.hasPlan()) {
            index.validatorFor((Object)proto.getPlan()).assertValid((Object)proto.getPlan());
        }
        StringValidation.maxLength((String)".buildless.Tenant.repo_provider_org", (String)proto.getRepoProviderOrg(), (int)32);
        StringValidation.pattern((String)".buildless.Tenant.repo_provider_org", (String)proto.getRepoProviderOrg(), (Pattern)this.REPO_PROVIDER_ORG__PATTERN);
        if (proto.hasUpdatedAt()) {
            index.validatorFor((Object)proto.getUpdatedAt()).assertValid((Object)proto.getUpdatedAt());
        }
        if (proto.hasCreatedAt()) {
            index.validatorFor((Object)proto.getCreatedAt()).assertValid((Object)proto.getCreatedAt());
        }
    }

    public static class Tenant_TenantKeyValidator
    implements ValidatorImpl<Tenant.TenantKey> {
        public void assertValid(Tenant.TenantKey proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class Tenant_TenantBrandingValidator
    implements ValidatorImpl<Tenant.TenantBranding> {
        public void assertValid(Tenant.TenantBranding proto, ValidatorIndex index) throws ValidationException {
            StringValidation.uri((String)".buildless.Tenant.TenantBranding.icon", (String)proto.getIcon());
            StringValidation.uri((String)".buildless.Tenant.TenantBranding.logo", (String)proto.getLogo());
            if (proto.hasLight()) {
                index.validatorFor((Object)proto.getLight()).assertValid((Object)proto.getLight());
            }
            if (proto.hasDark()) {
                index.validatorFor((Object)proto.getDark()).assertValid((Object)proto.getDark());
            }
        }
    }

    public static class Tenant_TenantDomainValidator
    implements ValidatorImpl<Tenant.TenantDomain> {
        public void assertValid(Tenant.TenantDomain proto, ValidatorIndex index) throws ValidationException {
            StringValidation.hostName((String)".buildless.Tenant.TenantDomain.domain", (String)proto.getDomain());
        }
    }

    public static class Tenant_TenantBranding_TenantColorsValidator
    implements ValidatorImpl<Tenant.TenantBranding.TenantColors> {
        public void assertValid(Tenant.TenantBranding.TenantColors proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasPrimary()) {
                index.validatorFor((Object)proto.getPrimary()).assertValid((Object)proto.getPrimary());
            }
            if (proto.hasSecondary()) {
                index.validatorFor((Object)proto.getSecondary()).assertValid((Object)proto.getSecondary());
            }
        }
    }
}

