/*
 * Decompiled with CFR 0.152.
 */
package com.buildless;

import com.buildless.Account;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;

public class AccountValidator
implements ValidatorImpl<Account> {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Account.class)) {
            return new AccountValidator();
        }
        if (clazz.equals(Account.UserAccount.class)) {
            return new Account_UserAccountValidator();
        }
        return null;
    }

    public void assertValid(Account proto, ValidatorIndex index) throws ValidationException {
        switch (proto.getAccountCase()) {
            case USER: {
                if (!proto.hasUser()) break;
                index.validatorFor((Object)proto.getUser()).assertValid((Object)proto.getUser());
                break;
            }
            case TENANT: {
                if (!proto.hasTenant()) break;
                index.validatorFor((Object)proto.getTenant()).assertValid((Object)proto.getTenant());
            }
        }
    }

    public static class Account_UserAccountValidator
    implements ValidatorImpl<Account.UserAccount> {
        public void assertValid(Account.UserAccount proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasTenant()) {
                index.validatorFor((Object)proto.getTenant()).assertValid((Object)proto.getTenant());
            }
            if (proto.hasProfile()) {
                index.validatorFor((Object)proto.getProfile()).assertValid((Object)proto.getProfile());
            }
        }
    }
}

