package com.buildless.service.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Defines the API surface for the Buildless analytics service. This service is used to collect devops analytics, and
 * internal analytics for the suite of Buildless extensions, SDKs, and tools.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.56.0)",
    comments = "Source: buildless/service/v1/buildless-v1.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class TelemetryGrpc {

  private TelemetryGrpc() {}

  public static final String SERVICE_NAME = "buildless.service.v1.Telemetry";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.buildless.service.v1.Event,
      com.buildless.service.v1.EventID> getEventEmitMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "EventEmit",
      requestType = com.buildless.service.v1.Event.class,
      responseType = com.buildless.service.v1.EventID.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.buildless.service.v1.Event,
      com.buildless.service.v1.EventID> getEventEmitMethod() {
    io.grpc.MethodDescriptor<com.buildless.service.v1.Event, com.buildless.service.v1.EventID> getEventEmitMethod;
    if ((getEventEmitMethod = TelemetryGrpc.getEventEmitMethod) == null) {
      synchronized (TelemetryGrpc.class) {
        if ((getEventEmitMethod = TelemetryGrpc.getEventEmitMethod) == null) {
          TelemetryGrpc.getEventEmitMethod = getEventEmitMethod =
              io.grpc.MethodDescriptor.<com.buildless.service.v1.Event, com.buildless.service.v1.EventID>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "EventEmit"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.Event.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.EventID.getDefaultInstance()))
              .setSchemaDescriptor(new TelemetryMethodDescriptorSupplier("EventEmit"))
              .build();
        }
      }
    }
    return getEventEmitMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.buildless.service.v1.Event,
      com.buildless.service.v1.EventID> getEventStreamMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "EventStream",
      requestType = com.buildless.service.v1.Event.class,
      responseType = com.buildless.service.v1.EventID.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<com.buildless.service.v1.Event,
      com.buildless.service.v1.EventID> getEventStreamMethod() {
    io.grpc.MethodDescriptor<com.buildless.service.v1.Event, com.buildless.service.v1.EventID> getEventStreamMethod;
    if ((getEventStreamMethod = TelemetryGrpc.getEventStreamMethod) == null) {
      synchronized (TelemetryGrpc.class) {
        if ((getEventStreamMethod = TelemetryGrpc.getEventStreamMethod) == null) {
          TelemetryGrpc.getEventStreamMethod = getEventStreamMethod =
              io.grpc.MethodDescriptor.<com.buildless.service.v1.Event, com.buildless.service.v1.EventID>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "EventStream"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.Event.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.EventID.getDefaultInstance()))
              .setSchemaDescriptor(new TelemetryMethodDescriptorSupplier("EventStream"))
              .build();
        }
      }
    }
    return getEventStreamMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static TelemetryStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TelemetryStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TelemetryStub>() {
        @java.lang.Override
        public TelemetryStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TelemetryStub(channel, callOptions);
        }
      };
    return TelemetryStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static TelemetryBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TelemetryBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TelemetryBlockingStub>() {
        @java.lang.Override
        public TelemetryBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TelemetryBlockingStub(channel, callOptions);
        }
      };
    return TelemetryBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static TelemetryFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TelemetryFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TelemetryFutureStub>() {
        @java.lang.Override
        public TelemetryFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TelemetryFutureStub(channel, callOptions);
        }
      };
    return TelemetryFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Defines the API surface for the Buildless analytics service. This service is used to collect devops analytics, and
   * internal analytics for the suite of Buildless extensions, SDKs, and tools.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * ## Emit an Event
     * Emits a single event to the telemetry service. This method is used to emit events which are not part of a series. The event in question is enriched/decorated with additional context, and then acknowledged or rejected.
     * </pre>
     */
    default void eventEmit(com.buildless.service.v1.Event request,
        io.grpc.stub.StreamObserver<com.buildless.service.v1.EventID> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getEventEmitMethod(), responseObserver);
    }

    /**
     * <pre>
     * ## Emit a Stream of Events
     * Establishes a stream over which events can be reported to the telemetry service efficiently, and in bulk (the event payloads in question are automatically associated). This method is used to emit events which are part of a series.
     * </pre>
     */
    default io.grpc.stub.StreamObserver<com.buildless.service.v1.Event> eventStream(
        io.grpc.stub.StreamObserver<com.buildless.service.v1.EventID> responseObserver) {
      return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getEventStreamMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service Telemetry.
   * <pre>
   * Defines the API surface for the Buildless analytics service. This service is used to collect devops analytics, and
   * internal analytics for the suite of Buildless extensions, SDKs, and tools.
   * </pre>
   */
  public static abstract class TelemetryImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return TelemetryGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service Telemetry.
   * <pre>
   * Defines the API surface for the Buildless analytics service. This service is used to collect devops analytics, and
   * internal analytics for the suite of Buildless extensions, SDKs, and tools.
   * </pre>
   */
  public static final class TelemetryStub
      extends io.grpc.stub.AbstractAsyncStub<TelemetryStub> {
    private TelemetryStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TelemetryStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TelemetryStub(channel, callOptions);
    }

    /**
     * <pre>
     * ## Emit an Event
     * Emits a single event to the telemetry service. This method is used to emit events which are not part of a series. The event in question is enriched/decorated with additional context, and then acknowledged or rejected.
     * </pre>
     */
    public void eventEmit(com.buildless.service.v1.Event request,
        io.grpc.stub.StreamObserver<com.buildless.service.v1.EventID> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getEventEmitMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ## Emit a Stream of Events
     * Establishes a stream over which events can be reported to the telemetry service efficiently, and in bulk (the event payloads in question are automatically associated). This method is used to emit events which are part of a series.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<com.buildless.service.v1.Event> eventStream(
        io.grpc.stub.StreamObserver<com.buildless.service.v1.EventID> responseObserver) {
      return io.grpc.stub.ClientCalls.asyncBidiStreamingCall(
          getChannel().newCall(getEventStreamMethod(), getCallOptions()), responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service Telemetry.
   * <pre>
   * Defines the API surface for the Buildless analytics service. This service is used to collect devops analytics, and
   * internal analytics for the suite of Buildless extensions, SDKs, and tools.
   * </pre>
   */
  public static final class TelemetryBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<TelemetryBlockingStub> {
    private TelemetryBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TelemetryBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TelemetryBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * ## Emit an Event
     * Emits a single event to the telemetry service. This method is used to emit events which are not part of a series. The event in question is enriched/decorated with additional context, and then acknowledged or rejected.
     * </pre>
     */
    public com.buildless.service.v1.EventID eventEmit(com.buildless.service.v1.Event request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getEventEmitMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service Telemetry.
   * <pre>
   * Defines the API surface for the Buildless analytics service. This service is used to collect devops analytics, and
   * internal analytics for the suite of Buildless extensions, SDKs, and tools.
   * </pre>
   */
  public static final class TelemetryFutureStub
      extends io.grpc.stub.AbstractFutureStub<TelemetryFutureStub> {
    private TelemetryFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TelemetryFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TelemetryFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * ## Emit an Event
     * Emits a single event to the telemetry service. This method is used to emit events which are not part of a series. The event in question is enriched/decorated with additional context, and then acknowledged or rejected.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.buildless.service.v1.EventID> eventEmit(
        com.buildless.service.v1.Event request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getEventEmitMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_EVENT_EMIT = 0;
  private static final int METHODID_EVENT_STREAM = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_EVENT_EMIT:
          serviceImpl.eventEmit((com.buildless.service.v1.Event) request,
              (io.grpc.stub.StreamObserver<com.buildless.service.v1.EventID>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_EVENT_STREAM:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.eventStream(
              (io.grpc.stub.StreamObserver<com.buildless.service.v1.EventID>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getEventEmitMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.buildless.service.v1.Event,
              com.buildless.service.v1.EventID>(
                service, METHODID_EVENT_EMIT)))
        .addMethod(
          getEventStreamMethod(),
          io.grpc.stub.ServerCalls.asyncBidiStreamingCall(
            new MethodHandlers<
              com.buildless.service.v1.Event,
              com.buildless.service.v1.EventID>(
                service, METHODID_EVENT_STREAM)))
        .build();
  }

  private static abstract class TelemetryBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    TelemetryBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.buildless.service.v1.BuildlessV1Proto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Telemetry");
    }
  }

  private static final class TelemetryFileDescriptorSupplier
      extends TelemetryBaseDescriptorSupplier {
    TelemetryFileDescriptorSupplier() {}
  }

  private static final class TelemetryMethodDescriptorSupplier
      extends TelemetryBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    TelemetryMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (TelemetryGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new TelemetryFileDescriptorSupplier())
              .addMethod(getEventEmitMethod())
              .addMethod(getEventStreamMethod())
              .build();
        }
      }
    }
    return result;
  }
}
