// Code generated by connect-kotlin. DO NOT EDIT.
//
// Source: buildless/service/v1/buildless-v1.proto
//
package com.buildless.service.v1

import build.buf.connect.BidirectionalStreamInterface
import build.buf.connect.Headers
import build.buf.connect.MethodSpec
import build.buf.connect.ProtocolClientInterface
import build.buf.connect.ResponseMessage

/**
 *  Defines the API surface for the Buildless analytics service. This service is used to collect
 * devops analytics, and
 *  internal analytics for the suite of Buildless extensions, SDKs, and tools.
 */
public class TelemetryClient(
  private val client: ProtocolClientInterface,
) : TelemetryClientInterface {
  /**
   *  ## Emit an Event
   *
   *  Emits a single event to the telemetry service. This method is used to emit events which are
   * not part of a series. The event in question is enriched/decorated with additional context, and
   * then acknowledged or rejected.
   */
  public override suspend fun eventEmit(request: Event, headers: Headers): ResponseMessage<EventID>
      = client.unary(
    request,
    headers,
    MethodSpec(
    "buildless.service.v1.Telemetry/EventEmit",
      com.buildless.service.v1.Event::class,
      com.buildless.service.v1.EventID::class
    ),
  )


  /**
   *  ## Emit a Stream of Events
   *
   *  Establishes a stream over which events can be reported to the telemetry service efficiently,
   * and in bulk (the event payloads in question are automatically associated). This method is used to
   * emit events which are part of a series.
   */
  public override suspend fun eventStream(headers: Headers):
      BidirectionalStreamInterface<Event, EventID> = client.stream(
    headers,
    MethodSpec(
    "buildless.service.v1.Telemetry/EventStream",
      com.buildless.service.v1.Event::class,
      com.buildless.service.v1.EventID::class
    ),
  )

}
