package com.buildless.service.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Defines the API surface for the main Buildless service. Methods defined in this service are typically open to
 * third-party developers. Under the hood of Buildless-powered tools, or via 3rd-party tools, these methods may be used
 * to interact with the global cache, manage account state, and more.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.56.0)",
    comments = "Source: buildless/service/v1/buildless-v1.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class BuildlessGrpc {

  private BuildlessGrpc() {}

  public static final String SERVICE_NAME = "buildless.service.v1.Buildless";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFetchRequest,
      com.google.protobuf.Empty> getCacheProbeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CacheProbe",
      requestType = com.buildless.service.v1.CacheFetchRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFetchRequest,
      com.google.protobuf.Empty> getCacheProbeMethod() {
    io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFetchRequest, com.google.protobuf.Empty> getCacheProbeMethod;
    if ((getCacheProbeMethod = BuildlessGrpc.getCacheProbeMethod) == null) {
      synchronized (BuildlessGrpc.class) {
        if ((getCacheProbeMethod = BuildlessGrpc.getCacheProbeMethod) == null) {
          BuildlessGrpc.getCacheProbeMethod = getCacheProbeMethod =
              io.grpc.MethodDescriptor.<com.buildless.service.v1.CacheFetchRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CacheProbe"))
              .setSafe(true)
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.CacheFetchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new BuildlessMethodDescriptorSupplier("CacheProbe"))
              .build();
        }
      }
    }
    return getCacheProbeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFetchRequest,
      com.google.api.HttpBody> getCacheFetchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CacheFetch",
      requestType = com.buildless.service.v1.CacheFetchRequest.class,
      responseType = com.google.api.HttpBody.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFetchRequest,
      com.google.api.HttpBody> getCacheFetchMethod() {
    io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFetchRequest, com.google.api.HttpBody> getCacheFetchMethod;
    if ((getCacheFetchMethod = BuildlessGrpc.getCacheFetchMethod) == null) {
      synchronized (BuildlessGrpc.class) {
        if ((getCacheFetchMethod = BuildlessGrpc.getCacheFetchMethod) == null) {
          BuildlessGrpc.getCacheFetchMethod = getCacheFetchMethod =
              io.grpc.MethodDescriptor.<com.buildless.service.v1.CacheFetchRequest, com.google.api.HttpBody>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CacheFetch"))
              .setSafe(true)
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.CacheFetchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.api.HttpBody.getDefaultInstance()))
              .setSchemaDescriptor(new BuildlessMethodDescriptorSupplier("CacheFetch"))
              .build();
        }
      }
    }
    return getCacheFetchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.buildless.service.v1.CacheStoreRequest,
      com.buildless.service.v1.CacheStoreResponse> getCacheStoreMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CacheStore",
      requestType = com.buildless.service.v1.CacheStoreRequest.class,
      responseType = com.buildless.service.v1.CacheStoreResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.buildless.service.v1.CacheStoreRequest,
      com.buildless.service.v1.CacheStoreResponse> getCacheStoreMethod() {
    io.grpc.MethodDescriptor<com.buildless.service.v1.CacheStoreRequest, com.buildless.service.v1.CacheStoreResponse> getCacheStoreMethod;
    if ((getCacheStoreMethod = BuildlessGrpc.getCacheStoreMethod) == null) {
      synchronized (BuildlessGrpc.class) {
        if ((getCacheStoreMethod = BuildlessGrpc.getCacheStoreMethod) == null) {
          BuildlessGrpc.getCacheStoreMethod = getCacheStoreMethod =
              io.grpc.MethodDescriptor.<com.buildless.service.v1.CacheStoreRequest, com.buildless.service.v1.CacheStoreResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CacheStore"))
              .setIdempotent(true)
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.CacheStoreRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.CacheStoreResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BuildlessMethodDescriptorSupplier("CacheStore"))
              .build();
        }
      }
    }
    return getCacheStoreMethod;
  }

  private static volatile io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFlushRequest,
      com.google.protobuf.Empty> getCacheFlushMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CacheFlush",
      requestType = com.buildless.service.v1.CacheFlushRequest.class,
      responseType = com.google.protobuf.Empty.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFlushRequest,
      com.google.protobuf.Empty> getCacheFlushMethod() {
    io.grpc.MethodDescriptor<com.buildless.service.v1.CacheFlushRequest, com.google.protobuf.Empty> getCacheFlushMethod;
    if ((getCacheFlushMethod = BuildlessGrpc.getCacheFlushMethod) == null) {
      synchronized (BuildlessGrpc.class) {
        if ((getCacheFlushMethod = BuildlessGrpc.getCacheFlushMethod) == null) {
          BuildlessGrpc.getCacheFlushMethod = getCacheFlushMethod =
              io.grpc.MethodDescriptor.<com.buildless.service.v1.CacheFlushRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CacheFlush"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.buildless.service.v1.CacheFlushRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
              .setSchemaDescriptor(new BuildlessMethodDescriptorSupplier("CacheFlush"))
              .build();
        }
      }
    }
    return getCacheFlushMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static BuildlessStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<BuildlessStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<BuildlessStub>() {
        @java.lang.Override
        public BuildlessStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new BuildlessStub(channel, callOptions);
        }
      };
    return BuildlessStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static BuildlessBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<BuildlessBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<BuildlessBlockingStub>() {
        @java.lang.Override
        public BuildlessBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new BuildlessBlockingStub(channel, callOptions);
        }
      };
    return BuildlessBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static BuildlessFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<BuildlessFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<BuildlessFutureStub>() {
        @java.lang.Override
        public BuildlessFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new BuildlessFutureStub(channel, callOptions);
        }
      };
    return BuildlessFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Defines the API surface for the main Buildless service. Methods defined in this service are typically open to
   * third-party developers. Under the hood of Buildless-powered tools, or via 3rd-party tools, these methods may be used
   * to interact with the global cache, manage account state, and more.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     * ## Cache Probe
     * Probe the cache for a specific key. This method is used to determine whether a key is present in the cache without consuming the data associated with the key.
     * This method is typically used by clients to determine whether a key is worth downloads from the cache, or whether it should be built locally.
     * Often, tooling will skip this step and perform a `CacheFetch` directly, relying on HTTP 404 to indicate that the item could not be found. All cache probe requests must be authorized with an API key or user token.
     * </pre>
     */
    default void cacheProbe(com.buildless.service.v1.CacheFetchRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCacheProbeMethod(), responseObserver);
    }

    /**
     * <pre>
     * ## Cache Fetch
     * Fetch an item from the Buildless cache which resides at a known key. This endpoint should be used by tools which already know how to properly cache and resolve build inputs.
     * Cache fetch requests are simple, and deal with only one input: a key, which should either be present in the hash or not. If the key is present, the cache will return the blob associated with it; in some circumstances, for large blobs, a redirect may be returned (where supported).
     * If the key is not present, an HTTP 404 is issued to indicate a missing cache value. All cache fetch requests must be authorized either by a Buildless API key, or a user token.
     * ### Avoiding HTTP caching
     * If desired, `POST` may also be used for the `CacheFetch` operation, which avoids intermediate HTTP caching. By default, `GET` may be used if HTTP caching is desired or acceptable for your use case.
     * </pre>
     */
    default void cacheFetch(com.buildless.service.v1.CacheFetchRequest request,
        io.grpc.stub.StreamObserver<com.google.api.HttpBody> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCacheFetchMethod(), responseObserver);
    }

    /**
     * <pre>
     * ## Cache Store
     * Persist a bundle of raw data with the Buildless cache, which should reside at a known key. This endpoint should be used by tools which already know how to properly cache and resolve build inputs.
     * Cache store requests specify the key at which the item should be stored. Cache keys may vary by tool or project, but, in all cases, are considered opaque by Buildless. All cache store requests must be authorized either by a Buildless API key, or a user token.
     * HTTP `POST` and `PUT` are interchangeable for this endpoint.
     * *Note:* The headers `Content-Type` and `Content-Length` are required to be set on all inputs. The `Content-Type` value is respected by the cache when the content is served. Different `Content-Length` values may change how the server responds to the upload request.
     * </pre>
     */
    default void cacheStore(com.buildless.service.v1.CacheStoreRequest request,
        io.grpc.stub.StreamObserver<com.buildless.service.v1.CacheStoreResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCacheStoreMethod(), responseObserver);
    }

    /**
     * <pre>
     * ## Cache Flush by Key
     * Flush data from the cache at a given cache key. If the data is not held by the cache, or is already expired, then this method is a no-op; otherwise, the data is removed from the cache.
     * Cache flush requests may take some time to process. As a good rule of thumb, the cache should be considered in-sync within 30 seconds of issuing a `CacheFlush` request.
     * All cache flush requests must be authorized either by a Buildless API key, or a user token.
     * </pre>
     */
    default void cacheFlush(com.buildless.service.v1.CacheFlushRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCacheFlushMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service Buildless.
   * <pre>
   * Defines the API surface for the main Buildless service. Methods defined in this service are typically open to
   * third-party developers. Under the hood of Buildless-powered tools, or via 3rd-party tools, these methods may be used
   * to interact with the global cache, manage account state, and more.
   * </pre>
   */
  public static abstract class BuildlessImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return BuildlessGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service Buildless.
   * <pre>
   * Defines the API surface for the main Buildless service. Methods defined in this service are typically open to
   * third-party developers. Under the hood of Buildless-powered tools, or via 3rd-party tools, these methods may be used
   * to interact with the global cache, manage account state, and more.
   * </pre>
   */
  public static final class BuildlessStub
      extends io.grpc.stub.AbstractAsyncStub<BuildlessStub> {
    private BuildlessStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BuildlessStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new BuildlessStub(channel, callOptions);
    }

    /**
     * <pre>
     * ## Cache Probe
     * Probe the cache for a specific key. This method is used to determine whether a key is present in the cache without consuming the data associated with the key.
     * This method is typically used by clients to determine whether a key is worth downloads from the cache, or whether it should be built locally.
     * Often, tooling will skip this step and perform a `CacheFetch` directly, relying on HTTP 404 to indicate that the item could not be found. All cache probe requests must be authorized with an API key or user token.
     * </pre>
     */
    public void cacheProbe(com.buildless.service.v1.CacheFetchRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCacheProbeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ## Cache Fetch
     * Fetch an item from the Buildless cache which resides at a known key. This endpoint should be used by tools which already know how to properly cache and resolve build inputs.
     * Cache fetch requests are simple, and deal with only one input: a key, which should either be present in the hash or not. If the key is present, the cache will return the blob associated with it; in some circumstances, for large blobs, a redirect may be returned (where supported).
     * If the key is not present, an HTTP 404 is issued to indicate a missing cache value. All cache fetch requests must be authorized either by a Buildless API key, or a user token.
     * ### Avoiding HTTP caching
     * If desired, `POST` may also be used for the `CacheFetch` operation, which avoids intermediate HTTP caching. By default, `GET` may be used if HTTP caching is desired or acceptable for your use case.
     * </pre>
     */
    public void cacheFetch(com.buildless.service.v1.CacheFetchRequest request,
        io.grpc.stub.StreamObserver<com.google.api.HttpBody> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCacheFetchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ## Cache Store
     * Persist a bundle of raw data with the Buildless cache, which should reside at a known key. This endpoint should be used by tools which already know how to properly cache and resolve build inputs.
     * Cache store requests specify the key at which the item should be stored. Cache keys may vary by tool or project, but, in all cases, are considered opaque by Buildless. All cache store requests must be authorized either by a Buildless API key, or a user token.
     * HTTP `POST` and `PUT` are interchangeable for this endpoint.
     * *Note:* The headers `Content-Type` and `Content-Length` are required to be set on all inputs. The `Content-Type` value is respected by the cache when the content is served. Different `Content-Length` values may change how the server responds to the upload request.
     * </pre>
     */
    public void cacheStore(com.buildless.service.v1.CacheStoreRequest request,
        io.grpc.stub.StreamObserver<com.buildless.service.v1.CacheStoreResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCacheStoreMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ## Cache Flush by Key
     * Flush data from the cache at a given cache key. If the data is not held by the cache, or is already expired, then this method is a no-op; otherwise, the data is removed from the cache.
     * Cache flush requests may take some time to process. As a good rule of thumb, the cache should be considered in-sync within 30 seconds of issuing a `CacheFlush` request.
     * All cache flush requests must be authorized either by a Buildless API key, or a user token.
     * </pre>
     */
    public void cacheFlush(com.buildless.service.v1.CacheFlushRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCacheFlushMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service Buildless.
   * <pre>
   * Defines the API surface for the main Buildless service. Methods defined in this service are typically open to
   * third-party developers. Under the hood of Buildless-powered tools, or via 3rd-party tools, these methods may be used
   * to interact with the global cache, manage account state, and more.
   * </pre>
   */
  public static final class BuildlessBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<BuildlessBlockingStub> {
    private BuildlessBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BuildlessBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new BuildlessBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * ## Cache Probe
     * Probe the cache for a specific key. This method is used to determine whether a key is present in the cache without consuming the data associated with the key.
     * This method is typically used by clients to determine whether a key is worth downloads from the cache, or whether it should be built locally.
     * Often, tooling will skip this step and perform a `CacheFetch` directly, relying on HTTP 404 to indicate that the item could not be found. All cache probe requests must be authorized with an API key or user token.
     * </pre>
     */
    public com.google.protobuf.Empty cacheProbe(com.buildless.service.v1.CacheFetchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCacheProbeMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ## Cache Fetch
     * Fetch an item from the Buildless cache which resides at a known key. This endpoint should be used by tools which already know how to properly cache and resolve build inputs.
     * Cache fetch requests are simple, and deal with only one input: a key, which should either be present in the hash or not. If the key is present, the cache will return the blob associated with it; in some circumstances, for large blobs, a redirect may be returned (where supported).
     * If the key is not present, an HTTP 404 is issued to indicate a missing cache value. All cache fetch requests must be authorized either by a Buildless API key, or a user token.
     * ### Avoiding HTTP caching
     * If desired, `POST` may also be used for the `CacheFetch` operation, which avoids intermediate HTTP caching. By default, `GET` may be used if HTTP caching is desired or acceptable for your use case.
     * </pre>
     */
    public com.google.api.HttpBody cacheFetch(com.buildless.service.v1.CacheFetchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCacheFetchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ## Cache Store
     * Persist a bundle of raw data with the Buildless cache, which should reside at a known key. This endpoint should be used by tools which already know how to properly cache and resolve build inputs.
     * Cache store requests specify the key at which the item should be stored. Cache keys may vary by tool or project, but, in all cases, are considered opaque by Buildless. All cache store requests must be authorized either by a Buildless API key, or a user token.
     * HTTP `POST` and `PUT` are interchangeable for this endpoint.
     * *Note:* The headers `Content-Type` and `Content-Length` are required to be set on all inputs. The `Content-Type` value is respected by the cache when the content is served. Different `Content-Length` values may change how the server responds to the upload request.
     * </pre>
     */
    public com.buildless.service.v1.CacheStoreResponse cacheStore(com.buildless.service.v1.CacheStoreRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCacheStoreMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ## Cache Flush by Key
     * Flush data from the cache at a given cache key. If the data is not held by the cache, or is already expired, then this method is a no-op; otherwise, the data is removed from the cache.
     * Cache flush requests may take some time to process. As a good rule of thumb, the cache should be considered in-sync within 30 seconds of issuing a `CacheFlush` request.
     * All cache flush requests must be authorized either by a Buildless API key, or a user token.
     * </pre>
     */
    public com.google.protobuf.Empty cacheFlush(com.buildless.service.v1.CacheFlushRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCacheFlushMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service Buildless.
   * <pre>
   * Defines the API surface for the main Buildless service. Methods defined in this service are typically open to
   * third-party developers. Under the hood of Buildless-powered tools, or via 3rd-party tools, these methods may be used
   * to interact with the global cache, manage account state, and more.
   * </pre>
   */
  public static final class BuildlessFutureStub
      extends io.grpc.stub.AbstractFutureStub<BuildlessFutureStub> {
    private BuildlessFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BuildlessFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new BuildlessFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * ## Cache Probe
     * Probe the cache for a specific key. This method is used to determine whether a key is present in the cache without consuming the data associated with the key.
     * This method is typically used by clients to determine whether a key is worth downloads from the cache, or whether it should be built locally.
     * Often, tooling will skip this step and perform a `CacheFetch` directly, relying on HTTP 404 to indicate that the item could not be found. All cache probe requests must be authorized with an API key or user token.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> cacheProbe(
        com.buildless.service.v1.CacheFetchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCacheProbeMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ## Cache Fetch
     * Fetch an item from the Buildless cache which resides at a known key. This endpoint should be used by tools which already know how to properly cache and resolve build inputs.
     * Cache fetch requests are simple, and deal with only one input: a key, which should either be present in the hash or not. If the key is present, the cache will return the blob associated with it; in some circumstances, for large blobs, a redirect may be returned (where supported).
     * If the key is not present, an HTTP 404 is issued to indicate a missing cache value. All cache fetch requests must be authorized either by a Buildless API key, or a user token.
     * ### Avoiding HTTP caching
     * If desired, `POST` may also be used for the `CacheFetch` operation, which avoids intermediate HTTP caching. By default, `GET` may be used if HTTP caching is desired or acceptable for your use case.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.api.HttpBody> cacheFetch(
        com.buildless.service.v1.CacheFetchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCacheFetchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ## Cache Store
     * Persist a bundle of raw data with the Buildless cache, which should reside at a known key. This endpoint should be used by tools which already know how to properly cache and resolve build inputs.
     * Cache store requests specify the key at which the item should be stored. Cache keys may vary by tool or project, but, in all cases, are considered opaque by Buildless. All cache store requests must be authorized either by a Buildless API key, or a user token.
     * HTTP `POST` and `PUT` are interchangeable for this endpoint.
     * *Note:* The headers `Content-Type` and `Content-Length` are required to be set on all inputs. The `Content-Type` value is respected by the cache when the content is served. Different `Content-Length` values may change how the server responds to the upload request.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.buildless.service.v1.CacheStoreResponse> cacheStore(
        com.buildless.service.v1.CacheStoreRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCacheStoreMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ## Cache Flush by Key
     * Flush data from the cache at a given cache key. If the data is not held by the cache, or is already expired, then this method is a no-op; otherwise, the data is removed from the cache.
     * Cache flush requests may take some time to process. As a good rule of thumb, the cache should be considered in-sync within 30 seconds of issuing a `CacheFlush` request.
     * All cache flush requests must be authorized either by a Buildless API key, or a user token.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> cacheFlush(
        com.buildless.service.v1.CacheFlushRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCacheFlushMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CACHE_PROBE = 0;
  private static final int METHODID_CACHE_FETCH = 1;
  private static final int METHODID_CACHE_STORE = 2;
  private static final int METHODID_CACHE_FLUSH = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CACHE_PROBE:
          serviceImpl.cacheProbe((com.buildless.service.v1.CacheFetchRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        case METHODID_CACHE_FETCH:
          serviceImpl.cacheFetch((com.buildless.service.v1.CacheFetchRequest) request,
              (io.grpc.stub.StreamObserver<com.google.api.HttpBody>) responseObserver);
          break;
        case METHODID_CACHE_STORE:
          serviceImpl.cacheStore((com.buildless.service.v1.CacheStoreRequest) request,
              (io.grpc.stub.StreamObserver<com.buildless.service.v1.CacheStoreResponse>) responseObserver);
          break;
        case METHODID_CACHE_FLUSH:
          serviceImpl.cacheFlush((com.buildless.service.v1.CacheFlushRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getCacheProbeMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.buildless.service.v1.CacheFetchRequest,
              com.google.protobuf.Empty>(
                service, METHODID_CACHE_PROBE)))
        .addMethod(
          getCacheFetchMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.buildless.service.v1.CacheFetchRequest,
              com.google.api.HttpBody>(
                service, METHODID_CACHE_FETCH)))
        .addMethod(
          getCacheStoreMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.buildless.service.v1.CacheStoreRequest,
              com.buildless.service.v1.CacheStoreResponse>(
                service, METHODID_CACHE_STORE)))
        .addMethod(
          getCacheFlushMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              com.buildless.service.v1.CacheFlushRequest,
              com.google.protobuf.Empty>(
                service, METHODID_CACHE_FLUSH)))
        .build();
  }

  private static abstract class BuildlessBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    BuildlessBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.buildless.service.v1.BuildlessV1Proto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Buildless");
    }
  }

  private static final class BuildlessFileDescriptorSupplier
      extends BuildlessBaseDescriptorSupplier {
    BuildlessFileDescriptorSupplier() {}
  }

  private static final class BuildlessMethodDescriptorSupplier
      extends BuildlessBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    BuildlessMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (BuildlessGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new BuildlessFileDescriptorSupplier())
              .addMethod(getCacheProbeMethod())
              .addMethod(getCacheFetchMethod())
              .addMethod(getCacheStoreMethod())
              .addMethod(getCacheFlushMethod())
              .build();
        }
      }
    }
    return result;
  }
}
