// Code generated by connect-kotlin. DO NOT EDIT.
//
// Source: buildless/service/v1/buildless-v1.proto
//
package com.buildless.service.v1

import build.buf.connect.Headers
import build.buf.connect.MethodSpec
import build.buf.connect.ProtocolClientInterface
import build.buf.connect.ResponseMessage
import com.google.api.HttpBody
import com.google.protobuf.Empty

/**
 *  Defines the API surface for the main Buildless service. Methods defined in this service are
 * typically open to
 *  third-party developers. Under the hood of Buildless-powered tools, or via 3rd-party tools, these
 * methods may be used
 *  to interact with the global cache, manage account state, and more.
 */
public class BuildlessClient(
  private val client: ProtocolClientInterface,
) : BuildlessClientInterface {
  /**
   *  ## Cache Probe
   *
   *  Probe the cache for a specific key. This method is used to determine whether a key is present
   * in the cache without consuming the data associated with the key.
   *
   *  This method is typically used by clients to determine whether a key is worth downloads from
   * the cache, or whether it should be built locally.
   *
   *  Often, tooling will skip this step and perform a `CacheFetch` directly, relying on HTTP 404 to
   * indicate that the item could not be found. All cache probe requests must be authorized with an API
   * key or user token.
   */
  public override suspend fun cacheProbe(request: CacheFetchRequest, headers: Headers):
      ResponseMessage<Empty> = client.unary(
    request,
    headers,
    MethodSpec(
    "buildless.service.v1.Buildless/CacheProbe",
      com.buildless.service.v1.CacheFetchRequest::class,
      com.google.protobuf.Empty::class
    ),
  )


  /**
   *  ## Cache Fetch
   *
   *  Fetch an item from the Buildless cache which resides at a known key. This endpoint should be
   * used by tools which already know how to properly cache and resolve build inputs.
   *
   *  Cache fetch requests are simple, and deal with only one input: a key, which should either be
   * present in the hash or not. If the key is present, the cache will return the blob associated with
   * it; in some circumstances, for large blobs, a redirect may be returned (where supported).
   *
   *  If the key is not present, an HTTP 404 is issued to indicate a missing cache value. All cache
   * fetch requests must be authorized either by a Buildless API key, or a user token.
   *
   *  ### Avoiding HTTP caching
   *
   *  If desired, `POST` may also be used for the `CacheFetch` operation, which avoids intermediate
   * HTTP caching. By default, `GET` may be used if HTTP caching is desired or acceptable for your use
   * case.
   */
  public override suspend fun cacheFetch(request: CacheFetchRequest, headers: Headers):
      ResponseMessage<HttpBody> = client.unary(
    request,
    headers,
    MethodSpec(
    "buildless.service.v1.Buildless/CacheFetch",
      com.buildless.service.v1.CacheFetchRequest::class,
      com.google.api.HttpBody::class
    ),
  )


  /**
   *  ## Cache Store
   *
   *  Persist a bundle of raw data with the Buildless cache, which should reside at a known key.
   * This endpoint should be used by tools which already know how to properly cache and resolve build
   * inputs.
   *
   *  Cache store requests specify the key at which the item should be stored. Cache keys may vary
   * by tool or project, but, in all cases, are considered opaque by Buildless. All cache store
   * requests must be authorized either by a Buildless API key, or a user token.
   *
   *  HTTP `POST` and `PUT` are interchangeable for this endpoint.
   *
   *  *Note:* The headers `Content-Type` and `Content-Length` are required to be set on all inputs.
   * The `Content-Type` value is respected by the cache when the content is served. Different
   * `Content-Length` values may change how the server responds to the upload request.
   */
  public override suspend fun cacheStore(request: CacheStoreRequest, headers: Headers):
      ResponseMessage<CacheStoreResponse> = client.unary(
    request,
    headers,
    MethodSpec(
    "buildless.service.v1.Buildless/CacheStore",
      com.buildless.service.v1.CacheStoreRequest::class,
      com.buildless.service.v1.CacheStoreResponse::class
    ),
  )


  /**
   *  ## Cache Flush by Key
   *
   *  Flush data from the cache at a given cache key. If the data is not held by the cache, or is
   * already expired, then this method is a no-op; otherwise, the data is removed from the cache.
   *
   *  Cache flush requests may take some time to process. As a good rule of thumb, the cache should
   * be considered in-sync within 30 seconds of issuing a `CacheFlush` request.
   *
   *  All cache flush requests must be authorized either by a Buildless API key, or a user token.
   */
  public override suspend fun cacheFlush(request: CacheFlushRequest, headers: Headers):
      ResponseMessage<Empty> = client.unary(
    request,
    headers,
    MethodSpec(
    "buildless.service.v1.Buildless/CacheFlush",
      com.buildless.service.v1.CacheFlushRequest::class,
      com.google.protobuf.Empty::class
    ),
  )

}
