// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: buildless/api/meta.proto

package com.buildless.api;

/**
 * <pre>
 * ## Method Authorization
 *
 * Specifies authorization configuration for a given RPC method provided by a Buildless API service. Settings on this
 * configuration are enforced by interceptors on behalf of the service under invocation. Proto-methods may be annotated
 * with these settings via the `buildless.api.authz` coordinate.
 *
 * ### Anonymous Access
 *
 * If the `anonymous_access` flag is set, the method is allowed to be invoked without any credentials present at all. In
 * this case, it is up to the method implementation to enforce second-order auth. There are two application features
 * where this is useful:
 *
 * - **Open methods.** Some methods (for example, `AppInfo`) return publicly-available information, and don't need to
 *   perform authorization steps. In this context, authorization may be wasteful.
 *
 * - **Anonymous-enabled methods.** Some methods (for example, cache access) can be opened up for public access on a
 *   policy basis by authorized users. In this case, the method implementation is responsible for enforcing second-order
 *   authorization state; for example, enforcing authorization state if-and-only-if the project under access demands it.
 *
 * ### Publishable API Keys
 *
 * "Publishable" API keys are keys which are safe to publish. These keys are typically used for non-sensitive or write-
 * only operations, like telemetry submission. If the `publishable` flag is set, interceptors will allow invocations
 * which specify a publishable key. By default, publishable keys are not allowed on any method.
 *
 * ### Authorization Behavior
 *
 * After enforcing the policies defined on this record, interceptors will mount resulting credential material within the
 * execution context for the invocation. Implementations may then access these values via well-typed context keys. See
 * the `CallMetadata` file for more information.
 *
 * Guarantees provided by this implementation:
 *
 * - **Values are well-formed.** If a value is read by the interceptor at all, it is well-formed. Downstream consumers
 *   may assume that the value has been validated statically to a reasonable extent.
 *
 * - **Values are semantically valid.** If a value is read by the interceptor, it is used properly and in the right
 *   "place" (the right header, context, etc). Downstream consumers need not verify the value's use semantics.
 *
 * - **Values are verified.** At the point a method invocation begins, all relevant authorization material has already
 *   been calculated and enforced. Downstream consumers do not need to look up user or tenant records, for example, to
 *   make sure they exist.
 *
 * ### Exhaustive settings list
 *
 * - `allow_anonymous`: Allow anonymous invocations (i.e. invocations with no credentials present). **Danger:** When
 *   this option is set, authorization steps `MUST` be performed by the implementation, as applicable.
 *
 * - `allow_publishable`: Allow the use of "publishable" API keys. **Danger:** When this option is set, API keys may be
 *   used which are intended to be published. The end-client may not be an explicitly-authorized user.
 *
 * - `require_token`: Require a valid end-user authorization token, or signed session, to be present on the request. In
 *   this mode, `USER` authorization mode is implied.
 *
 * - `sensitive`: Mark the method as a "sensitive" operation. In this case, an additional authorization step may be
 *   required; in some circumstances, this may be a "sudo" upgrade of a user's session, for instance, using 2FA. In API
 *   circumstances, an additional secret-signed HMAC token may be required. Consult method documentation for more info.
 *
 * - `authorization_mode`: Governs the principal types that can invoke a given RPC method. Some methods are only able to
 *   be invoked by end-users or within an org-wide circumstance. See the `AuthorizationMode` enum for more information.
 *
 * - `require_tenant`: Require the presence of tenant authorization information on a request, regardless of the mode of
 *   the request (so, this does apply to `USER` credentials). In the case of `USER` credentials, a tenant `MAY` be
 *   specified explicitly; if none is specified, the default tenant for the user is used. If no default tenant exists
 *   for the user, an error is returned.
 *
 * - `permission`: Describes the minimum generalized permission level that is required to execute a given RPC method.
 *   The end-user invoking a request must be granted a role which corresponds *at least* with this permission. This
 *   concept only applies within the context of `USER`-type credentials.
 * </pre>
 *
 * Protobuf type {@code buildless.api.MethodAuthorization}
 */
public final class MethodAuthorization extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:buildless.api.MethodAuthorization)
    MethodAuthorizationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use MethodAuthorization.newBuilder() to construct.
  private MethodAuthorization(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private MethodAuthorization() {
    mode_ = 0;
    permission_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new MethodAuthorization();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.buildless.api.MetaProto.internal_static_buildless_api_MethodAuthorization_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.buildless.api.MetaProto.internal_static_buildless_api_MethodAuthorization_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.buildless.api.MethodAuthorization.class, com.buildless.api.MethodAuthorization.Builder.class);
  }

  public static final int ALLOW_ANONYMOUS_FIELD_NUMBER = 1;
  private boolean allowAnonymous_ = false;
  /**
   * <pre>
   * Allow anonymous invocations (i.e. invocations with no credentials present).
   * </pre>
   *
   * <code>bool allow_anonymous = 1 [json_name = "allowAnonymous"];</code>
   * @return The allowAnonymous.
   */
  @java.lang.Override
  public boolean getAllowAnonymous() {
    return allowAnonymous_;
  }

  public static final int ALLOW_PUBLISHABLE_FIELD_NUMBER = 2;
  private boolean allowPublishable_ = false;
  /**
   * <pre>
   * Allow the use of "publishable" API keys.
   * </pre>
   *
   * <code>bool allow_publishable = 2 [json_name = "allowPublishable"];</code>
   * @return The allowPublishable.
   */
  @java.lang.Override
  public boolean getAllowPublishable() {
    return allowPublishable_;
  }

  public static final int REQUIRE_TOKEN_FIELD_NUMBER = 3;
  private boolean requireToken_ = false;
  /**
   * <pre>
   * Require a valid end-user authorization token, or signed session, to be present on the request.
   * </pre>
   *
   * <code>bool require_token = 3 [json_name = "requireToken"];</code>
   * @return The requireToken.
   */
  @java.lang.Override
  public boolean getRequireToken() {
    return requireToken_;
  }

  public static final int SENSITIVE_FIELD_NUMBER = 4;
  private boolean sensitive_ = false;
  /**
   * <pre>
   * Mark the method as a "sensitive" operation.
   * </pre>
   *
   * <code>bool sensitive = 4 [json_name = "sensitive"];</code>
   * @return The sensitive.
   */
  @java.lang.Override
  public boolean getSensitive() {
    return sensitive_;
  }

  public static final int MODE_FIELD_NUMBER = 5;
  private int mode_ = 0;
  /**
   * <pre>
   * Governs the principal types that can invoke a given RPC method.
   * </pre>
   *
   * <code>.buildless.api.AuthorizationMode mode = 5 [json_name = "mode"];</code>
   * @return The enum numeric value on the wire for mode.
   */
  @java.lang.Override public int getModeValue() {
    return mode_;
  }
  /**
   * <pre>
   * Governs the principal types that can invoke a given RPC method.
   * </pre>
   *
   * <code>.buildless.api.AuthorizationMode mode = 5 [json_name = "mode"];</code>
   * @return The mode.
   */
  @java.lang.Override public com.buildless.api.AuthorizationMode getMode() {
    com.buildless.api.AuthorizationMode result = com.buildless.api.AuthorizationMode.forNumber(mode_);
    return result == null ? com.buildless.api.AuthorizationMode.UNRECOGNIZED : result;
  }

  public static final int REQUIRE_TENANT_FIELD_NUMBER = 6;
  private boolean requireTenant_ = false;
  /**
   * <pre>
   * Require the presence of tenant authorization information on a request, regardless of the mode of the request.
   * </pre>
   *
   * <code>bool require_tenant = 6 [json_name = "requireTenant"];</code>
   * @return The requireTenant.
   */
  @java.lang.Override
  public boolean getRequireTenant() {
    return requireTenant_;
  }

  public static final int PERMISSION_FIELD_NUMBER = 7;
  private int permission_ = 0;
  /**
   * <pre>
   * Describes the minimum generalized permission level that is required to execute a given RPC method.
   * </pre>
   *
   * <code>.buildless.api.PermissionLevel permission = 7 [json_name = "permission"];</code>
   * @return The enum numeric value on the wire for permission.
   */
  @java.lang.Override public int getPermissionValue() {
    return permission_;
  }
  /**
   * <pre>
   * Describes the minimum generalized permission level that is required to execute a given RPC method.
   * </pre>
   *
   * <code>.buildless.api.PermissionLevel permission = 7 [json_name = "permission"];</code>
   * @return The permission.
   */
  @java.lang.Override public com.buildless.api.PermissionLevel getPermission() {
    com.buildless.api.PermissionLevel result = com.buildless.api.PermissionLevel.forNumber(permission_);
    return result == null ? com.buildless.api.PermissionLevel.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (allowAnonymous_ != false) {
      output.writeBool(1, allowAnonymous_);
    }
    if (allowPublishable_ != false) {
      output.writeBool(2, allowPublishable_);
    }
    if (requireToken_ != false) {
      output.writeBool(3, requireToken_);
    }
    if (sensitive_ != false) {
      output.writeBool(4, sensitive_);
    }
    if (mode_ != com.buildless.api.AuthorizationMode.AUTHORIZATION_DEFAULT.getNumber()) {
      output.writeEnum(5, mode_);
    }
    if (requireTenant_ != false) {
      output.writeBool(6, requireTenant_);
    }
    if (permission_ != com.buildless.api.PermissionLevel.PERMISSION_LEVEL_DEFAULT.getNumber()) {
      output.writeEnum(7, permission_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (allowAnonymous_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(1, allowAnonymous_);
    }
    if (allowPublishable_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(2, allowPublishable_);
    }
    if (requireToken_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(3, requireToken_);
    }
    if (sensitive_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(4, sensitive_);
    }
    if (mode_ != com.buildless.api.AuthorizationMode.AUTHORIZATION_DEFAULT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(5, mode_);
    }
    if (requireTenant_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(6, requireTenant_);
    }
    if (permission_ != com.buildless.api.PermissionLevel.PERMISSION_LEVEL_DEFAULT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(7, permission_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.buildless.api.MethodAuthorization)) {
      return super.equals(obj);
    }
    com.buildless.api.MethodAuthorization other = (com.buildless.api.MethodAuthorization) obj;

    if (getAllowAnonymous()
        != other.getAllowAnonymous()) return false;
    if (getAllowPublishable()
        != other.getAllowPublishable()) return false;
    if (getRequireToken()
        != other.getRequireToken()) return false;
    if (getSensitive()
        != other.getSensitive()) return false;
    if (mode_ != other.mode_) return false;
    if (getRequireTenant()
        != other.getRequireTenant()) return false;
    if (permission_ != other.permission_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ALLOW_ANONYMOUS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getAllowAnonymous());
    hash = (37 * hash) + ALLOW_PUBLISHABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getAllowPublishable());
    hash = (37 * hash) + REQUIRE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getRequireToken());
    hash = (37 * hash) + SENSITIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getSensitive());
    hash = (37 * hash) + MODE_FIELD_NUMBER;
    hash = (53 * hash) + mode_;
    hash = (37 * hash) + REQUIRE_TENANT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getRequireTenant());
    hash = (37 * hash) + PERMISSION_FIELD_NUMBER;
    hash = (53 * hash) + permission_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.buildless.api.MethodAuthorization parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.buildless.api.MethodAuthorization parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.buildless.api.MethodAuthorization parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.buildless.api.MethodAuthorization parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.buildless.api.MethodAuthorization prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * ## Method Authorization
   *
   * Specifies authorization configuration for a given RPC method provided by a Buildless API service. Settings on this
   * configuration are enforced by interceptors on behalf of the service under invocation. Proto-methods may be annotated
   * with these settings via the `buildless.api.authz` coordinate.
   *
   * ### Anonymous Access
   *
   * If the `anonymous_access` flag is set, the method is allowed to be invoked without any credentials present at all. In
   * this case, it is up to the method implementation to enforce second-order auth. There are two application features
   * where this is useful:
   *
   * - **Open methods.** Some methods (for example, `AppInfo`) return publicly-available information, and don't need to
   *   perform authorization steps. In this context, authorization may be wasteful.
   *
   * - **Anonymous-enabled methods.** Some methods (for example, cache access) can be opened up for public access on a
   *   policy basis by authorized users. In this case, the method implementation is responsible for enforcing second-order
   *   authorization state; for example, enforcing authorization state if-and-only-if the project under access demands it.
   *
   * ### Publishable API Keys
   *
   * "Publishable" API keys are keys which are safe to publish. These keys are typically used for non-sensitive or write-
   * only operations, like telemetry submission. If the `publishable` flag is set, interceptors will allow invocations
   * which specify a publishable key. By default, publishable keys are not allowed on any method.
   *
   * ### Authorization Behavior
   *
   * After enforcing the policies defined on this record, interceptors will mount resulting credential material within the
   * execution context for the invocation. Implementations may then access these values via well-typed context keys. See
   * the `CallMetadata` file for more information.
   *
   * Guarantees provided by this implementation:
   *
   * - **Values are well-formed.** If a value is read by the interceptor at all, it is well-formed. Downstream consumers
   *   may assume that the value has been validated statically to a reasonable extent.
   *
   * - **Values are semantically valid.** If a value is read by the interceptor, it is used properly and in the right
   *   "place" (the right header, context, etc). Downstream consumers need not verify the value's use semantics.
   *
   * - **Values are verified.** At the point a method invocation begins, all relevant authorization material has already
   *   been calculated and enforced. Downstream consumers do not need to look up user or tenant records, for example, to
   *   make sure they exist.
   *
   * ### Exhaustive settings list
   *
   * - `allow_anonymous`: Allow anonymous invocations (i.e. invocations with no credentials present). **Danger:** When
   *   this option is set, authorization steps `MUST` be performed by the implementation, as applicable.
   *
   * - `allow_publishable`: Allow the use of "publishable" API keys. **Danger:** When this option is set, API keys may be
   *   used which are intended to be published. The end-client may not be an explicitly-authorized user.
   *
   * - `require_token`: Require a valid end-user authorization token, or signed session, to be present on the request. In
   *   this mode, `USER` authorization mode is implied.
   *
   * - `sensitive`: Mark the method as a "sensitive" operation. In this case, an additional authorization step may be
   *   required; in some circumstances, this may be a "sudo" upgrade of a user's session, for instance, using 2FA. In API
   *   circumstances, an additional secret-signed HMAC token may be required. Consult method documentation for more info.
   *
   * - `authorization_mode`: Governs the principal types that can invoke a given RPC method. Some methods are only able to
   *   be invoked by end-users or within an org-wide circumstance. See the `AuthorizationMode` enum for more information.
   *
   * - `require_tenant`: Require the presence of tenant authorization information on a request, regardless of the mode of
   *   the request (so, this does apply to `USER` credentials). In the case of `USER` credentials, a tenant `MAY` be
   *   specified explicitly; if none is specified, the default tenant for the user is used. If no default tenant exists
   *   for the user, an error is returned.
   *
   * - `permission`: Describes the minimum generalized permission level that is required to execute a given RPC method.
   *   The end-user invoking a request must be granted a role which corresponds *at least* with this permission. This
   *   concept only applies within the context of `USER`-type credentials.
   * </pre>
   *
   * Protobuf type {@code buildless.api.MethodAuthorization}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:buildless.api.MethodAuthorization)
      com.buildless.api.MethodAuthorizationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.buildless.api.MetaProto.internal_static_buildless_api_MethodAuthorization_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.buildless.api.MetaProto.internal_static_buildless_api_MethodAuthorization_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.buildless.api.MethodAuthorization.class, com.buildless.api.MethodAuthorization.Builder.class);
    }

    // Construct using com.buildless.api.MethodAuthorization.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allowAnonymous_ = false;
      allowPublishable_ = false;
      requireToken_ = false;
      sensitive_ = false;
      mode_ = 0;
      requireTenant_ = false;
      permission_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.buildless.api.MetaProto.internal_static_buildless_api_MethodAuthorization_descriptor;
    }

    @java.lang.Override
    public com.buildless.api.MethodAuthorization getDefaultInstanceForType() {
      return com.buildless.api.MethodAuthorization.getDefaultInstance();
    }

    @java.lang.Override
    public com.buildless.api.MethodAuthorization build() {
      com.buildless.api.MethodAuthorization result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.buildless.api.MethodAuthorization buildPartial() {
      com.buildless.api.MethodAuthorization result = new com.buildless.api.MethodAuthorization(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.buildless.api.MethodAuthorization result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.allowAnonymous_ = allowAnonymous_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.allowPublishable_ = allowPublishable_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requireToken_ = requireToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sensitive_ = sensitive_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.mode_ = mode_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.requireTenant_ = requireTenant_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.permission_ = permission_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.buildless.api.MethodAuthorization) {
        return mergeFrom((com.buildless.api.MethodAuthorization)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.buildless.api.MethodAuthorization other) {
      if (other == com.buildless.api.MethodAuthorization.getDefaultInstance()) return this;
      if (other.getAllowAnonymous() != false) {
        setAllowAnonymous(other.getAllowAnonymous());
      }
      if (other.getAllowPublishable() != false) {
        setAllowPublishable(other.getAllowPublishable());
      }
      if (other.getRequireToken() != false) {
        setRequireToken(other.getRequireToken());
      }
      if (other.getSensitive() != false) {
        setSensitive(other.getSensitive());
      }
      if (other.mode_ != 0) {
        setModeValue(other.getModeValue());
      }
      if (other.getRequireTenant() != false) {
        setRequireTenant(other.getRequireTenant());
      }
      if (other.permission_ != 0) {
        setPermissionValue(other.getPermissionValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              allowAnonymous_ = input.readBool();
              bitField0_ |= 0x00000001;
              break;
            } // case 8
            case 16: {
              allowPublishable_ = input.readBool();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              requireToken_ = input.readBool();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 32: {
              sensitive_ = input.readBool();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 40: {
              mode_ = input.readEnum();
              bitField0_ |= 0x00000010;
              break;
            } // case 40
            case 48: {
              requireTenant_ = input.readBool();
              bitField0_ |= 0x00000020;
              break;
            } // case 48
            case 56: {
              permission_ = input.readEnum();
              bitField0_ |= 0x00000040;
              break;
            } // case 56
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private boolean allowAnonymous_ ;
    /**
     * <pre>
     * Allow anonymous invocations (i.e. invocations with no credentials present).
     * </pre>
     *
     * <code>bool allow_anonymous = 1 [json_name = "allowAnonymous"];</code>
     * @return The allowAnonymous.
     */
    @java.lang.Override
    public boolean getAllowAnonymous() {
      return allowAnonymous_;
    }
    /**
     * <pre>
     * Allow anonymous invocations (i.e. invocations with no credentials present).
     * </pre>
     *
     * <code>bool allow_anonymous = 1 [json_name = "allowAnonymous"];</code>
     * @param value The allowAnonymous to set.
     * @return This builder for chaining.
     */
    public Builder setAllowAnonymous(boolean value) {

      allowAnonymous_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allow anonymous invocations (i.e. invocations with no credentials present).
     * </pre>
     *
     * <code>bool allow_anonymous = 1 [json_name = "allowAnonymous"];</code>
     * @return This builder for chaining.
     */
    public Builder clearAllowAnonymous() {
      bitField0_ = (bitField0_ & ~0x00000001);
      allowAnonymous_ = false;
      onChanged();
      return this;
    }

    private boolean allowPublishable_ ;
    /**
     * <pre>
     * Allow the use of "publishable" API keys.
     * </pre>
     *
     * <code>bool allow_publishable = 2 [json_name = "allowPublishable"];</code>
     * @return The allowPublishable.
     */
    @java.lang.Override
    public boolean getAllowPublishable() {
      return allowPublishable_;
    }
    /**
     * <pre>
     * Allow the use of "publishable" API keys.
     * </pre>
     *
     * <code>bool allow_publishable = 2 [json_name = "allowPublishable"];</code>
     * @param value The allowPublishable to set.
     * @return This builder for chaining.
     */
    public Builder setAllowPublishable(boolean value) {

      allowPublishable_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allow the use of "publishable" API keys.
     * </pre>
     *
     * <code>bool allow_publishable = 2 [json_name = "allowPublishable"];</code>
     * @return This builder for chaining.
     */
    public Builder clearAllowPublishable() {
      bitField0_ = (bitField0_ & ~0x00000002);
      allowPublishable_ = false;
      onChanged();
      return this;
    }

    private boolean requireToken_ ;
    /**
     * <pre>
     * Require a valid end-user authorization token, or signed session, to be present on the request.
     * </pre>
     *
     * <code>bool require_token = 3 [json_name = "requireToken"];</code>
     * @return The requireToken.
     */
    @java.lang.Override
    public boolean getRequireToken() {
      return requireToken_;
    }
    /**
     * <pre>
     * Require a valid end-user authorization token, or signed session, to be present on the request.
     * </pre>
     *
     * <code>bool require_token = 3 [json_name = "requireToken"];</code>
     * @param value The requireToken to set.
     * @return This builder for chaining.
     */
    public Builder setRequireToken(boolean value) {

      requireToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Require a valid end-user authorization token, or signed session, to be present on the request.
     * </pre>
     *
     * <code>bool require_token = 3 [json_name = "requireToken"];</code>
     * @return This builder for chaining.
     */
    public Builder clearRequireToken() {
      bitField0_ = (bitField0_ & ~0x00000004);
      requireToken_ = false;
      onChanged();
      return this;
    }

    private boolean sensitive_ ;
    /**
     * <pre>
     * Mark the method as a "sensitive" operation.
     * </pre>
     *
     * <code>bool sensitive = 4 [json_name = "sensitive"];</code>
     * @return The sensitive.
     */
    @java.lang.Override
    public boolean getSensitive() {
      return sensitive_;
    }
    /**
     * <pre>
     * Mark the method as a "sensitive" operation.
     * </pre>
     *
     * <code>bool sensitive = 4 [json_name = "sensitive"];</code>
     * @param value The sensitive to set.
     * @return This builder for chaining.
     */
    public Builder setSensitive(boolean value) {

      sensitive_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Mark the method as a "sensitive" operation.
     * </pre>
     *
     * <code>bool sensitive = 4 [json_name = "sensitive"];</code>
     * @return This builder for chaining.
     */
    public Builder clearSensitive() {
      bitField0_ = (bitField0_ & ~0x00000008);
      sensitive_ = false;
      onChanged();
      return this;
    }

    private int mode_ = 0;
    /**
     * <pre>
     * Governs the principal types that can invoke a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.AuthorizationMode mode = 5 [json_name = "mode"];</code>
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override public int getModeValue() {
      return mode_;
    }
    /**
     * <pre>
     * Governs the principal types that can invoke a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.AuthorizationMode mode = 5 [json_name = "mode"];</code>
     * @param value The enum numeric value on the wire for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeValue(int value) {
      mode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Governs the principal types that can invoke a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.AuthorizationMode mode = 5 [json_name = "mode"];</code>
     * @return The mode.
     */
    @java.lang.Override
    public com.buildless.api.AuthorizationMode getMode() {
      com.buildless.api.AuthorizationMode result = com.buildless.api.AuthorizationMode.forNumber(mode_);
      return result == null ? com.buildless.api.AuthorizationMode.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Governs the principal types that can invoke a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.AuthorizationMode mode = 5 [json_name = "mode"];</code>
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(com.buildless.api.AuthorizationMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      mode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Governs the principal types that can invoke a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.AuthorizationMode mode = 5 [json_name = "mode"];</code>
     * @return This builder for chaining.
     */
    public Builder clearMode() {
      bitField0_ = (bitField0_ & ~0x00000010);
      mode_ = 0;
      onChanged();
      return this;
    }

    private boolean requireTenant_ ;
    /**
     * <pre>
     * Require the presence of tenant authorization information on a request, regardless of the mode of the request.
     * </pre>
     *
     * <code>bool require_tenant = 6 [json_name = "requireTenant"];</code>
     * @return The requireTenant.
     */
    @java.lang.Override
    public boolean getRequireTenant() {
      return requireTenant_;
    }
    /**
     * <pre>
     * Require the presence of tenant authorization information on a request, regardless of the mode of the request.
     * </pre>
     *
     * <code>bool require_tenant = 6 [json_name = "requireTenant"];</code>
     * @param value The requireTenant to set.
     * @return This builder for chaining.
     */
    public Builder setRequireTenant(boolean value) {

      requireTenant_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Require the presence of tenant authorization information on a request, regardless of the mode of the request.
     * </pre>
     *
     * <code>bool require_tenant = 6 [json_name = "requireTenant"];</code>
     * @return This builder for chaining.
     */
    public Builder clearRequireTenant() {
      bitField0_ = (bitField0_ & ~0x00000020);
      requireTenant_ = false;
      onChanged();
      return this;
    }

    private int permission_ = 0;
    /**
     * <pre>
     * Describes the minimum generalized permission level that is required to execute a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.PermissionLevel permission = 7 [json_name = "permission"];</code>
     * @return The enum numeric value on the wire for permission.
     */
    @java.lang.Override public int getPermissionValue() {
      return permission_;
    }
    /**
     * <pre>
     * Describes the minimum generalized permission level that is required to execute a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.PermissionLevel permission = 7 [json_name = "permission"];</code>
     * @param value The enum numeric value on the wire for permission to set.
     * @return This builder for chaining.
     */
    public Builder setPermissionValue(int value) {
      permission_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Describes the minimum generalized permission level that is required to execute a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.PermissionLevel permission = 7 [json_name = "permission"];</code>
     * @return The permission.
     */
    @java.lang.Override
    public com.buildless.api.PermissionLevel getPermission() {
      com.buildless.api.PermissionLevel result = com.buildless.api.PermissionLevel.forNumber(permission_);
      return result == null ? com.buildless.api.PermissionLevel.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Describes the minimum generalized permission level that is required to execute a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.PermissionLevel permission = 7 [json_name = "permission"];</code>
     * @param value The permission to set.
     * @return This builder for chaining.
     */
    public Builder setPermission(com.buildless.api.PermissionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      permission_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Describes the minimum generalized permission level that is required to execute a given RPC method.
     * </pre>
     *
     * <code>.buildless.api.PermissionLevel permission = 7 [json_name = "permission"];</code>
     * @return This builder for chaining.
     */
    public Builder clearPermission() {
      bitField0_ = (bitField0_ & ~0x00000040);
      permission_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:buildless.api.MethodAuthorization)
  }

  // @@protoc_insertion_point(class_scope:buildless.api.MethodAuthorization)
  private static final com.buildless.api.MethodAuthorization DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.buildless.api.MethodAuthorization();
  }

  public static com.buildless.api.MethodAuthorization getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MethodAuthorization>
      PARSER = new com.google.protobuf.AbstractParser<MethodAuthorization>() {
    @java.lang.Override
    public MethodAuthorization parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<MethodAuthorization> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MethodAuthorization> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.buildless.api.MethodAuthorization getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

