// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: buildless/common.proto

package com.buildless;

/**
 * <pre>
 * ## Tenant
 *
 * Specifies an organization tenant record within Buildless. Organization tenants are the top-most level of user data
 * within the system. All user accounts are eligible to be members of a given tenant.
 *
 * Each tenant (also known as an "organization" or "team") has a unique set of identifiers, and within the scope of that
 * tenant, all organization data is owned. If a tenant is deactivated, all resources associated with that tenant are
 * henceforth inaccessible, and later scheduled for deletion. Settings, permissions, and analytics all roll up at the
 * top-most level of a tenant.
 *
 * See also: `User`, `Account`.
 * </pre>
 *
 * Protobuf type {@code buildless.Tenant}
 */
public final class Tenant extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:buildless.Tenant)
    TenantOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Tenant.newBuilder() to construct.
  private Tenant(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Tenant() {
    uuid_ = "";
    name_ = "";
    displayName_ = "";
    domain_ = java.util.Collections.emptyList();
    authId_ = "";
    repoProvider_ = 0;
    repoProviderOrg_ = "";
    directoryOrgLive_ = "";
    directoryOrgSandbox_ = "";
    subscriptionId_ = "";
    locale_ = "";
    timezone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Tenant();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.buildless.CommonProto.internal_static_buildless_Tenant_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.buildless.CommonProto.internal_static_buildless_Tenant_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.buildless.Tenant.class, com.buildless.Tenant.Builder.class);
  }

  public interface TenantKeyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:buildless.Tenant.TenantKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies a unique number for the tenant, which is generated at the time the tenant is first stored with
     * Buildless. The tenant ID is considered an opaque value and should not be inspected. Globally unique.
     * </pre>
     *
     * <code>uint64 tenant_id = 1 [json_name = "tenantId", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     * @return The tenantId.
     */
    long getTenantId();
  }
  /**
   * <pre>
   * ## Tenant Key
   *
   * Specifies the unique key material associated with a Buildless `Tenant` record. Tenants are stored by their numeric
   * `tenant_id` and `uuid`, both of which must be globally unique.
   * </pre>
   *
   * Protobuf type {@code buildless.Tenant.TenantKey}
   */
  public static final class TenantKey extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:buildless.Tenant.TenantKey)
      TenantKeyOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TenantKey.newBuilder() to construct.
    private TenantKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TenantKey() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TenantKey();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.buildless.Tenant.TenantKey.class, com.buildless.Tenant.TenantKey.Builder.class);
    }

    public static final int TENANT_ID_FIELD_NUMBER = 1;
    private long tenantId_ = 0L;
    /**
     * <pre>
     * Specifies a unique number for the tenant, which is generated at the time the tenant is first stored with
     * Buildless. The tenant ID is considered an opaque value and should not be inspected. Globally unique.
     * </pre>
     *
     * <code>uint64 tenant_id = 1 [json_name = "tenantId", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     * @return The tenantId.
     */
    @java.lang.Override
    public long getTenantId() {
      return tenantId_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (tenantId_ != 0L) {
        output.writeUInt64(1, tenantId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (tenantId_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, tenantId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.buildless.Tenant.TenantKey)) {
        return super.equals(obj);
      }
      com.buildless.Tenant.TenantKey other = (com.buildless.Tenant.TenantKey) obj;

      if (getTenantId()
          != other.getTenantId()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TENANT_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getTenantId());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.buildless.Tenant.TenantKey parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.buildless.Tenant.TenantKey parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.buildless.Tenant.TenantKey parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.buildless.Tenant.TenantKey parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.buildless.Tenant.TenantKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * ## Tenant Key
     *
     * Specifies the unique key material associated with a Buildless `Tenant` record. Tenants are stored by their numeric
     * `tenant_id` and `uuid`, both of which must be globally unique.
     * </pre>
     *
     * Protobuf type {@code buildless.Tenant.TenantKey}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:buildless.Tenant.TenantKey)
        com.buildless.Tenant.TenantKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.buildless.Tenant.TenantKey.class, com.buildless.Tenant.TenantKey.Builder.class);
      }

      // Construct using com.buildless.Tenant.TenantKey.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        tenantId_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantKey_descriptor;
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantKey getDefaultInstanceForType() {
        return com.buildless.Tenant.TenantKey.getDefaultInstance();
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantKey build() {
        com.buildless.Tenant.TenantKey result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantKey buildPartial() {
        com.buildless.Tenant.TenantKey result = new com.buildless.Tenant.TenantKey(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.buildless.Tenant.TenantKey result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.tenantId_ = tenantId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.buildless.Tenant.TenantKey) {
          return mergeFrom((com.buildless.Tenant.TenantKey)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.buildless.Tenant.TenantKey other) {
        if (other == com.buildless.Tenant.TenantKey.getDefaultInstance()) return this;
        if (other.getTenantId() != 0L) {
          setTenantId(other.getTenantId());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                tenantId_ = input.readUInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private long tenantId_ ;
      /**
       * <pre>
       * Specifies a unique number for the tenant, which is generated at the time the tenant is first stored with
       * Buildless. The tenant ID is considered an opaque value and should not be inspected. Globally unique.
       * </pre>
       *
       * <code>uint64 tenant_id = 1 [json_name = "tenantId", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
       * @return The tenantId.
       */
      @java.lang.Override
      public long getTenantId() {
        return tenantId_;
      }
      /**
       * <pre>
       * Specifies a unique number for the tenant, which is generated at the time the tenant is first stored with
       * Buildless. The tenant ID is considered an opaque value and should not be inspected. Globally unique.
       * </pre>
       *
       * <code>uint64 tenant_id = 1 [json_name = "tenantId", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
       * @param value The tenantId to set.
       * @return This builder for chaining.
       */
      public Builder setTenantId(long value) {

        tenantId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies a unique number for the tenant, which is generated at the time the tenant is first stored with
       * Buildless. The tenant ID is considered an opaque value and should not be inspected. Globally unique.
       * </pre>
       *
       * <code>uint64 tenant_id = 1 [json_name = "tenantId", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearTenantId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        tenantId_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:buildless.Tenant.TenantKey)
    }

    // @@protoc_insertion_point(class_scope:buildless.Tenant.TenantKey)
    private static final com.buildless.Tenant.TenantKey DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.buildless.Tenant.TenantKey();
    }

    public static com.buildless.Tenant.TenantKey getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TenantKey>
        PARSER = new com.google.protobuf.AbstractParser<TenantKey>() {
      @java.lang.Override
      public TenantKey parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TenantKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TenantKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.buildless.Tenant.TenantKey getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TenantBrandingOrBuilder extends
      // @@protoc_insertion_point(interface_extends:buildless.Tenant.TenantBranding)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
     * circumstances where a square graphic is needed.
     * </pre>
     *
     * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
     * @return The icon.
     */
    java.lang.String getIcon();
    /**
     * <pre>
     * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
     * circumstances where a square graphic is needed.
     * </pre>
     *
     * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
     * @return The bytes for icon.
     */
    com.google.protobuf.ByteString
        getIconBytes();

    /**
     * <pre>
     * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
     * circumstances where a wide graphic is needed.
     * </pre>
     *
     * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
     * @return The logo.
     */
    java.lang.String getLogo();
    /**
     * <pre>
     * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
     * circumstances where a wide graphic is needed.
     * </pre>
     *
     * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
     * @return The bytes for logo.
     */
    com.google.protobuf.ByteString
        getLogoBytes();

    /**
     * <pre>
     * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return Whether the light field is set.
     */
    boolean hasLight();
    /**
     * <pre>
     * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The light.
     */
    com.buildless.Tenant.TenantBranding.TenantColors getLight();
    /**
     * <pre>
     * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder getLightOrBuilder();

    /**
     * <pre>
     * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return Whether the dark field is set.
     */
    boolean hasDark();
    /**
     * <pre>
     * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The dark.
     */
    com.buildless.Tenant.TenantBranding.TenantColors getDark();
    /**
     * <pre>
     * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder getDarkOrBuilder();
  }
  /**
   * <pre>
   * ### Tenant Branding
   *
   * Specifies customization/branding info for a given tenant. If supported, this information is used to customize the
   * UI for members of a given tenant.
   * </pre>
   *
   * Protobuf type {@code buildless.Tenant.TenantBranding}
   */
  public static final class TenantBranding extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:buildless.Tenant.TenantBranding)
      TenantBrandingOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TenantBranding.newBuilder() to construct.
    private TenantBranding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TenantBranding() {
      icon_ = "";
      logo_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TenantBranding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.buildless.Tenant.TenantBranding.class, com.buildless.Tenant.TenantBranding.Builder.class);
    }

    public interface TenantColorsOrBuilder extends
        // @@protoc_insertion_point(interface_extends:buildless.Tenant.TenantBranding.TenantColors)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Primary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
       * @return Whether the primary field is set.
       */
      boolean hasPrimary();
      /**
       * <pre>
       * Primary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
       * @return The primary.
       */
      com.google.type.Color getPrimary();
      /**
       * <pre>
       * Primary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
       */
      com.google.type.ColorOrBuilder getPrimaryOrBuilder();

      /**
       * <pre>
       * Secondary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
       * @return Whether the secondary field is set.
       */
      boolean hasSecondary();
      /**
       * <pre>
       * Secondary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
       * @return The secondary.
       */
      com.google.type.Color getSecondary();
      /**
       * <pre>
       * Secondary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
       */
      com.google.type.ColorOrBuilder getSecondaryOrBuilder();
    }
    /**
     * <pre>
     * #### Tenant: Color Scheme
     *
     * Specifies a `primary` and `secondary` color, typically in hex. The primary and secondary colors for a given color
     * scheme are applied either in `dark` or `light` mode.
     * </pre>
     *
     * Protobuf type {@code buildless.Tenant.TenantBranding.TenantColors}
     */
    public static final class TenantColors extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:buildless.Tenant.TenantBranding.TenantColors)
        TenantColorsOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use TenantColors.newBuilder() to construct.
      private TenantColors(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private TenantColors() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new TenantColors();
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_TenantColors_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_TenantColors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.buildless.Tenant.TenantBranding.TenantColors.class, com.buildless.Tenant.TenantBranding.TenantColors.Builder.class);
      }

      public static final int PRIMARY_FIELD_NUMBER = 1;
      private com.google.type.Color primary_;
      /**
       * <pre>
       * Primary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
       * @return Whether the primary field is set.
       */
      @java.lang.Override
      public boolean hasPrimary() {
        return primary_ != null;
      }
      /**
       * <pre>
       * Primary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
       * @return The primary.
       */
      @java.lang.Override
      public com.google.type.Color getPrimary() {
        return primary_ == null ? com.google.type.Color.getDefaultInstance() : primary_;
      }
      /**
       * <pre>
       * Primary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
       */
      @java.lang.Override
      public com.google.type.ColorOrBuilder getPrimaryOrBuilder() {
        return primary_ == null ? com.google.type.Color.getDefaultInstance() : primary_;
      }

      public static final int SECONDARY_FIELD_NUMBER = 2;
      private com.google.type.Color secondary_;
      /**
       * <pre>
       * Secondary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
       * @return Whether the secondary field is set.
       */
      @java.lang.Override
      public boolean hasSecondary() {
        return secondary_ != null;
      }
      /**
       * <pre>
       * Secondary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
       * @return The secondary.
       */
      @java.lang.Override
      public com.google.type.Color getSecondary() {
        return secondary_ == null ? com.google.type.Color.getDefaultInstance() : secondary_;
      }
      /**
       * <pre>
       * Secondary color value, expressed as a CSS-compatible color value.
       * </pre>
       *
       * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
       */
      @java.lang.Override
      public com.google.type.ColorOrBuilder getSecondaryOrBuilder() {
        return secondary_ == null ? com.google.type.Color.getDefaultInstance() : secondary_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (primary_ != null) {
          output.writeMessage(1, getPrimary());
        }
        if (secondary_ != null) {
          output.writeMessage(2, getSecondary());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (primary_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getPrimary());
        }
        if (secondary_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getSecondary());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.buildless.Tenant.TenantBranding.TenantColors)) {
          return super.equals(obj);
        }
        com.buildless.Tenant.TenantBranding.TenantColors other = (com.buildless.Tenant.TenantBranding.TenantColors) obj;

        if (hasPrimary() != other.hasPrimary()) return false;
        if (hasPrimary()) {
          if (!getPrimary()
              .equals(other.getPrimary())) return false;
        }
        if (hasSecondary() != other.hasSecondary()) return false;
        if (hasSecondary()) {
          if (!getSecondary()
              .equals(other.getSecondary())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasPrimary()) {
          hash = (37 * hash) + PRIMARY_FIELD_NUMBER;
          hash = (53 * hash) + getPrimary().hashCode();
        }
        if (hasSecondary()) {
          hash = (37 * hash) + SECONDARY_FIELD_NUMBER;
          hash = (53 * hash) + getSecondary().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static com.buildless.Tenant.TenantBranding.TenantColors parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static com.buildless.Tenant.TenantBranding.TenantColors parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.buildless.Tenant.TenantBranding.TenantColors parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.buildless.Tenant.TenantBranding.TenantColors prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * #### Tenant: Color Scheme
       *
       * Specifies a `primary` and `secondary` color, typically in hex. The primary and secondary colors for a given color
       * scheme are applied either in `dark` or `light` mode.
       * </pre>
       *
       * Protobuf type {@code buildless.Tenant.TenantBranding.TenantColors}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:buildless.Tenant.TenantBranding.TenantColors)
          com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_TenantColors_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_TenantColors_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.buildless.Tenant.TenantBranding.TenantColors.class, com.buildless.Tenant.TenantBranding.TenantColors.Builder.class);
        }

        // Construct using com.buildless.Tenant.TenantBranding.TenantColors.newBuilder()
        private Builder() {

        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);

        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          primary_ = null;
          if (primaryBuilder_ != null) {
            primaryBuilder_.dispose();
            primaryBuilder_ = null;
          }
          secondary_ = null;
          if (secondaryBuilder_ != null) {
            secondaryBuilder_.dispose();
            secondaryBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_TenantColors_descriptor;
        }

        @java.lang.Override
        public com.buildless.Tenant.TenantBranding.TenantColors getDefaultInstanceForType() {
          return com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance();
        }

        @java.lang.Override
        public com.buildless.Tenant.TenantBranding.TenantColors build() {
          com.buildless.Tenant.TenantBranding.TenantColors result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.buildless.Tenant.TenantBranding.TenantColors buildPartial() {
          com.buildless.Tenant.TenantBranding.TenantColors result = new com.buildless.Tenant.TenantBranding.TenantColors(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.buildless.Tenant.TenantBranding.TenantColors result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.primary_ = primaryBuilder_ == null
                ? primary_
                : primaryBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.secondary_ = secondaryBuilder_ == null
                ? secondary_
                : secondaryBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.buildless.Tenant.TenantBranding.TenantColors) {
            return mergeFrom((com.buildless.Tenant.TenantBranding.TenantColors)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.buildless.Tenant.TenantBranding.TenantColors other) {
          if (other == com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance()) return this;
          if (other.hasPrimary()) {
            mergePrimary(other.getPrimary());
          }
          if (other.hasSecondary()) {
            mergeSecondary(other.getSecondary());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  input.readMessage(
                      getPrimaryFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  input.readMessage(
                      getSecondaryFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private com.google.type.Color primary_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder> primaryBuilder_;
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         * @return Whether the primary field is set.
         */
        public boolean hasPrimary() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         * @return The primary.
         */
        public com.google.type.Color getPrimary() {
          if (primaryBuilder_ == null) {
            return primary_ == null ? com.google.type.Color.getDefaultInstance() : primary_;
          } else {
            return primaryBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         */
        public Builder setPrimary(com.google.type.Color value) {
          if (primaryBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            primary_ = value;
          } else {
            primaryBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         */
        public Builder setPrimary(
            com.google.type.Color.Builder builderForValue) {
          if (primaryBuilder_ == null) {
            primary_ = builderForValue.build();
          } else {
            primaryBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         */
        public Builder mergePrimary(com.google.type.Color value) {
          if (primaryBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0) &&
              primary_ != null &&
              primary_ != com.google.type.Color.getDefaultInstance()) {
              getPrimaryBuilder().mergeFrom(value);
            } else {
              primary_ = value;
            }
          } else {
            primaryBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         */
        public Builder clearPrimary() {
          bitField0_ = (bitField0_ & ~0x00000001);
          primary_ = null;
          if (primaryBuilder_ != null) {
            primaryBuilder_.dispose();
            primaryBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         */
        public com.google.type.Color.Builder getPrimaryBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getPrimaryFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         */
        public com.google.type.ColorOrBuilder getPrimaryOrBuilder() {
          if (primaryBuilder_ != null) {
            return primaryBuilder_.getMessageOrBuilder();
          } else {
            return primary_ == null ?
                com.google.type.Color.getDefaultInstance() : primary_;
          }
        }
        /**
         * <pre>
         * Primary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color primary = 1 [json_name = "primary"];</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder> 
            getPrimaryFieldBuilder() {
          if (primaryBuilder_ == null) {
            primaryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>(
                    getPrimary(),
                    getParentForChildren(),
                    isClean());
            primary_ = null;
          }
          return primaryBuilder_;
        }

        private com.google.type.Color secondary_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder> secondaryBuilder_;
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         * @return Whether the secondary field is set.
         */
        public boolean hasSecondary() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         * @return The secondary.
         */
        public com.google.type.Color getSecondary() {
          if (secondaryBuilder_ == null) {
            return secondary_ == null ? com.google.type.Color.getDefaultInstance() : secondary_;
          } else {
            return secondaryBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         */
        public Builder setSecondary(com.google.type.Color value) {
          if (secondaryBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            secondary_ = value;
          } else {
            secondaryBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         */
        public Builder setSecondary(
            com.google.type.Color.Builder builderForValue) {
          if (secondaryBuilder_ == null) {
            secondary_ = builderForValue.build();
          } else {
            secondaryBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         */
        public Builder mergeSecondary(com.google.type.Color value) {
          if (secondaryBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              secondary_ != null &&
              secondary_ != com.google.type.Color.getDefaultInstance()) {
              getSecondaryBuilder().mergeFrom(value);
            } else {
              secondary_ = value;
            }
          } else {
            secondaryBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         */
        public Builder clearSecondary() {
          bitField0_ = (bitField0_ & ~0x00000002);
          secondary_ = null;
          if (secondaryBuilder_ != null) {
            secondaryBuilder_.dispose();
            secondaryBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         */
        public com.google.type.Color.Builder getSecondaryBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getSecondaryFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         */
        public com.google.type.ColorOrBuilder getSecondaryOrBuilder() {
          if (secondaryBuilder_ != null) {
            return secondaryBuilder_.getMessageOrBuilder();
          } else {
            return secondary_ == null ?
                com.google.type.Color.getDefaultInstance() : secondary_;
          }
        }
        /**
         * <pre>
         * Secondary color value, expressed as a CSS-compatible color value.
         * </pre>
         *
         * <code>.google.type.Color secondary = 2 [json_name = "secondary"];</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder> 
            getSecondaryFieldBuilder() {
          if (secondaryBuilder_ == null) {
            secondaryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>(
                    getSecondary(),
                    getParentForChildren(),
                    isClean());
            secondary_ = null;
          }
          return secondaryBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:buildless.Tenant.TenantBranding.TenantColors)
      }

      // @@protoc_insertion_point(class_scope:buildless.Tenant.TenantBranding.TenantColors)
      private static final com.buildless.Tenant.TenantBranding.TenantColors DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.buildless.Tenant.TenantBranding.TenantColors();
      }

      public static com.buildless.Tenant.TenantBranding.TenantColors getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TenantColors>
          PARSER = new com.google.protobuf.AbstractParser<TenantColors>() {
        @java.lang.Override
        public TenantColors parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<TenantColors> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TenantColors> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantBranding.TenantColors getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int ICON_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object icon_ = "";
    /**
     * <pre>
     * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
     * circumstances where a square graphic is needed.
     * </pre>
     *
     * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
     * @return The icon.
     */
    @java.lang.Override
    public java.lang.String getIcon() {
      java.lang.Object ref = icon_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        icon_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
     * circumstances where a square graphic is needed.
     * </pre>
     *
     * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
     * @return The bytes for icon.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getIconBytes() {
      java.lang.Object ref = icon_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        icon_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOGO_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object logo_ = "";
    /**
     * <pre>
     * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
     * circumstances where a wide graphic is needed.
     * </pre>
     *
     * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
     * @return The logo.
     */
    @java.lang.Override
    public java.lang.String getLogo() {
      java.lang.Object ref = logo_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logo_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
     * circumstances where a wide graphic is needed.
     * </pre>
     *
     * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
     * @return The bytes for logo.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getLogoBytes() {
      java.lang.Object ref = logo_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        logo_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LIGHT_FIELD_NUMBER = 3;
    private com.buildless.Tenant.TenantBranding.TenantColors light_;
    /**
     * <pre>
     * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return Whether the light field is set.
     */
    @java.lang.Override
    public boolean hasLight() {
      return light_ != null;
    }
    /**
     * <pre>
     * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The light.
     */
    @java.lang.Override
    public com.buildless.Tenant.TenantBranding.TenantColors getLight() {
      return light_ == null ? com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance() : light_;
    }
    /**
     * <pre>
     * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder getLightOrBuilder() {
      return light_ == null ? com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance() : light_;
    }

    public static final int DARK_FIELD_NUMBER = 4;
    private com.buildless.Tenant.TenantBranding.TenantColors dark_;
    /**
     * <pre>
     * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return Whether the dark field is set.
     */
    @java.lang.Override
    public boolean hasDark() {
      return dark_ != null;
    }
    /**
     * <pre>
     * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The dark.
     */
    @java.lang.Override
    public com.buildless.Tenant.TenantBranding.TenantColors getDark() {
      return dark_ == null ? com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance() : dark_;
    }
    /**
     * <pre>
     * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder getDarkOrBuilder() {
      return dark_ == null ? com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance() : dark_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(icon_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, icon_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logo_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, logo_);
      }
      if (light_ != null) {
        output.writeMessage(3, getLight());
      }
      if (dark_ != null) {
        output.writeMessage(4, getDark());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(icon_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, icon_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logo_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, logo_);
      }
      if (light_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getLight());
      }
      if (dark_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getDark());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.buildless.Tenant.TenantBranding)) {
        return super.equals(obj);
      }
      com.buildless.Tenant.TenantBranding other = (com.buildless.Tenant.TenantBranding) obj;

      if (!getIcon()
          .equals(other.getIcon())) return false;
      if (!getLogo()
          .equals(other.getLogo())) return false;
      if (hasLight() != other.hasLight()) return false;
      if (hasLight()) {
        if (!getLight()
            .equals(other.getLight())) return false;
      }
      if (hasDark() != other.hasDark()) return false;
      if (hasDark()) {
        if (!getDark()
            .equals(other.getDark())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ICON_FIELD_NUMBER;
      hash = (53 * hash) + getIcon().hashCode();
      hash = (37 * hash) + LOGO_FIELD_NUMBER;
      hash = (53 * hash) + getLogo().hashCode();
      if (hasLight()) {
        hash = (37 * hash) + LIGHT_FIELD_NUMBER;
        hash = (53 * hash) + getLight().hashCode();
      }
      if (hasDark()) {
        hash = (37 * hash) + DARK_FIELD_NUMBER;
        hash = (53 * hash) + getDark().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.buildless.Tenant.TenantBranding parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.buildless.Tenant.TenantBranding parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.buildless.Tenant.TenantBranding parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.buildless.Tenant.TenantBranding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.buildless.Tenant.TenantBranding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * ### Tenant Branding
     *
     * Specifies customization/branding info for a given tenant. If supported, this information is used to customize the
     * UI for members of a given tenant.
     * </pre>
     *
     * Protobuf type {@code buildless.Tenant.TenantBranding}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:buildless.Tenant.TenantBranding)
        com.buildless.Tenant.TenantBrandingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.buildless.Tenant.TenantBranding.class, com.buildless.Tenant.TenantBranding.Builder.class);
      }

      // Construct using com.buildless.Tenant.TenantBranding.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        icon_ = "";
        logo_ = "";
        light_ = null;
        if (lightBuilder_ != null) {
          lightBuilder_.dispose();
          lightBuilder_ = null;
        }
        dark_ = null;
        if (darkBuilder_ != null) {
          darkBuilder_.dispose();
          darkBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantBranding_descriptor;
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantBranding getDefaultInstanceForType() {
        return com.buildless.Tenant.TenantBranding.getDefaultInstance();
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantBranding build() {
        com.buildless.Tenant.TenantBranding result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantBranding buildPartial() {
        com.buildless.Tenant.TenantBranding result = new com.buildless.Tenant.TenantBranding(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.buildless.Tenant.TenantBranding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.icon_ = icon_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.logo_ = logo_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.light_ = lightBuilder_ == null
              ? light_
              : lightBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.dark_ = darkBuilder_ == null
              ? dark_
              : darkBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.buildless.Tenant.TenantBranding) {
          return mergeFrom((com.buildless.Tenant.TenantBranding)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.buildless.Tenant.TenantBranding other) {
        if (other == com.buildless.Tenant.TenantBranding.getDefaultInstance()) return this;
        if (!other.getIcon().isEmpty()) {
          icon_ = other.icon_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getLogo().isEmpty()) {
          logo_ = other.logo_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasLight()) {
          mergeLight(other.getLight());
        }
        if (other.hasDark()) {
          mergeDark(other.getDark());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                icon_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                logo_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getLightFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getDarkFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object icon_ = "";
      /**
       * <pre>
       * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
       * circumstances where a square graphic is needed.
       * </pre>
       *
       * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @return The icon.
       */
      public java.lang.String getIcon() {
        java.lang.Object ref = icon_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          icon_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
       * circumstances where a square graphic is needed.
       * </pre>
       *
       * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @return The bytes for icon.
       */
      public com.google.protobuf.ByteString
          getIconBytes() {
        java.lang.Object ref = icon_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          icon_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
       * circumstances where a square graphic is needed.
       * </pre>
       *
       * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @param value The icon to set.
       * @return This builder for chaining.
       */
      public Builder setIcon(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        icon_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
       * circumstances where a square graphic is needed.
       * </pre>
       *
       * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearIcon() {
        icon_ = getDefaultInstance().getIcon();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies an icon URL to use for this tenant branding payload. The icon URL is used as the favicon, and in other
       * circumstances where a square graphic is needed.
       * </pre>
       *
       * <code>string icon = 1 [json_name = "icon", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @param value The bytes for icon to set.
       * @return This builder for chaining.
       */
      public Builder setIconBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        icon_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object logo_ = "";
      /**
       * <pre>
       * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
       * circumstances where a wide graphic is needed.
       * </pre>
       *
       * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @return The logo.
       */
      public java.lang.String getLogo() {
        java.lang.Object ref = logo_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logo_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
       * circumstances where a wide graphic is needed.
       * </pre>
       *
       * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @return The bytes for logo.
       */
      public com.google.protobuf.ByteString
          getLogoBytes() {
        java.lang.Object ref = logo_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          logo_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
       * circumstances where a wide graphic is needed.
       * </pre>
       *
       * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @param value The logo to set.
       * @return This builder for chaining.
       */
      public Builder setLogo(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        logo_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
       * circumstances where a wide graphic is needed.
       * </pre>
       *
       * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearLogo() {
        logo_ = getDefaultInstance().getLogo();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies a logo URL to use for this tenant branding payload. The logo URL is used in the header, and in other
       * circumstances where a wide graphic is needed.
       * </pre>
       *
       * <code>string logo = 2 [json_name = "logo", (.google.api.field_behavior) = OPTIONAL, (.validate.rules) = { ... }</code>
       * @param value The bytes for logo to set.
       * @return This builder for chaining.
       */
      public Builder setLogoBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        logo_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.buildless.Tenant.TenantBranding.TenantColors light_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.buildless.Tenant.TenantBranding.TenantColors, com.buildless.Tenant.TenantBranding.TenantColors.Builder, com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder> lightBuilder_;
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       * @return Whether the light field is set.
       */
      public boolean hasLight() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       * @return The light.
       */
      public com.buildless.Tenant.TenantBranding.TenantColors getLight() {
        if (lightBuilder_ == null) {
          return light_ == null ? com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance() : light_;
        } else {
          return lightBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder setLight(com.buildless.Tenant.TenantBranding.TenantColors value) {
        if (lightBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          light_ = value;
        } else {
          lightBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder setLight(
          com.buildless.Tenant.TenantBranding.TenantColors.Builder builderForValue) {
        if (lightBuilder_ == null) {
          light_ = builderForValue.build();
        } else {
          lightBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder mergeLight(com.buildless.Tenant.TenantBranding.TenantColors value) {
        if (lightBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            light_ != null &&
            light_ != com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance()) {
            getLightBuilder().mergeFrom(value);
          } else {
            light_ = value;
          }
        } else {
          lightBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder clearLight() {
        bitField0_ = (bitField0_ & ~0x00000004);
        light_ = null;
        if (lightBuilder_ != null) {
          lightBuilder_.dispose();
          lightBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public com.buildless.Tenant.TenantBranding.TenantColors.Builder getLightBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getLightFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder getLightOrBuilder() {
        if (lightBuilder_ != null) {
          return lightBuilder_.getMessageOrBuilder();
        } else {
          return light_ == null ?
              com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance() : light_;
        }
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `light` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors light = 3 [json_name = "light", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.buildless.Tenant.TenantBranding.TenantColors, com.buildless.Tenant.TenantBranding.TenantColors.Builder, com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder> 
          getLightFieldBuilder() {
        if (lightBuilder_ == null) {
          lightBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.buildless.Tenant.TenantBranding.TenantColors, com.buildless.Tenant.TenantBranding.TenantColors.Builder, com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder>(
                  getLight(),
                  getParentForChildren(),
                  isClean());
          light_ = null;
        }
        return lightBuilder_;
      }

      private com.buildless.Tenant.TenantBranding.TenantColors dark_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.buildless.Tenant.TenantBranding.TenantColors, com.buildless.Tenant.TenantBranding.TenantColors.Builder, com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder> darkBuilder_;
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       * @return Whether the dark field is set.
       */
      public boolean hasDark() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       * @return The dark.
       */
      public com.buildless.Tenant.TenantBranding.TenantColors getDark() {
        if (darkBuilder_ == null) {
          return dark_ == null ? com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance() : dark_;
        } else {
          return darkBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder setDark(com.buildless.Tenant.TenantBranding.TenantColors value) {
        if (darkBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dark_ = value;
        } else {
          darkBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder setDark(
          com.buildless.Tenant.TenantBranding.TenantColors.Builder builderForValue) {
        if (darkBuilder_ == null) {
          dark_ = builderForValue.build();
        } else {
          darkBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder mergeDark(com.buildless.Tenant.TenantBranding.TenantColors value) {
        if (darkBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            dark_ != null &&
            dark_ != com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance()) {
            getDarkBuilder().mergeFrom(value);
          } else {
            dark_ = value;
          }
        } else {
          darkBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder clearDark() {
        bitField0_ = (bitField0_ & ~0x00000008);
        dark_ = null;
        if (darkBuilder_ != null) {
          darkBuilder_.dispose();
          darkBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public com.buildless.Tenant.TenantBranding.TenantColors.Builder getDarkBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getDarkFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      public com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder getDarkOrBuilder() {
        if (darkBuilder_ != null) {
          return darkBuilder_.getMessageOrBuilder();
        } else {
          return dark_ == null ?
              com.buildless.Tenant.TenantBranding.TenantColors.getDefaultInstance() : dark_;
        }
      }
      /**
       * <pre>
       * Color scheme to use for this tenant when the `dark` theme is active. If not present, default colors are used.
       * </pre>
       *
       * <code>.buildless.Tenant.TenantBranding.TenantColors dark = 4 [json_name = "dark", (.google.api.field_behavior) = OPTIONAL];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.buildless.Tenant.TenantBranding.TenantColors, com.buildless.Tenant.TenantBranding.TenantColors.Builder, com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder> 
          getDarkFieldBuilder() {
        if (darkBuilder_ == null) {
          darkBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.buildless.Tenant.TenantBranding.TenantColors, com.buildless.Tenant.TenantBranding.TenantColors.Builder, com.buildless.Tenant.TenantBranding.TenantColorsOrBuilder>(
                  getDark(),
                  getParentForChildren(),
                  isClean());
          dark_ = null;
        }
        return darkBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:buildless.Tenant.TenantBranding)
    }

    // @@protoc_insertion_point(class_scope:buildless.Tenant.TenantBranding)
    private static final com.buildless.Tenant.TenantBranding DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.buildless.Tenant.TenantBranding();
    }

    public static com.buildless.Tenant.TenantBranding getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TenantBranding>
        PARSER = new com.google.protobuf.AbstractParser<TenantBranding>() {
      @java.lang.Override
      public TenantBranding parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TenantBranding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TenantBranding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.buildless.Tenant.TenantBranding getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TenantDomainOrBuilder extends
      // @@protoc_insertion_point(interface_extends:buildless.Tenant.TenantDomain)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies the domain value to be linked.
     * </pre>
     *
     * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
     * @return The domain.
     */
    java.lang.String getDomain();
    /**
     * <pre>
     * Specifies the domain value to be linked.
     * </pre>
     *
     * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
     * @return The bytes for domain.
     */
    com.google.protobuf.ByteString
        getDomainBytes();

    /**
     * <pre>
     * Specifies whether this domain has completed verification.
     * </pre>
     *
     * <code>bool verified = 2 [json_name = "verified"];</code>
     * @return The verified.
     */
    boolean getVerified();

    /**
     * <pre>
     * Specifies whether the domain is actively routing.
     * </pre>
     *
     * <code>bool active = 3 [json_name = "active"];</code>
     * @return The active.
     */
    boolean getActive();
  }
  /**
   * <pre>
   * ### Tenant Domain
   *
   * Specifies a custom tenant domain which is attached to Buildless services. Domains attached in this manner must be
   * licensed on an individual basis. Some plans may include an amount of custom domains.
   * </pre>
   *
   * Protobuf type {@code buildless.Tenant.TenantDomain}
   */
  public static final class TenantDomain extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:buildless.Tenant.TenantDomain)
      TenantDomainOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TenantDomain.newBuilder() to construct.
    private TenantDomain(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TenantDomain() {
      domain_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TenantDomain();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantDomain_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantDomain_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.buildless.Tenant.TenantDomain.class, com.buildless.Tenant.TenantDomain.Builder.class);
    }

    public static final int DOMAIN_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object domain_ = "";
    /**
     * <pre>
     * Specifies the domain value to be linked.
     * </pre>
     *
     * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
     * @return The domain.
     */
    @java.lang.Override
    public java.lang.String getDomain() {
      java.lang.Object ref = domain_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domain_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Specifies the domain value to be linked.
     * </pre>
     *
     * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
     * @return The bytes for domain.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDomainBytes() {
      java.lang.Object ref = domain_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        domain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERIFIED_FIELD_NUMBER = 2;
    private boolean verified_ = false;
    /**
     * <pre>
     * Specifies whether this domain has completed verification.
     * </pre>
     *
     * <code>bool verified = 2 [json_name = "verified"];</code>
     * @return The verified.
     */
    @java.lang.Override
    public boolean getVerified() {
      return verified_;
    }

    public static final int ACTIVE_FIELD_NUMBER = 3;
    private boolean active_ = false;
    /**
     * <pre>
     * Specifies whether the domain is actively routing.
     * </pre>
     *
     * <code>bool active = 3 [json_name = "active"];</code>
     * @return The active.
     */
    @java.lang.Override
    public boolean getActive() {
      return active_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, domain_);
      }
      if (verified_ != false) {
        output.writeBool(2, verified_);
      }
      if (active_ != false) {
        output.writeBool(3, active_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, domain_);
      }
      if (verified_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, verified_);
      }
      if (active_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, active_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.buildless.Tenant.TenantDomain)) {
        return super.equals(obj);
      }
      com.buildless.Tenant.TenantDomain other = (com.buildless.Tenant.TenantDomain) obj;

      if (!getDomain()
          .equals(other.getDomain())) return false;
      if (getVerified()
          != other.getVerified()) return false;
      if (getActive()
          != other.getActive()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
      hash = (53 * hash) + getDomain().hashCode();
      hash = (37 * hash) + VERIFIED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getVerified());
      hash = (37 * hash) + ACTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getActive());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.buildless.Tenant.TenantDomain parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.buildless.Tenant.TenantDomain parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.buildless.Tenant.TenantDomain parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.buildless.Tenant.TenantDomain parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.buildless.Tenant.TenantDomain prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * ### Tenant Domain
     *
     * Specifies a custom tenant domain which is attached to Buildless services. Domains attached in this manner must be
     * licensed on an individual basis. Some plans may include an amount of custom domains.
     * </pre>
     *
     * Protobuf type {@code buildless.Tenant.TenantDomain}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:buildless.Tenant.TenantDomain)
        com.buildless.Tenant.TenantDomainOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantDomain_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantDomain_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.buildless.Tenant.TenantDomain.class, com.buildless.Tenant.TenantDomain.Builder.class);
      }

      // Construct using com.buildless.Tenant.TenantDomain.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        domain_ = "";
        verified_ = false;
        active_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.buildless.CommonProto.internal_static_buildless_Tenant_TenantDomain_descriptor;
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantDomain getDefaultInstanceForType() {
        return com.buildless.Tenant.TenantDomain.getDefaultInstance();
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantDomain build() {
        com.buildless.Tenant.TenantDomain result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.buildless.Tenant.TenantDomain buildPartial() {
        com.buildless.Tenant.TenantDomain result = new com.buildless.Tenant.TenantDomain(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.buildless.Tenant.TenantDomain result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.domain_ = domain_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.verified_ = verified_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.active_ = active_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.buildless.Tenant.TenantDomain) {
          return mergeFrom((com.buildless.Tenant.TenantDomain)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.buildless.Tenant.TenantDomain other) {
        if (other == com.buildless.Tenant.TenantDomain.getDefaultInstance()) return this;
        if (!other.getDomain().isEmpty()) {
          domain_ = other.domain_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getVerified() != false) {
          setVerified(other.getVerified());
        }
        if (other.getActive() != false) {
          setActive(other.getActive());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                domain_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                verified_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 24: {
                active_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object domain_ = "";
      /**
       * <pre>
       * Specifies the domain value to be linked.
       * </pre>
       *
       * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
       * @return The domain.
       */
      public java.lang.String getDomain() {
        java.lang.Object ref = domain_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          domain_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Specifies the domain value to be linked.
       * </pre>
       *
       * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
       * @return The bytes for domain.
       */
      public com.google.protobuf.ByteString
          getDomainBytes() {
        java.lang.Object ref = domain_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          domain_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Specifies the domain value to be linked.
       * </pre>
       *
       * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
       * @param value The domain to set.
       * @return This builder for chaining.
       */
      public Builder setDomain(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        domain_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the domain value to be linked.
       * </pre>
       *
       * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
       * @return This builder for chaining.
       */
      public Builder clearDomain() {
        domain_ = getDefaultInstance().getDomain();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the domain value to be linked.
       * </pre>
       *
       * <code>string domain = 1 [json_name = "domain", (.google.api.field_behavior) = REQUIRED, (.validate.rules) = { ... }</code>
       * @param value The bytes for domain to set.
       * @return This builder for chaining.
       */
      public Builder setDomainBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        domain_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean verified_ ;
      /**
       * <pre>
       * Specifies whether this domain has completed verification.
       * </pre>
       *
       * <code>bool verified = 2 [json_name = "verified"];</code>
       * @return The verified.
       */
      @java.lang.Override
      public boolean getVerified() {
        return verified_;
      }
      /**
       * <pre>
       * Specifies whether this domain has completed verification.
       * </pre>
       *
       * <code>bool verified = 2 [json_name = "verified"];</code>
       * @param value The verified to set.
       * @return This builder for chaining.
       */
      public Builder setVerified(boolean value) {

        verified_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies whether this domain has completed verification.
       * </pre>
       *
       * <code>bool verified = 2 [json_name = "verified"];</code>
       * @return This builder for chaining.
       */
      public Builder clearVerified() {
        bitField0_ = (bitField0_ & ~0x00000002);
        verified_ = false;
        onChanged();
        return this;
      }

      private boolean active_ ;
      /**
       * <pre>
       * Specifies whether the domain is actively routing.
       * </pre>
       *
       * <code>bool active = 3 [json_name = "active"];</code>
       * @return The active.
       */
      @java.lang.Override
      public boolean getActive() {
        return active_;
      }
      /**
       * <pre>
       * Specifies whether the domain is actively routing.
       * </pre>
       *
       * <code>bool active = 3 [json_name = "active"];</code>
       * @param value The active to set.
       * @return This builder for chaining.
       */
      public Builder setActive(boolean value) {

        active_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies whether the domain is actively routing.
       * </pre>
       *
       * <code>bool active = 3 [json_name = "active"];</code>
       * @return This builder for chaining.
       */
      public Builder clearActive() {
        bitField0_ = (bitField0_ & ~0x00000004);
        active_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:buildless.Tenant.TenantDomain)
    }

    // @@protoc_insertion_point(class_scope:buildless.Tenant.TenantDomain)
    private static final com.buildless.Tenant.TenantDomain DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.buildless.Tenant.TenantDomain();
    }

    public static com.buildless.Tenant.TenantDomain getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TenantDomain>
        PARSER = new com.google.protobuf.AbstractParser<TenantDomain>() {
      @java.lang.Override
      public TenantDomain parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TenantDomain> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TenantDomain> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.buildless.Tenant.TenantDomain getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int KEY_FIELD_NUMBER = 1;
  private com.buildless.Tenant.TenantKey key_;
  /**
   * <pre>
   * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
   * </pre>
   *
   * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
   * @return Whether the key field is set.
   */
  @java.lang.Override
  public boolean hasKey() {
    return key_ != null;
  }
  /**
   * <pre>
   * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
   * </pre>
   *
   * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
   * @return The key.
   */
  @java.lang.Override
  public com.buildless.Tenant.TenantKey getKey() {
    return key_ == null ? com.buildless.Tenant.TenantKey.getDefaultInstance() : key_;
  }
  /**
   * <pre>
   * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
   * </pre>
   *
   * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
   */
  @java.lang.Override
  public com.buildless.Tenant.TenantKeyOrBuilder getKeyOrBuilder() {
    return key_ == null ? com.buildless.Tenant.TenantKey.getDefaultInstance() : key_;
  }

  public static final int UUID_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private volatile java.lang.Object uuid_ = "";
  /**
   * <pre>
   * Specifies a unique ID for the tenant which is not shared publicly. This tenant UUID value is used to tie a tenant
   * record to external management and billing systems. The Tenant UUID is not sensitive, but is considered internal.
   * The Tenant UUID is globally unique.
   * </pre>
   *
   * <code>string uuid = 2 [json_name = "uuid", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The uuid.
   */
  @java.lang.Override
  public java.lang.String getUuid() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uuid_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specifies a unique ID for the tenant which is not shared publicly. This tenant UUID value is used to tie a tenant
   * record to external management and billing systems. The Tenant UUID is not sensitive, but is considered internal.
   * The Tenant UUID is globally unique.
   * </pre>
   *
   * <code>string uuid = 2 [json_name = "uuid", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for uuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getUuidBytes() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      uuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * Short-name for this tenant, which should be a string of length 2-32 characters. The name is also referred to as the
   * "short name." This name is used in sub-domains, so it must be a DNS-compatible name. Globally unique.
   * </pre>
   *
   * <code>string name = 3 [json_name = "name", (.google.api.field_behavior) = IMMUTABLE, (.validate.rules) = { ... }</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Short-name for this tenant, which should be a string of length 2-32 characters. The name is also referred to as the
   * "short name." This name is used in sub-domains, so it must be a DNS-compatible name. Globally unique.
   * </pre>
   *
   * <code>string name = 3 [json_name = "name", (.google.api.field_behavior) = IMMUTABLE, (.validate.rules) = { ... }</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   * <pre>
   * Display name for this tenant. Can be any string value between 2-32 characters. The label is shown in user-facing
   * interfaces to identify a given tenant account.
   * </pre>
   *
   * <code>string display_name = 4 [json_name = "displayName", (.validate.rules) = { ... }</code>
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Display name for this tenant. Can be any string value between 2-32 characters. The label is shown in user-facing
   * interfaces to identify a given tenant account.
   * </pre>
   *
   * <code>string display_name = 4 [json_name = "displayName", (.validate.rules) = { ... }</code>
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTIVE_FIELD_NUMBER = 5;
  private boolean active_ = false;
  /**
   * <pre>
   * Whether this account is considered active. If an account is inactive, users and resources associated with the
   * tenant are not accessible. Inactive accounts are scheduled for deletion after a period of time.
   * </pre>
   *
   * <code>bool active = 5 [json_name = "active", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The active.
   */
  @java.lang.Override
  public boolean getActive() {
    return active_;
  }

  public static final int BRANDING_FIELD_NUMBER = 6;
  private com.buildless.Tenant.TenantBranding branding_;
  /**
   * <pre>
   * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
   * have a supporting plan and choose to customize branding.
   * </pre>
   *
   * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
   * @return Whether the branding field is set.
   */
  @java.lang.Override
  public boolean hasBranding() {
    return branding_ != null;
  }
  /**
   * <pre>
   * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
   * have a supporting plan and choose to customize branding.
   * </pre>
   *
   * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
   * @return The branding.
   */
  @java.lang.Override
  public com.buildless.Tenant.TenantBranding getBranding() {
    return branding_ == null ? com.buildless.Tenant.TenantBranding.getDefaultInstance() : branding_;
  }
  /**
   * <pre>
   * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
   * have a supporting plan and choose to customize branding.
   * </pre>
   *
   * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.buildless.Tenant.TenantBrandingOrBuilder getBrandingOrBuilder() {
    return branding_ == null ? com.buildless.Tenant.TenantBranding.getDefaultInstance() : branding_;
  }

  public static final int DOMAIN_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private java.util.List<com.buildless.Tenant.TenantDomain> domain_;
  /**
   * <pre>
   * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
   * to link domains, and if their plan supports it.
   * </pre>
   *
   * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<com.buildless.Tenant.TenantDomain> getDomainList() {
    return domain_;
  }
  /**
   * <pre>
   * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
   * to link domains, and if their plan supports it.
   * </pre>
   *
   * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.buildless.Tenant.TenantDomainOrBuilder> 
      getDomainOrBuilderList() {
    return domain_;
  }
  /**
   * <pre>
   * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
   * to link domains, and if their plan supports it.
   * </pre>
   *
   * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
   */
  @java.lang.Override
  public int getDomainCount() {
    return domain_.size();
  }
  /**
   * <pre>
   * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
   * to link domains, and if their plan supports it.
   * </pre>
   *
   * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
   */
  @java.lang.Override
  public com.buildless.Tenant.TenantDomain getDomain(int index) {
    return domain_.get(index);
  }
  /**
   * <pre>
   * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
   * to link domains, and if their plan supports it.
   * </pre>
   *
   * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
   */
  @java.lang.Override
  public com.buildless.Tenant.TenantDomainOrBuilder getDomainOrBuilder(
      int index) {
    return domain_.get(index);
  }

  public static final int PLAN_FIELD_NUMBER = 8;
  private com.buildless.billing.TenantPlanInfo plan_;
  /**
   * <pre>
   * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
   * </pre>
   *
   * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the plan field is set.
   */
  @java.lang.Override
  public boolean hasPlan() {
    return plan_ != null;
  }
  /**
   * <pre>
   * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
   * </pre>
   *
   * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The plan.
   */
  @java.lang.Override
  public com.buildless.billing.TenantPlanInfo getPlan() {
    return plan_ == null ? com.buildless.billing.TenantPlanInfo.getDefaultInstance() : plan_;
  }
  /**
   * <pre>
   * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
   * </pre>
   *
   * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.buildless.billing.TenantPlanInfoOrBuilder getPlanOrBuilder() {
    return plan_ == null ? com.buildless.billing.TenantPlanInfo.getDefaultInstance() : plan_;
  }

  public static final int AUTH_ID_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private volatile java.lang.Object authId_ = "";
  /**
   * <pre>
   * Specifies the linked authorization tenant for this org tenant record. The authorization tenant holds users and
   * roles for a given tenant record.
   * </pre>
   *
   * <code>string auth_id = 9 [json_name = "authId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The authId.
   */
  @java.lang.Override
  public java.lang.String getAuthId() {
    java.lang.Object ref = authId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specifies the linked authorization tenant for this org tenant record. The authorization tenant holds users and
   * roles for a given tenant record.
   * </pre>
   *
   * <code>string auth_id = 9 [json_name = "authId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for authId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAuthIdBytes() {
    java.lang.Object ref = authId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      authId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPO_PROVIDER_FIELD_NUMBER = 10;
  private int repoProvider_ = 0;
  /**
   * <pre>
   * Specifies the main repository provider for this tenant. This is mostly a cosmetic setting, but it also governs
   * which repositories are shown by default as options to add in the UI.
   * </pre>
   *
   * <code>.buildless.code.RepositoryProvider repo_provider = 10 [json_name = "repoProvider"];</code>
   * @return The enum numeric value on the wire for repoProvider.
   */
  @java.lang.Override public int getRepoProviderValue() {
    return repoProvider_;
  }
  /**
   * <pre>
   * Specifies the main repository provider for this tenant. This is mostly a cosmetic setting, but it also governs
   * which repositories are shown by default as options to add in the UI.
   * </pre>
   *
   * <code>.buildless.code.RepositoryProvider repo_provider = 10 [json_name = "repoProvider"];</code>
   * @return The repoProvider.
   */
  @java.lang.Override public com.buildless.code.RepositoryProvider getRepoProvider() {
    com.buildless.code.RepositoryProvider result = com.buildless.code.RepositoryProvider.forNumber(repoProvider_);
    return result == null ? com.buildless.code.RepositoryProvider.UNRECOGNIZED : result;
  }

  public static final int REPO_PROVIDER_ORG_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private volatile java.lang.Object repoProviderOrg_ = "";
  /**
   * <pre>
   * Specifies the name of the organization in the context of their repository provider (for example, their GitHub org
   * name). This is both used cosmetically in the UI and used as a hint for repository discovery.
   * </pre>
   *
   * <code>string repo_provider_org = 11 [json_name = "repoProviderOrg", (.validate.rules) = { ... }</code>
   * @return The repoProviderOrg.
   */
  @java.lang.Override
  public java.lang.String getRepoProviderOrg() {
    java.lang.Object ref = repoProviderOrg_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      repoProviderOrg_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specifies the name of the organization in the context of their repository provider (for example, their GitHub org
   * name). This is both used cosmetically in the UI and used as a hint for repository discovery.
   * </pre>
   *
   * <code>string repo_provider_org = 11 [json_name = "repoProviderOrg", (.validate.rules) = { ... }</code>
   * @return The bytes for repoProviderOrg.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getRepoProviderOrgBytes() {
    java.lang.Object ref = repoProviderOrg_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      repoProviderOrg_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUSPENDED_FIELD_NUMBER = 12;
  private boolean suspended_ = false;
  /**
   * <pre>
   * Flipped to `true` if an organization is scheduled for deletion, or if it has been suspended due to lack of payment
   * or other administrative action. In this case, `active` will be set to `false`.
   * </pre>
   *
   * <code>bool suspended = 12 [json_name = "suspended", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The suspended.
   */
  @java.lang.Override
  public boolean getSuspended() {
    return suspended_;
  }

  public static final int DIRECTORY_ORG_LIVE_FIELD_NUMBER = 13;
  @SuppressWarnings("serial")
  private volatile java.lang.Object directoryOrgLive_ = "";
  /**
   * <pre>
   * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for live sync
   * of users, groups, and roles. Other features such as Log Streaming may also leverage this ID.
   * </pre>
   *
   * <code>string directory_org_live = 13 [json_name = "directoryOrgLive", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The directoryOrgLive.
   */
  @java.lang.Override
  public java.lang.String getDirectoryOrgLive() {
    java.lang.Object ref = directoryOrgLive_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      directoryOrgLive_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for live sync
   * of users, groups, and roles. Other features such as Log Streaming may also leverage this ID.
   * </pre>
   *
   * <code>string directory_org_live = 13 [json_name = "directoryOrgLive", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for directoryOrgLive.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDirectoryOrgLiveBytes() {
    java.lang.Object ref = directoryOrgLive_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      directoryOrgLive_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIRECTORY_ORG_SANDBOX_FIELD_NUMBER = 14;
  @SuppressWarnings("serial")
  private volatile java.lang.Object directoryOrgSandbox_ = "";
  /**
   * <pre>
   * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for sandbox
   * sync of users, groups, and roles (see `directory_org_live` for production use). Other features such as Log
   * Streaming may also leverage this ID.
   * </pre>
   *
   * <code>string directory_org_sandbox = 14 [json_name = "directoryOrgSandbox", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The directoryOrgSandbox.
   */
  @java.lang.Override
  public java.lang.String getDirectoryOrgSandbox() {
    java.lang.Object ref = directoryOrgSandbox_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      directoryOrgSandbox_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for sandbox
   * sync of users, groups, and roles (see `directory_org_live` for production use). Other features such as Log
   * Streaming may also leverage this ID.
   * </pre>
   *
   * <code>string directory_org_sandbox = 14 [json_name = "directoryOrgSandbox", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for directoryOrgSandbox.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDirectoryOrgSandboxBytes() {
    java.lang.Object ref = directoryOrgSandbox_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      directoryOrgSandbox_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBSCRIPTION_ID_FIELD_NUMBER = 15;
  @SuppressWarnings("serial")
  private volatile java.lang.Object subscriptionId_ = "";
  /**
   * <pre>
   * ID generated for this tenant's active subscription by the billing system. This ID is always present for active
   * (non-suspended) tenants.
   * </pre>
   *
   * <code>string subscription_id = 15 [json_name = "subscriptionId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The subscriptionId.
   */
  @java.lang.Override
  public java.lang.String getSubscriptionId() {
    java.lang.Object ref = subscriptionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subscriptionId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * ID generated for this tenant's active subscription by the billing system. This ID is always present for active
   * (non-suspended) tenants.
   * </pre>
   *
   * <code>string subscription_id = 15 [json_name = "subscriptionId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for subscriptionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getSubscriptionIdBytes() {
    java.lang.Object ref = subscriptionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      subscriptionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCALE_FIELD_NUMBER = 16;
  @SuppressWarnings("serial")
  private volatile java.lang.Object locale_ = "";
  /**
   * <pre>
   * Locale to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
   * </pre>
   *
   * <code>string locale = 16 [json_name = "locale", (.google.api.field_behavior) = OPTIONAL];</code>
   * @return The locale.
   */
  @java.lang.Override
  public java.lang.String getLocale() {
    java.lang.Object ref = locale_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locale_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Locale to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
   * </pre>
   *
   * <code>string locale = 16 [json_name = "locale", (.google.api.field_behavior) = OPTIONAL];</code>
   * @return The bytes for locale.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getLocaleBytes() {
    java.lang.Object ref = locale_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      locale_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIMEZONE_FIELD_NUMBER = 17;
  @SuppressWarnings("serial")
  private volatile java.lang.Object timezone_ = "";
  /**
   * <pre>
   * Timezone to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
   * </pre>
   *
   * <code>string timezone = 17 [json_name = "timezone", (.google.api.field_behavior) = OPTIONAL];</code>
   * @return The timezone.
   */
  @java.lang.Override
  public java.lang.String getTimezone() {
    java.lang.Object ref = timezone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timezone_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Timezone to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
   * </pre>
   *
   * <code>string timezone = 17 [json_name = "timezone", (.google.api.field_behavior) = OPTIONAL];</code>
   * @return The bytes for timezone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getTimezoneBytes() {
    java.lang.Object ref = timezone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      timezone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATED_AT_FIELD_NUMBER = 98;
  private com.google.protobuf.Timestamp updatedAt_;
  /**
   * <pre>
   * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
   * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
   * @return Whether the updatedAt field is set.
   */
  @java.lang.Override
  public boolean hasUpdatedAt() {
    return updatedAt_ != null;
  }
  /**
   * <pre>
   * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
   * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
   * @return The updatedAt.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdatedAt() {
    return updatedAt_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updatedAt_;
  }
  /**
   * <pre>
   * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
   * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdatedAtOrBuilder() {
    return updatedAt_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updatedAt_;
  }

  public static final int CREATED_AT_FIELD_NUMBER = 99;
  private com.google.protobuf.Timestamp createdAt_;
  /**
   * <pre>
   * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
   * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
   * @return Whether the createdAt field is set.
   */
  @java.lang.Override
  public boolean hasCreatedAt() {
    return createdAt_ != null;
  }
  /**
   * <pre>
   * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
   * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
   * @return The createdAt.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreatedAt() {
    return createdAt_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createdAt_;
  }
  /**
   * <pre>
   * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
   * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreatedAtOrBuilder() {
    return createdAt_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createdAt_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (key_ != null) {
      output.writeMessage(1, getKey());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uuid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    if (active_ != false) {
      output.writeBool(5, active_);
    }
    if (branding_ != null) {
      output.writeMessage(6, getBranding());
    }
    for (int i = 0; i < domain_.size(); i++) {
      output.writeMessage(7, domain_.get(i));
    }
    if (plan_ != null) {
      output.writeMessage(8, getPlan());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, authId_);
    }
    if (repoProvider_ != com.buildless.code.RepositoryProvider.NO_REPOSITORY_PROVIDER.getNumber()) {
      output.writeEnum(10, repoProvider_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repoProviderOrg_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, repoProviderOrg_);
    }
    if (suspended_ != false) {
      output.writeBool(12, suspended_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(directoryOrgLive_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, directoryOrgLive_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(directoryOrgSandbox_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, directoryOrgSandbox_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subscriptionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, subscriptionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locale_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, locale_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timezone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, timezone_);
    }
    if (updatedAt_ != null) {
      output.writeMessage(98, getUpdatedAt());
    }
    if (createdAt_ != null) {
      output.writeMessage(99, getCreatedAt());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (key_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getKey());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uuid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    if (active_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(5, active_);
    }
    if (branding_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getBranding());
    }
    for (int i = 0; i < domain_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, domain_.get(i));
    }
    if (plan_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, getPlan());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, authId_);
    }
    if (repoProvider_ != com.buildless.code.RepositoryProvider.NO_REPOSITORY_PROVIDER.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(10, repoProvider_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repoProviderOrg_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, repoProviderOrg_);
    }
    if (suspended_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(12, suspended_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(directoryOrgLive_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, directoryOrgLive_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(directoryOrgSandbox_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, directoryOrgSandbox_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subscriptionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, subscriptionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locale_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, locale_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timezone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, timezone_);
    }
    if (updatedAt_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(98, getUpdatedAt());
    }
    if (createdAt_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(99, getCreatedAt());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.buildless.Tenant)) {
      return super.equals(obj);
    }
    com.buildless.Tenant other = (com.buildless.Tenant) obj;

    if (hasKey() != other.hasKey()) return false;
    if (hasKey()) {
      if (!getKey()
          .equals(other.getKey())) return false;
    }
    if (!getUuid()
        .equals(other.getUuid())) return false;
    if (!getName()
        .equals(other.getName())) return false;
    if (!getDisplayName()
        .equals(other.getDisplayName())) return false;
    if (getActive()
        != other.getActive()) return false;
    if (hasBranding() != other.hasBranding()) return false;
    if (hasBranding()) {
      if (!getBranding()
          .equals(other.getBranding())) return false;
    }
    if (!getDomainList()
        .equals(other.getDomainList())) return false;
    if (hasPlan() != other.hasPlan()) return false;
    if (hasPlan()) {
      if (!getPlan()
          .equals(other.getPlan())) return false;
    }
    if (!getAuthId()
        .equals(other.getAuthId())) return false;
    if (repoProvider_ != other.repoProvider_) return false;
    if (!getRepoProviderOrg()
        .equals(other.getRepoProviderOrg())) return false;
    if (getSuspended()
        != other.getSuspended()) return false;
    if (!getDirectoryOrgLive()
        .equals(other.getDirectoryOrgLive())) return false;
    if (!getDirectoryOrgSandbox()
        .equals(other.getDirectoryOrgSandbox())) return false;
    if (!getSubscriptionId()
        .equals(other.getSubscriptionId())) return false;
    if (!getLocale()
        .equals(other.getLocale())) return false;
    if (!getTimezone()
        .equals(other.getTimezone())) return false;
    if (hasUpdatedAt() != other.hasUpdatedAt()) return false;
    if (hasUpdatedAt()) {
      if (!getUpdatedAt()
          .equals(other.getUpdatedAt())) return false;
    }
    if (hasCreatedAt() != other.hasCreatedAt()) return false;
    if (hasCreatedAt()) {
      if (!getCreatedAt()
          .equals(other.getCreatedAt())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasKey()) {
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
    }
    hash = (37 * hash) + UUID_FIELD_NUMBER;
    hash = (53 * hash) + getUuid().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + ACTIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getActive());
    if (hasBranding()) {
      hash = (37 * hash) + BRANDING_FIELD_NUMBER;
      hash = (53 * hash) + getBranding().hashCode();
    }
    if (getDomainCount() > 0) {
      hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
      hash = (53 * hash) + getDomainList().hashCode();
    }
    if (hasPlan()) {
      hash = (37 * hash) + PLAN_FIELD_NUMBER;
      hash = (53 * hash) + getPlan().hashCode();
    }
    hash = (37 * hash) + AUTH_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAuthId().hashCode();
    hash = (37 * hash) + REPO_PROVIDER_FIELD_NUMBER;
    hash = (53 * hash) + repoProvider_;
    hash = (37 * hash) + REPO_PROVIDER_ORG_FIELD_NUMBER;
    hash = (53 * hash) + getRepoProviderOrg().hashCode();
    hash = (37 * hash) + SUSPENDED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getSuspended());
    hash = (37 * hash) + DIRECTORY_ORG_LIVE_FIELD_NUMBER;
    hash = (53 * hash) + getDirectoryOrgLive().hashCode();
    hash = (37 * hash) + DIRECTORY_ORG_SANDBOX_FIELD_NUMBER;
    hash = (53 * hash) + getDirectoryOrgSandbox().hashCode();
    hash = (37 * hash) + SUBSCRIPTION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSubscriptionId().hashCode();
    hash = (37 * hash) + LOCALE_FIELD_NUMBER;
    hash = (53 * hash) + getLocale().hashCode();
    hash = (37 * hash) + TIMEZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimezone().hashCode();
    if (hasUpdatedAt()) {
      hash = (37 * hash) + UPDATED_AT_FIELD_NUMBER;
      hash = (53 * hash) + getUpdatedAt().hashCode();
    }
    if (hasCreatedAt()) {
      hash = (37 * hash) + CREATED_AT_FIELD_NUMBER;
      hash = (53 * hash) + getCreatedAt().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.buildless.Tenant parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.buildless.Tenant parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.buildless.Tenant parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.buildless.Tenant parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.buildless.Tenant parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.buildless.Tenant parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.buildless.Tenant parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.buildless.Tenant parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.buildless.Tenant parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.buildless.Tenant parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.buildless.Tenant parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.buildless.Tenant parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.buildless.Tenant prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * ## Tenant
   *
   * Specifies an organization tenant record within Buildless. Organization tenants are the top-most level of user data
   * within the system. All user accounts are eligible to be members of a given tenant.
   *
   * Each tenant (also known as an "organization" or "team") has a unique set of identifiers, and within the scope of that
   * tenant, all organization data is owned. If a tenant is deactivated, all resources associated with that tenant are
   * henceforth inaccessible, and later scheduled for deletion. Settings, permissions, and analytics all roll up at the
   * top-most level of a tenant.
   *
   * See also: `User`, `Account`.
   * </pre>
   *
   * Protobuf type {@code buildless.Tenant}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:buildless.Tenant)
      com.buildless.TenantOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.buildless.Tenant.class, com.buildless.Tenant.Builder.class);
    }

    // Construct using com.buildless.Tenant.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      key_ = null;
      if (keyBuilder_ != null) {
        keyBuilder_.dispose();
        keyBuilder_ = null;
      }
      uuid_ = "";
      name_ = "";
      displayName_ = "";
      active_ = false;
      branding_ = null;
      if (brandingBuilder_ != null) {
        brandingBuilder_.dispose();
        brandingBuilder_ = null;
      }
      if (domainBuilder_ == null) {
        domain_ = java.util.Collections.emptyList();
      } else {
        domain_ = null;
        domainBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      plan_ = null;
      if (planBuilder_ != null) {
        planBuilder_.dispose();
        planBuilder_ = null;
      }
      authId_ = "";
      repoProvider_ = 0;
      repoProviderOrg_ = "";
      suspended_ = false;
      directoryOrgLive_ = "";
      directoryOrgSandbox_ = "";
      subscriptionId_ = "";
      locale_ = "";
      timezone_ = "";
      updatedAt_ = null;
      if (updatedAtBuilder_ != null) {
        updatedAtBuilder_.dispose();
        updatedAtBuilder_ = null;
      }
      createdAt_ = null;
      if (createdAtBuilder_ != null) {
        createdAtBuilder_.dispose();
        createdAtBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.buildless.CommonProto.internal_static_buildless_Tenant_descriptor;
    }

    @java.lang.Override
    public com.buildless.Tenant getDefaultInstanceForType() {
      return com.buildless.Tenant.getDefaultInstance();
    }

    @java.lang.Override
    public com.buildless.Tenant build() {
      com.buildless.Tenant result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.buildless.Tenant buildPartial() {
      com.buildless.Tenant result = new com.buildless.Tenant(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.buildless.Tenant result) {
      if (domainBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          domain_ = java.util.Collections.unmodifiableList(domain_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.domain_ = domain_;
      } else {
        result.domain_ = domainBuilder_.build();
      }
    }

    private void buildPartial0(com.buildless.Tenant result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.key_ = keyBuilder_ == null
            ? key_
            : keyBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uuid_ = uuid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.active_ = active_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.branding_ = brandingBuilder_ == null
            ? branding_
            : brandingBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.plan_ = planBuilder_ == null
            ? plan_
            : planBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.authId_ = authId_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.repoProvider_ = repoProvider_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.repoProviderOrg_ = repoProviderOrg_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.suspended_ = suspended_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.directoryOrgLive_ = directoryOrgLive_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.directoryOrgSandbox_ = directoryOrgSandbox_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.subscriptionId_ = subscriptionId_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.locale_ = locale_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.timezone_ = timezone_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.updatedAt_ = updatedAtBuilder_ == null
            ? updatedAt_
            : updatedAtBuilder_.build();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.createdAt_ = createdAtBuilder_ == null
            ? createdAt_
            : createdAtBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.buildless.Tenant) {
        return mergeFrom((com.buildless.Tenant)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.buildless.Tenant other) {
      if (other == com.buildless.Tenant.getDefaultInstance()) return this;
      if (other.hasKey()) {
        mergeKey(other.getKey());
      }
      if (!other.getUuid().isEmpty()) {
        uuid_ = other.uuid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getActive() != false) {
        setActive(other.getActive());
      }
      if (other.hasBranding()) {
        mergeBranding(other.getBranding());
      }
      if (domainBuilder_ == null) {
        if (!other.domain_.isEmpty()) {
          if (domain_.isEmpty()) {
            domain_ = other.domain_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureDomainIsMutable();
            domain_.addAll(other.domain_);
          }
          onChanged();
        }
      } else {
        if (!other.domain_.isEmpty()) {
          if (domainBuilder_.isEmpty()) {
            domainBuilder_.dispose();
            domainBuilder_ = null;
            domain_ = other.domain_;
            bitField0_ = (bitField0_ & ~0x00000040);
            domainBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDomainFieldBuilder() : null;
          } else {
            domainBuilder_.addAllMessages(other.domain_);
          }
        }
      }
      if (other.hasPlan()) {
        mergePlan(other.getPlan());
      }
      if (!other.getAuthId().isEmpty()) {
        authId_ = other.authId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.repoProvider_ != 0) {
        setRepoProviderValue(other.getRepoProviderValue());
      }
      if (!other.getRepoProviderOrg().isEmpty()) {
        repoProviderOrg_ = other.repoProviderOrg_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.getSuspended() != false) {
        setSuspended(other.getSuspended());
      }
      if (!other.getDirectoryOrgLive().isEmpty()) {
        directoryOrgLive_ = other.directoryOrgLive_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getDirectoryOrgSandbox().isEmpty()) {
        directoryOrgSandbox_ = other.directoryOrgSandbox_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.getSubscriptionId().isEmpty()) {
        subscriptionId_ = other.subscriptionId_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.getLocale().isEmpty()) {
        locale_ = other.locale_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.getTimezone().isEmpty()) {
        timezone_ = other.timezone_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasUpdatedAt()) {
        mergeUpdatedAt(other.getUpdatedAt());
      }
      if (other.hasCreatedAt()) {
        mergeCreatedAt(other.getCreatedAt());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              input.readMessage(
                  getKeyFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              uuid_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 26: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 26
            case 34: {
              displayName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000008;
              break;
            } // case 34
            case 40: {
              active_ = input.readBool();
              bitField0_ |= 0x00000010;
              break;
            } // case 40
            case 50: {
              input.readMessage(
                  getBrandingFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000020;
              break;
            } // case 50
            case 58: {
              com.buildless.Tenant.TenantDomain m =
                  input.readMessage(
                      com.buildless.Tenant.TenantDomain.parser(),
                      extensionRegistry);
              if (domainBuilder_ == null) {
                ensureDomainIsMutable();
                domain_.add(m);
              } else {
                domainBuilder_.addMessage(m);
              }
              break;
            } // case 58
            case 66: {
              input.readMessage(
                  getPlanFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000080;
              break;
            } // case 66
            case 74: {
              authId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000100;
              break;
            } // case 74
            case 80: {
              repoProvider_ = input.readEnum();
              bitField0_ |= 0x00000200;
              break;
            } // case 80
            case 90: {
              repoProviderOrg_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000400;
              break;
            } // case 90
            case 96: {
              suspended_ = input.readBool();
              bitField0_ |= 0x00000800;
              break;
            } // case 96
            case 106: {
              directoryOrgLive_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00001000;
              break;
            } // case 106
            case 114: {
              directoryOrgSandbox_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00002000;
              break;
            } // case 114
            case 122: {
              subscriptionId_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00004000;
              break;
            } // case 122
            case 130: {
              locale_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00008000;
              break;
            } // case 130
            case 138: {
              timezone_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00010000;
              break;
            } // case 138
            case 786: {
              input.readMessage(
                  getUpdatedAtFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00020000;
              break;
            } // case 786
            case 794: {
              input.readMessage(
                  getCreatedAtFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00040000;
              break;
            } // case 794
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private com.buildless.Tenant.TenantKey key_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.buildless.Tenant.TenantKey, com.buildless.Tenant.TenantKey.Builder, com.buildless.Tenant.TenantKeyOrBuilder> keyBuilder_;
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     * @return Whether the key field is set.
     */
    public boolean hasKey() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     * @return The key.
     */
    public com.buildless.Tenant.TenantKey getKey() {
      if (keyBuilder_ == null) {
        return key_ == null ? com.buildless.Tenant.TenantKey.getDefaultInstance() : key_;
      } else {
        return keyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     */
    public Builder setKey(com.buildless.Tenant.TenantKey value) {
      if (keyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
      } else {
        keyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     */
    public Builder setKey(
        com.buildless.Tenant.TenantKey.Builder builderForValue) {
      if (keyBuilder_ == null) {
        key_ = builderForValue.build();
      } else {
        keyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     */
    public Builder mergeKey(com.buildless.Tenant.TenantKey value) {
      if (keyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0) &&
          key_ != null &&
          key_ != com.buildless.Tenant.TenantKey.getDefaultInstance()) {
          getKeyBuilder().mergeFrom(value);
        } else {
          key_ = value;
        }
      } else {
        keyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     */
    public Builder clearKey() {
      bitField0_ = (bitField0_ & ~0x00000001);
      key_ = null;
      if (keyBuilder_ != null) {
        keyBuilder_.dispose();
        keyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     */
    public com.buildless.Tenant.TenantKey.Builder getKeyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getKeyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     */
    public com.buildless.Tenant.TenantKeyOrBuilder getKeyOrBuilder() {
      if (keyBuilder_ != null) {
        return keyBuilder_.getMessageOrBuilder();
      } else {
        return key_ == null ?
            com.buildless.Tenant.TenantKey.getDefaultInstance() : key_;
      }
    }
    /**
     * <pre>
     * Specifies the record key for this tenant, which includes all components of the tenant's primary key.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantKey key = 1 [json_name = "key", (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY, (.elide.model.field) = { ... }</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.buildless.Tenant.TenantKey, com.buildless.Tenant.TenantKey.Builder, com.buildless.Tenant.TenantKeyOrBuilder> 
        getKeyFieldBuilder() {
      if (keyBuilder_ == null) {
        keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.buildless.Tenant.TenantKey, com.buildless.Tenant.TenantKey.Builder, com.buildless.Tenant.TenantKeyOrBuilder>(
                getKey(),
                getParentForChildren(),
                isClean());
        key_ = null;
      }
      return keyBuilder_;
    }

    private java.lang.Object uuid_ = "";
    /**
     * <pre>
     * Specifies a unique ID for the tenant which is not shared publicly. This tenant UUID value is used to tie a tenant
     * record to external management and billing systems. The Tenant UUID is not sensitive, but is considered internal.
     * The Tenant UUID is globally unique.
     * </pre>
     *
     * <code>string uuid = 2 [json_name = "uuid", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The uuid.
     */
    public java.lang.String getUuid() {
      java.lang.Object ref = uuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specifies a unique ID for the tenant which is not shared publicly. This tenant UUID value is used to tie a tenant
     * record to external management and billing systems. The Tenant UUID is not sensitive, but is considered internal.
     * The Tenant UUID is globally unique.
     * </pre>
     *
     * <code>string uuid = 2 [json_name = "uuid", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for uuid.
     */
    public com.google.protobuf.ByteString
        getUuidBytes() {
      java.lang.Object ref = uuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specifies a unique ID for the tenant which is not shared publicly. This tenant UUID value is used to tie a tenant
     * record to external management and billing systems. The Tenant UUID is not sensitive, but is considered internal.
     * The Tenant UUID is globally unique.
     * </pre>
     *
     * <code>string uuid = 2 [json_name = "uuid", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuid(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      uuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a unique ID for the tenant which is not shared publicly. This tenant UUID value is used to tie a tenant
     * record to external management and billing systems. The Tenant UUID is not sensitive, but is considered internal.
     * The Tenant UUID is globally unique.
     * </pre>
     *
     * <code>string uuid = 2 [json_name = "uuid", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearUuid() {
      uuid_ = getDefaultInstance().getUuid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a unique ID for the tenant which is not shared publicly. This tenant UUID value is used to tie a tenant
     * record to external management and billing systems. The Tenant UUID is not sensitive, but is considered internal.
     * The Tenant UUID is globally unique.
     * </pre>
     *
     * <code>string uuid = 2 [json_name = "uuid", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuidBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      uuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Short-name for this tenant, which should be a string of length 2-32 characters. The name is also referred to as the
     * "short name." This name is used in sub-domains, so it must be a DNS-compatible name. Globally unique.
     * </pre>
     *
     * <code>string name = 3 [json_name = "name", (.google.api.field_behavior) = IMMUTABLE, (.validate.rules) = { ... }</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Short-name for this tenant, which should be a string of length 2-32 characters. The name is also referred to as the
     * "short name." This name is used in sub-domains, so it must be a DNS-compatible name. Globally unique.
     * </pre>
     *
     * <code>string name = 3 [json_name = "name", (.google.api.field_behavior) = IMMUTABLE, (.validate.rules) = { ... }</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Short-name for this tenant, which should be a string of length 2-32 characters. The name is also referred to as the
     * "short name." This name is used in sub-domains, so it must be a DNS-compatible name. Globally unique.
     * </pre>
     *
     * <code>string name = 3 [json_name = "name", (.google.api.field_behavior) = IMMUTABLE, (.validate.rules) = { ... }</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Short-name for this tenant, which should be a string of length 2-32 characters. The name is also referred to as the
     * "short name." This name is used in sub-domains, so it must be a DNS-compatible name. Globally unique.
     * </pre>
     *
     * <code>string name = 3 [json_name = "name", (.google.api.field_behavior) = IMMUTABLE, (.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Short-name for this tenant, which should be a string of length 2-32 characters. The name is also referred to as the
     * "short name." This name is used in sub-domains, so it must be a DNS-compatible name. Globally unique.
     * </pre>
     *
     * <code>string name = 3 [json_name = "name", (.google.api.field_behavior) = IMMUTABLE, (.validate.rules) = { ... }</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     * <pre>
     * Display name for this tenant. Can be any string value between 2-32 characters. The label is shown in user-facing
     * interfaces to identify a given tenant account.
     * </pre>
     *
     * <code>string display_name = 4 [json_name = "displayName", (.validate.rules) = { ... }</code>
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Display name for this tenant. Can be any string value between 2-32 characters. The label is shown in user-facing
     * interfaces to identify a given tenant account.
     * </pre>
     *
     * <code>string display_name = 4 [json_name = "displayName", (.validate.rules) = { ... }</code>
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString
        getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Display name for this tenant. Can be any string value between 2-32 characters. The label is shown in user-facing
     * interfaces to identify a given tenant account.
     * </pre>
     *
     * <code>string display_name = 4 [json_name = "displayName", (.validate.rules) = { ... }</code>
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Display name for this tenant. Can be any string value between 2-32 characters. The label is shown in user-facing
     * interfaces to identify a given tenant account.
     * </pre>
     *
     * <code>string display_name = 4 [json_name = "displayName", (.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Display name for this tenant. Can be any string value between 2-32 characters. The label is shown in user-facing
     * interfaces to identify a given tenant account.
     * </pre>
     *
     * <code>string display_name = 4 [json_name = "displayName", (.validate.rules) = { ... }</code>
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean active_ ;
    /**
     * <pre>
     * Whether this account is considered active. If an account is inactive, users and resources associated with the
     * tenant are not accessible. Inactive accounts are scheduled for deletion after a period of time.
     * </pre>
     *
     * <code>bool active = 5 [json_name = "active", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The active.
     */
    @java.lang.Override
    public boolean getActive() {
      return active_;
    }
    /**
     * <pre>
     * Whether this account is considered active. If an account is inactive, users and resources associated with the
     * tenant are not accessible. Inactive accounts are scheduled for deletion after a period of time.
     * </pre>
     *
     * <code>bool active = 5 [json_name = "active", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The active to set.
     * @return This builder for chaining.
     */
    public Builder setActive(boolean value) {

      active_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this account is considered active. If an account is inactive, users and resources associated with the
     * tenant are not accessible. Inactive accounts are scheduled for deletion after a period of time.
     * </pre>
     *
     * <code>bool active = 5 [json_name = "active", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearActive() {
      bitField0_ = (bitField0_ & ~0x00000010);
      active_ = false;
      onChanged();
      return this;
    }

    private com.buildless.Tenant.TenantBranding branding_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.buildless.Tenant.TenantBranding, com.buildless.Tenant.TenantBranding.Builder, com.buildless.Tenant.TenantBrandingOrBuilder> brandingBuilder_;
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return Whether the branding field is set.
     */
    public boolean hasBranding() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The branding.
     */
    public com.buildless.Tenant.TenantBranding getBranding() {
      if (brandingBuilder_ == null) {
        return branding_ == null ? com.buildless.Tenant.TenantBranding.getDefaultInstance() : branding_;
      } else {
        return brandingBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setBranding(com.buildless.Tenant.TenantBranding value) {
      if (brandingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        branding_ = value;
      } else {
        brandingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setBranding(
        com.buildless.Tenant.TenantBranding.Builder builderForValue) {
      if (brandingBuilder_ == null) {
        branding_ = builderForValue.build();
      } else {
        brandingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeBranding(com.buildless.Tenant.TenantBranding value) {
      if (brandingBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0) &&
          branding_ != null &&
          branding_ != com.buildless.Tenant.TenantBranding.getDefaultInstance()) {
          getBrandingBuilder().mergeFrom(value);
        } else {
          branding_ = value;
        }
      } else {
        brandingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearBranding() {
      bitField0_ = (bitField0_ & ~0x00000020);
      branding_ = null;
      if (brandingBuilder_ != null) {
        brandingBuilder_.dispose();
        brandingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.buildless.Tenant.TenantBranding.Builder getBrandingBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getBrandingFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.buildless.Tenant.TenantBrandingOrBuilder getBrandingOrBuilder() {
      if (brandingBuilder_ != null) {
        return brandingBuilder_.getMessageOrBuilder();
      } else {
        return branding_ == null ?
            com.buildless.Tenant.TenantBranding.getDefaultInstance() : branding_;
      }
    }
    /**
     * <pre>
     * Customizes the Buildless UI with tenant colors, logos, icons, and so on. Optional. Only present for tenants which
     * have a supporting plan and choose to customize branding.
     * </pre>
     *
     * <code>.buildless.Tenant.TenantBranding branding = 6 [json_name = "branding", (.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.buildless.Tenant.TenantBranding, com.buildless.Tenant.TenantBranding.Builder, com.buildless.Tenant.TenantBrandingOrBuilder> 
        getBrandingFieldBuilder() {
      if (brandingBuilder_ == null) {
        brandingBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.buildless.Tenant.TenantBranding, com.buildless.Tenant.TenantBranding.Builder, com.buildless.Tenant.TenantBrandingOrBuilder>(
                getBranding(),
                getParentForChildren(),
                isClean());
        branding_ = null;
      }
      return brandingBuilder_;
    }

    private java.util.List<com.buildless.Tenant.TenantDomain> domain_ =
      java.util.Collections.emptyList();
    private void ensureDomainIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        domain_ = new java.util.ArrayList<com.buildless.Tenant.TenantDomain>(domain_);
        bitField0_ |= 0x00000040;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.buildless.Tenant.TenantDomain, com.buildless.Tenant.TenantDomain.Builder, com.buildless.Tenant.TenantDomainOrBuilder> domainBuilder_;

    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public java.util.List<com.buildless.Tenant.TenantDomain> getDomainList() {
      if (domainBuilder_ == null) {
        return java.util.Collections.unmodifiableList(domain_);
      } else {
        return domainBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public int getDomainCount() {
      if (domainBuilder_ == null) {
        return domain_.size();
      } else {
        return domainBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public com.buildless.Tenant.TenantDomain getDomain(int index) {
      if (domainBuilder_ == null) {
        return domain_.get(index);
      } else {
        return domainBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder setDomain(
        int index, com.buildless.Tenant.TenantDomain value) {
      if (domainBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDomainIsMutable();
        domain_.set(index, value);
        onChanged();
      } else {
        domainBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder setDomain(
        int index, com.buildless.Tenant.TenantDomain.Builder builderForValue) {
      if (domainBuilder_ == null) {
        ensureDomainIsMutable();
        domain_.set(index, builderForValue.build());
        onChanged();
      } else {
        domainBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder addDomain(com.buildless.Tenant.TenantDomain value) {
      if (domainBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDomainIsMutable();
        domain_.add(value);
        onChanged();
      } else {
        domainBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder addDomain(
        int index, com.buildless.Tenant.TenantDomain value) {
      if (domainBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDomainIsMutable();
        domain_.add(index, value);
        onChanged();
      } else {
        domainBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder addDomain(
        com.buildless.Tenant.TenantDomain.Builder builderForValue) {
      if (domainBuilder_ == null) {
        ensureDomainIsMutable();
        domain_.add(builderForValue.build());
        onChanged();
      } else {
        domainBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder addDomain(
        int index, com.buildless.Tenant.TenantDomain.Builder builderForValue) {
      if (domainBuilder_ == null) {
        ensureDomainIsMutable();
        domain_.add(index, builderForValue.build());
        onChanged();
      } else {
        domainBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder addAllDomain(
        java.lang.Iterable<? extends com.buildless.Tenant.TenantDomain> values) {
      if (domainBuilder_ == null) {
        ensureDomainIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, domain_);
        onChanged();
      } else {
        domainBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder clearDomain() {
      if (domainBuilder_ == null) {
        domain_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        domainBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public Builder removeDomain(int index) {
      if (domainBuilder_ == null) {
        ensureDomainIsMutable();
        domain_.remove(index);
        onChanged();
      } else {
        domainBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public com.buildless.Tenant.TenantDomain.Builder getDomainBuilder(
        int index) {
      return getDomainFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public com.buildless.Tenant.TenantDomainOrBuilder getDomainOrBuilder(
        int index) {
      if (domainBuilder_ == null) {
        return domain_.get(index);  } else {
        return domainBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public java.util.List<? extends com.buildless.Tenant.TenantDomainOrBuilder> 
         getDomainOrBuilderList() {
      if (domainBuilder_ != null) {
        return domainBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(domain_);
      }
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public com.buildless.Tenant.TenantDomain.Builder addDomainBuilder() {
      return getDomainFieldBuilder().addBuilder(
          com.buildless.Tenant.TenantDomain.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public com.buildless.Tenant.TenantDomain.Builder addDomainBuilder(
        int index) {
      return getDomainFieldBuilder().addBuilder(
          index, com.buildless.Tenant.TenantDomain.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies custom domains which are linked to this tenant. These records are only present if the tenant has chosen
     * to link domains, and if their plan supports it.
     * </pre>
     *
     * <code>repeated .buildless.Tenant.TenantDomain domain = 7 [json_name = "domain", (.elide.model.collection) = { ... }</code>
     */
    public java.util.List<com.buildless.Tenant.TenantDomain.Builder> 
         getDomainBuilderList() {
      return getDomainFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.buildless.Tenant.TenantDomain, com.buildless.Tenant.TenantDomain.Builder, com.buildless.Tenant.TenantDomainOrBuilder> 
        getDomainFieldBuilder() {
      if (domainBuilder_ == null) {
        domainBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.buildless.Tenant.TenantDomain, com.buildless.Tenant.TenantDomain.Builder, com.buildless.Tenant.TenantDomainOrBuilder>(
                domain_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        domain_ = null;
      }
      return domainBuilder_;
    }

    private com.buildless.billing.TenantPlanInfo plan_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.buildless.billing.TenantPlanInfo, com.buildless.billing.TenantPlanInfo.Builder, com.buildless.billing.TenantPlanInfoOrBuilder> planBuilder_;
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the plan field is set.
     */
    public boolean hasPlan() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The plan.
     */
    public com.buildless.billing.TenantPlanInfo getPlan() {
      if (planBuilder_ == null) {
        return plan_ == null ? com.buildless.billing.TenantPlanInfo.getDefaultInstance() : plan_;
      } else {
        return planBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPlan(com.buildless.billing.TenantPlanInfo value) {
      if (planBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        plan_ = value;
      } else {
        planBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPlan(
        com.buildless.billing.TenantPlanInfo.Builder builderForValue) {
      if (planBuilder_ == null) {
        plan_ = builderForValue.build();
      } else {
        planBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergePlan(com.buildless.billing.TenantPlanInfo value) {
      if (planBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0) &&
          plan_ != null &&
          plan_ != com.buildless.billing.TenantPlanInfo.getDefaultInstance()) {
          getPlanBuilder().mergeFrom(value);
        } else {
          plan_ = value;
        }
      } else {
        planBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearPlan() {
      bitField0_ = (bitField0_ & ~0x00000080);
      plan_ = null;
      if (planBuilder_ != null) {
        planBuilder_.dispose();
        planBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.buildless.billing.TenantPlanInfo.Builder getPlanBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPlanFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.buildless.billing.TenantPlanInfoOrBuilder getPlanOrBuilder() {
      if (planBuilder_ != null) {
        return planBuilder_.getMessageOrBuilder();
      } else {
        return plan_ == null ?
            com.buildless.billing.TenantPlanInfo.getDefaultInstance() : plan_;
      }
    }
    /**
     * <pre>
     * Plan info for this tenant, indicating their main subscription level and additional add-on entitlements, if any.
     * </pre>
     *
     * <code>.buildless.billing.TenantPlanInfo plan = 8 [json_name = "plan", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.buildless.billing.TenantPlanInfo, com.buildless.billing.TenantPlanInfo.Builder, com.buildless.billing.TenantPlanInfoOrBuilder> 
        getPlanFieldBuilder() {
      if (planBuilder_ == null) {
        planBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.buildless.billing.TenantPlanInfo, com.buildless.billing.TenantPlanInfo.Builder, com.buildless.billing.TenantPlanInfoOrBuilder>(
                getPlan(),
                getParentForChildren(),
                isClean());
        plan_ = null;
      }
      return planBuilder_;
    }

    private java.lang.Object authId_ = "";
    /**
     * <pre>
     * Specifies the linked authorization tenant for this org tenant record. The authorization tenant holds users and
     * roles for a given tenant record.
     * </pre>
     *
     * <code>string auth_id = 9 [json_name = "authId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The authId.
     */
    public java.lang.String getAuthId() {
      java.lang.Object ref = authId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specifies the linked authorization tenant for this org tenant record. The authorization tenant holds users and
     * roles for a given tenant record.
     * </pre>
     *
     * <code>string auth_id = 9 [json_name = "authId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for authId.
     */
    public com.google.protobuf.ByteString
        getAuthIdBytes() {
      java.lang.Object ref = authId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        authId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specifies the linked authorization tenant for this org tenant record. The authorization tenant holds users and
     * roles for a given tenant record.
     * </pre>
     *
     * <code>string auth_id = 9 [json_name = "authId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The authId to set.
     * @return This builder for chaining.
     */
    public Builder setAuthId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      authId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the linked authorization tenant for this org tenant record. The authorization tenant holds users and
     * roles for a given tenant record.
     * </pre>
     *
     * <code>string auth_id = 9 [json_name = "authId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearAuthId() {
      authId_ = getDefaultInstance().getAuthId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the linked authorization tenant for this org tenant record. The authorization tenant holds users and
     * roles for a given tenant record.
     * </pre>
     *
     * <code>string auth_id = 9 [json_name = "authId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for authId to set.
     * @return This builder for chaining.
     */
    public Builder setAuthIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      authId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int repoProvider_ = 0;
    /**
     * <pre>
     * Specifies the main repository provider for this tenant. This is mostly a cosmetic setting, but it also governs
     * which repositories are shown by default as options to add in the UI.
     * </pre>
     *
     * <code>.buildless.code.RepositoryProvider repo_provider = 10 [json_name = "repoProvider"];</code>
     * @return The enum numeric value on the wire for repoProvider.
     */
    @java.lang.Override public int getRepoProviderValue() {
      return repoProvider_;
    }
    /**
     * <pre>
     * Specifies the main repository provider for this tenant. This is mostly a cosmetic setting, but it also governs
     * which repositories are shown by default as options to add in the UI.
     * </pre>
     *
     * <code>.buildless.code.RepositoryProvider repo_provider = 10 [json_name = "repoProvider"];</code>
     * @param value The enum numeric value on the wire for repoProvider to set.
     * @return This builder for chaining.
     */
    public Builder setRepoProviderValue(int value) {
      repoProvider_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the main repository provider for this tenant. This is mostly a cosmetic setting, but it also governs
     * which repositories are shown by default as options to add in the UI.
     * </pre>
     *
     * <code>.buildless.code.RepositoryProvider repo_provider = 10 [json_name = "repoProvider"];</code>
     * @return The repoProvider.
     */
    @java.lang.Override
    public com.buildless.code.RepositoryProvider getRepoProvider() {
      com.buildless.code.RepositoryProvider result = com.buildless.code.RepositoryProvider.forNumber(repoProvider_);
      return result == null ? com.buildless.code.RepositoryProvider.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the main repository provider for this tenant. This is mostly a cosmetic setting, but it also governs
     * which repositories are shown by default as options to add in the UI.
     * </pre>
     *
     * <code>.buildless.code.RepositoryProvider repo_provider = 10 [json_name = "repoProvider"];</code>
     * @param value The repoProvider to set.
     * @return This builder for chaining.
     */
    public Builder setRepoProvider(com.buildless.code.RepositoryProvider value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      repoProvider_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the main repository provider for this tenant. This is mostly a cosmetic setting, but it also governs
     * which repositories are shown by default as options to add in the UI.
     * </pre>
     *
     * <code>.buildless.code.RepositoryProvider repo_provider = 10 [json_name = "repoProvider"];</code>
     * @return This builder for chaining.
     */
    public Builder clearRepoProvider() {
      bitField0_ = (bitField0_ & ~0x00000200);
      repoProvider_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object repoProviderOrg_ = "";
    /**
     * <pre>
     * Specifies the name of the organization in the context of their repository provider (for example, their GitHub org
     * name). This is both used cosmetically in the UI and used as a hint for repository discovery.
     * </pre>
     *
     * <code>string repo_provider_org = 11 [json_name = "repoProviderOrg", (.validate.rules) = { ... }</code>
     * @return The repoProviderOrg.
     */
    public java.lang.String getRepoProviderOrg() {
      java.lang.Object ref = repoProviderOrg_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repoProviderOrg_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specifies the name of the organization in the context of their repository provider (for example, their GitHub org
     * name). This is both used cosmetically in the UI and used as a hint for repository discovery.
     * </pre>
     *
     * <code>string repo_provider_org = 11 [json_name = "repoProviderOrg", (.validate.rules) = { ... }</code>
     * @return The bytes for repoProviderOrg.
     */
    public com.google.protobuf.ByteString
        getRepoProviderOrgBytes() {
      java.lang.Object ref = repoProviderOrg_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        repoProviderOrg_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specifies the name of the organization in the context of their repository provider (for example, their GitHub org
     * name). This is both used cosmetically in the UI and used as a hint for repository discovery.
     * </pre>
     *
     * <code>string repo_provider_org = 11 [json_name = "repoProviderOrg", (.validate.rules) = { ... }</code>
     * @param value The repoProviderOrg to set.
     * @return This builder for chaining.
     */
    public Builder setRepoProviderOrg(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      repoProviderOrg_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the name of the organization in the context of their repository provider (for example, their GitHub org
     * name). This is both used cosmetically in the UI and used as a hint for repository discovery.
     * </pre>
     *
     * <code>string repo_provider_org = 11 [json_name = "repoProviderOrg", (.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearRepoProviderOrg() {
      repoProviderOrg_ = getDefaultInstance().getRepoProviderOrg();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the name of the organization in the context of their repository provider (for example, their GitHub org
     * name). This is both used cosmetically in the UI and used as a hint for repository discovery.
     * </pre>
     *
     * <code>string repo_provider_org = 11 [json_name = "repoProviderOrg", (.validate.rules) = { ... }</code>
     * @param value The bytes for repoProviderOrg to set.
     * @return This builder for chaining.
     */
    public Builder setRepoProviderOrgBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      repoProviderOrg_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private boolean suspended_ ;
    /**
     * <pre>
     * Flipped to `true` if an organization is scheduled for deletion, or if it has been suspended due to lack of payment
     * or other administrative action. In this case, `active` will be set to `false`.
     * </pre>
     *
     * <code>bool suspended = 12 [json_name = "suspended", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The suspended.
     */
    @java.lang.Override
    public boolean getSuspended() {
      return suspended_;
    }
    /**
     * <pre>
     * Flipped to `true` if an organization is scheduled for deletion, or if it has been suspended due to lack of payment
     * or other administrative action. In this case, `active` will be set to `false`.
     * </pre>
     *
     * <code>bool suspended = 12 [json_name = "suspended", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The suspended to set.
     * @return This builder for chaining.
     */
    public Builder setSuspended(boolean value) {

      suspended_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Flipped to `true` if an organization is scheduled for deletion, or if it has been suspended due to lack of payment
     * or other administrative action. In this case, `active` will be set to `false`.
     * </pre>
     *
     * <code>bool suspended = 12 [json_name = "suspended", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearSuspended() {
      bitField0_ = (bitField0_ & ~0x00000800);
      suspended_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object directoryOrgLive_ = "";
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for live sync
     * of users, groups, and roles. Other features such as Log Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_live = 13 [json_name = "directoryOrgLive", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The directoryOrgLive.
     */
    public java.lang.String getDirectoryOrgLive() {
      java.lang.Object ref = directoryOrgLive_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        directoryOrgLive_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for live sync
     * of users, groups, and roles. Other features such as Log Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_live = 13 [json_name = "directoryOrgLive", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for directoryOrgLive.
     */
    public com.google.protobuf.ByteString
        getDirectoryOrgLiveBytes() {
      java.lang.Object ref = directoryOrgLive_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        directoryOrgLive_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for live sync
     * of users, groups, and roles. Other features such as Log Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_live = 13 [json_name = "directoryOrgLive", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The directoryOrgLive to set.
     * @return This builder for chaining.
     */
    public Builder setDirectoryOrgLive(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      directoryOrgLive_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for live sync
     * of users, groups, and roles. Other features such as Log Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_live = 13 [json_name = "directoryOrgLive", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearDirectoryOrgLive() {
      directoryOrgLive_ = getDefaultInstance().getDirectoryOrgLive();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for live sync
     * of users, groups, and roles. Other features such as Log Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_live = 13 [json_name = "directoryOrgLive", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for directoryOrgLive to set.
     * @return This builder for chaining.
     */
    public Builder setDirectoryOrgLiveBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      directoryOrgLive_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object directoryOrgSandbox_ = "";
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for sandbox
     * sync of users, groups, and roles (see `directory_org_live` for production use). Other features such as Log
     * Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_sandbox = 14 [json_name = "directoryOrgSandbox", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The directoryOrgSandbox.
     */
    public java.lang.String getDirectoryOrgSandbox() {
      java.lang.Object ref = directoryOrgSandbox_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        directoryOrgSandbox_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for sandbox
     * sync of users, groups, and roles (see `directory_org_live` for production use). Other features such as Log
     * Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_sandbox = 14 [json_name = "directoryOrgSandbox", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for directoryOrgSandbox.
     */
    public com.google.protobuf.ByteString
        getDirectoryOrgSandboxBytes() {
      java.lang.Object ref = directoryOrgSandbox_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        directoryOrgSandbox_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for sandbox
     * sync of users, groups, and roles (see `directory_org_live` for production use). Other features such as Log
     * Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_sandbox = 14 [json_name = "directoryOrgSandbox", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The directoryOrgSandbox to set.
     * @return This builder for chaining.
     */
    public Builder setDirectoryOrgSandbox(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      directoryOrgSandbox_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for sandbox
     * sync of users, groups, and roles (see `directory_org_live` for production use). Other features such as Log
     * Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_sandbox = 14 [json_name = "directoryOrgSandbox", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearDirectoryOrgSandbox() {
      directoryOrgSandbox_ = getDefaultInstance().getDirectoryOrgSandbox();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies this organization's ID for use with directory integrations; specifically, this ID is used for sandbox
     * sync of users, groups, and roles (see `directory_org_live` for production use). Other features such as Log
     * Streaming may also leverage this ID.
     * </pre>
     *
     * <code>string directory_org_sandbox = 14 [json_name = "directoryOrgSandbox", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for directoryOrgSandbox to set.
     * @return This builder for chaining.
     */
    public Builder setDirectoryOrgSandboxBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      directoryOrgSandbox_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object subscriptionId_ = "";
    /**
     * <pre>
     * ID generated for this tenant's active subscription by the billing system. This ID is always present for active
     * (non-suspended) tenants.
     * </pre>
     *
     * <code>string subscription_id = 15 [json_name = "subscriptionId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The subscriptionId.
     */
    public java.lang.String getSubscriptionId() {
      java.lang.Object ref = subscriptionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subscriptionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * ID generated for this tenant's active subscription by the billing system. This ID is always present for active
     * (non-suspended) tenants.
     * </pre>
     *
     * <code>string subscription_id = 15 [json_name = "subscriptionId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for subscriptionId.
     */
    public com.google.protobuf.ByteString
        getSubscriptionIdBytes() {
      java.lang.Object ref = subscriptionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        subscriptionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * ID generated for this tenant's active subscription by the billing system. This ID is always present for active
     * (non-suspended) tenants.
     * </pre>
     *
     * <code>string subscription_id = 15 [json_name = "subscriptionId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The subscriptionId to set.
     * @return This builder for chaining.
     */
    public Builder setSubscriptionId(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      subscriptionId_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * ID generated for this tenant's active subscription by the billing system. This ID is always present for active
     * (non-suspended) tenants.
     * </pre>
     *
     * <code>string subscription_id = 15 [json_name = "subscriptionId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearSubscriptionId() {
      subscriptionId_ = getDefaultInstance().getSubscriptionId();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * ID generated for this tenant's active subscription by the billing system. This ID is always present for active
     * (non-suspended) tenants.
     * </pre>
     *
     * <code>string subscription_id = 15 [json_name = "subscriptionId", (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for subscriptionId to set.
     * @return This builder for chaining.
     */
    public Builder setSubscriptionIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      subscriptionId_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object locale_ = "";
    /**
     * <pre>
     * Locale to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string locale = 16 [json_name = "locale", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The locale.
     */
    public java.lang.String getLocale() {
      java.lang.Object ref = locale_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locale_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Locale to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string locale = 16 [json_name = "locale", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The bytes for locale.
     */
    public com.google.protobuf.ByteString
        getLocaleBytes() {
      java.lang.Object ref = locale_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        locale_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Locale to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string locale = 16 [json_name = "locale", (.google.api.field_behavior) = OPTIONAL];</code>
     * @param value The locale to set.
     * @return This builder for chaining.
     */
    public Builder setLocale(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      locale_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Locale to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string locale = 16 [json_name = "locale", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return This builder for chaining.
     */
    public Builder clearLocale() {
      locale_ = getDefaultInstance().getLocale();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Locale to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string locale = 16 [json_name = "locale", (.google.api.field_behavior) = OPTIONAL];</code>
     * @param value The bytes for locale to set.
     * @return This builder for chaining.
     */
    public Builder setLocaleBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      locale_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object timezone_ = "";
    /**
     * <pre>
     * Timezone to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string timezone = 17 [json_name = "timezone", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The timezone.
     */
    public java.lang.String getTimezone() {
      java.lang.Object ref = timezone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timezone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Timezone to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string timezone = 17 [json_name = "timezone", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return The bytes for timezone.
     */
    public com.google.protobuf.ByteString
        getTimezoneBytes() {
      java.lang.Object ref = timezone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        timezone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Timezone to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string timezone = 17 [json_name = "timezone", (.google.api.field_behavior) = OPTIONAL];</code>
     * @param value The timezone to set.
     * @return This builder for chaining.
     */
    public Builder setTimezone(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      timezone_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timezone to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string timezone = 17 [json_name = "timezone", (.google.api.field_behavior) = OPTIONAL];</code>
     * @return This builder for chaining.
     */
    public Builder clearTimezone() {
      timezone_ = getDefaultInstance().getTimezone();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timezone to default to for users who are managed by this tenant, and for tenant-level settings, UI, and operations.
     * </pre>
     *
     * <code>string timezone = 17 [json_name = "timezone", (.google.api.field_behavior) = OPTIONAL];</code>
     * @param value The bytes for timezone to set.
     * @return This builder for chaining.
     */
    public Builder setTimezoneBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      timezone_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updatedAt_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> updatedAtBuilder_;
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     * @return Whether the updatedAt field is set.
     */
    public boolean hasUpdatedAt() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     * @return The updatedAt.
     */
    public com.google.protobuf.Timestamp getUpdatedAt() {
      if (updatedAtBuilder_ == null) {
        return updatedAt_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updatedAt_;
      } else {
        return updatedAtBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     */
    public Builder setUpdatedAt(com.google.protobuf.Timestamp value) {
      if (updatedAtBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updatedAt_ = value;
      } else {
        updatedAtBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     */
    public Builder setUpdatedAt(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updatedAtBuilder_ == null) {
        updatedAt_ = builderForValue.build();
      } else {
        updatedAtBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     */
    public Builder mergeUpdatedAt(com.google.protobuf.Timestamp value) {
      if (updatedAtBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0) &&
          updatedAt_ != null &&
          updatedAt_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdatedAtBuilder().mergeFrom(value);
        } else {
          updatedAt_ = value;
        }
      } else {
        updatedAtBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     */
    public Builder clearUpdatedAt() {
      bitField0_ = (bitField0_ & ~0x00020000);
      updatedAt_ = null;
      if (updatedAtBuilder_ != null) {
        updatedAtBuilder_.dispose();
        updatedAtBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdatedAtBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getUpdatedAtFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdatedAtOrBuilder() {
      if (updatedAtBuilder_ != null) {
        return updatedAtBuilder_.getMessageOrBuilder();
      } else {
        return updatedAt_ == null ?
            com.google.protobuf.Timestamp.getDefaultInstance() : updatedAt_;
      }
    }
    /**
     * <pre>
     * Timestamp indicating when this record was last updated. Any update to the tenant results in an update to this
     * timestamp field. At first creation, this value should be equal to the value held by `created_at`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp updated_at = 98 [json_name = "updatedAt", (.elide.model.field) = { ... }</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> 
        getUpdatedAtFieldBuilder() {
      if (updatedAtBuilder_ == null) {
        updatedAtBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                getUpdatedAt(),
                getParentForChildren(),
                isClean());
        updatedAt_ = null;
      }
      return updatedAtBuilder_;
    }

    private com.google.protobuf.Timestamp createdAt_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> createdAtBuilder_;
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     * @return Whether the createdAt field is set.
     */
    public boolean hasCreatedAt() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     * @return The createdAt.
     */
    public com.google.protobuf.Timestamp getCreatedAt() {
      if (createdAtBuilder_ == null) {
        return createdAt_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createdAt_;
      } else {
        return createdAtBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     */
    public Builder setCreatedAt(com.google.protobuf.Timestamp value) {
      if (createdAtBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createdAt_ = value;
      } else {
        createdAtBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     */
    public Builder setCreatedAt(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createdAtBuilder_ == null) {
        createdAt_ = builderForValue.build();
      } else {
        createdAtBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     */
    public Builder mergeCreatedAt(com.google.protobuf.Timestamp value) {
      if (createdAtBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0) &&
          createdAt_ != null &&
          createdAt_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreatedAtBuilder().mergeFrom(value);
        } else {
          createdAt_ = value;
        }
      } else {
        createdAtBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     */
    public Builder clearCreatedAt() {
      bitField0_ = (bitField0_ & ~0x00040000);
      createdAt_ = null;
      if (createdAtBuilder_ != null) {
        createdAtBuilder_.dispose();
        createdAtBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreatedAtBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getCreatedAtFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreatedAtOrBuilder() {
      if (createdAtBuilder_ != null) {
        return createdAtBuilder_.getMessageOrBuilder();
      } else {
        return createdAt_ == null ?
            com.google.protobuf.Timestamp.getDefaultInstance() : createdAt_;
      }
    }
    /**
     * <pre>
     * Timestamp indicating when this record was created. Any update to the tenant results in an update to this timestamp
     * field. This value is populated if a record has been stored, and is empty if a record has not yet been stored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 99 [json_name = "createdAt", (.elide.model.field) = { ... }</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> 
        getCreatedAtFieldBuilder() {
      if (createdAtBuilder_ == null) {
        createdAtBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                getCreatedAt(),
                getParentForChildren(),
                isClean());
        createdAt_ = null;
      }
      return createdAtBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:buildless.Tenant)
  }

  // @@protoc_insertion_point(class_scope:buildless.Tenant)
  private static final com.buildless.Tenant DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.buildless.Tenant();
  }

  public static com.buildless.Tenant getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Tenant>
      PARSER = new com.google.protobuf.AbstractParser<Tenant>() {
    @java.lang.Override
    public Tenant parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<Tenant> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Tenant> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.buildless.Tenant getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

