/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.expression;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.expression.CompiledProgram;
import build.buf.protovalidate.internal.expression.Variable;
import build.buf.validate.Violation;
import java.util.ArrayList;
import java.util.List;

public class CelPrograms
implements Evaluator {
    private final List<CompiledProgram> programs;

    public CelPrograms(List<CompiledProgram> compiledPrograms) {
        this.programs = compiledPrograms;
    }

    @Override
    public boolean tautology() {
        return this.programs.isEmpty();
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        Variable activation = Variable.newThisVariable(val.value(Object.class));
        ArrayList<Violation> violationList = new ArrayList<Violation>();
        for (CompiledProgram program : this.programs) {
            Violation violation = program.eval(activation);
            if (violation == null) continue;
            violationList.add(violation);
            if (!failFast) continue;
            break;
        }
        return new ValidationResult(violationList);
    }
}

