/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.ErrorPathUtils;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.validate.FieldConstraints;
import build.buf.validate.Violation;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class MapEvaluator
implements Evaluator {
    private final ValueEvaluator keyEvaluator = new ValueEvaluator();
    private final ValueEvaluator valueEvaluator = new ValueEvaluator();

    MapEvaluator(FieldConstraints fieldConstraints, Descriptors.FieldDescriptor fieldDescriptor) {
    }

    public ValueEvaluator getKeyEvaluator() {
        return this.keyEvaluator;
    }

    public ValueEvaluator getValueEvaluator() {
        return this.valueEvaluator;
    }

    @Override
    public boolean tautology() {
        return this.keyEvaluator.tautology() && this.valueEvaluator.tautology();
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        Map<Value, Value> mapValue = val.mapValue();
        for (Map.Entry<Value, Value> entry : mapValue.entrySet()) {
            violations.addAll(this.evalPairs(entry.getKey(), entry.getValue(), failFast));
            if (!failFast || violations.isEmpty()) continue;
            return new ValidationResult(violations);
        }
        if (violations.isEmpty()) {
            return ValidationResult.EMPTY;
        }
        return new ValidationResult(violations);
    }

    private List<Violation> evalPairs(Value key, Value value, boolean failFast) throws ExecutionException {
        List<Violation> keyViolations = this.keyEvaluator.evaluate(key, failFast).getViolations();
        List<Object> valueViolations = failFast && !keyViolations.isEmpty() ? Collections.emptyList() : this.valueEvaluator.evaluate(value, failFast).getViolations();
        if (keyViolations.isEmpty() && valueViolations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Violation> violations = new ArrayList<Violation>(keyViolations.size() + valueViolations.size());
        violations.addAll(keyViolations);
        violations.addAll(valueViolations);
        Object keyName = key.value(Object.class);
        if (keyName == null) {
            return Collections.emptyList();
        }
        List<Violation> prefixedViolations = keyName instanceof Number ? ErrorPathUtils.prefixErrorPaths(violations, "[%s]", keyName) : ErrorPathUtils.prefixErrorPaths(violations, "[\"%s\"]", keyName);
        return prefixedViolations;
    }
}

