/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.ErrorPathUtils;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.ObjectValue;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.validate.Violation;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class FieldEvaluator
implements Evaluator {
    public final ValueEvaluator valueEvaluator;
    private final Descriptors.FieldDescriptor descriptor;
    private final boolean required;
    private final boolean ignoreEmpty;
    private final boolean ignoreDefault;
    @Nullable
    private final Object zero;

    FieldEvaluator(ValueEvaluator valueEvaluator, Descriptors.FieldDescriptor descriptor, boolean required, boolean ignoreEmpty, boolean ignoreDefault, @Nullable Object zero) {
        this.valueEvaluator = valueEvaluator;
        this.descriptor = descriptor;
        this.required = required;
        this.ignoreEmpty = ignoreEmpty;
        this.ignoreDefault = ignoreDefault;
        this.zero = zero;
    }

    @Override
    public boolean tautology() {
        return !this.required && this.valueEvaluator.tautology();
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        Message message = val.messageValue();
        if (message == null) {
            return ValidationResult.EMPTY;
        }
        boolean hasField = this.descriptor.isRepeated() ? message.getRepeatedFieldCount(this.descriptor) != 0 : message.hasField(this.descriptor);
        if (this.required && !hasField) {
            return new ValidationResult(Collections.singletonList(Violation.newBuilder().setFieldPath(this.descriptor.getName()).setConstraintId("required").setMessage("value is required").build()));
        }
        if (this.ignoreEmpty && !hasField) {
            return ValidationResult.EMPTY;
        }
        Object fieldValue = message.getField(this.descriptor);
        if (this.ignoreDefault && Objects.equals(this.zero, fieldValue)) {
            return ValidationResult.EMPTY;
        }
        ValidationResult evalResult = this.valueEvaluator.evaluate(new ObjectValue(this.descriptor, fieldValue), failFast);
        List<Violation> violations = ErrorPathUtils.prefixErrorPaths(evalResult.getViolations(), "%s", this.descriptor.getName());
        return new ValidationResult(violations);
    }
}

